/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.qldb;

import com.amazon.ion.IonSystem;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.qldbsession.model.BadRequestException;
import software.amazon.awssdk.services.qldbsession.model.InvalidSessionException;
import software.amazon.awssdk.services.qldbsession.model.OccConflictException;
import software.amazon.awssdk.services.qldbsession.model.QldbSessionException;
import software.amazon.awssdk.services.qldbsession.model.StartTransactionResult;
import software.amazon.awssdk.utils.Validate;
import software.amazon.qldb.BufferedResult;
import software.amazon.qldb.ExecutionContext;
import software.amazon.qldb.Executor;
import software.amazon.qldb.Result;
import software.amazon.qldb.RetryPolicy;
import software.amazon.qldb.RetryPolicyContext;
import software.amazon.qldb.Session;
import software.amazon.qldb.StreamResult;
import software.amazon.qldb.Transaction;
import software.amazon.qldb.TransactionExecutor;
import software.amazon.qldb.exceptions.TransactionAbortedException;
import software.amazon.qldb.exceptions.TransactionAlreadyOpenException;

@NotThreadSafe
class QldbSession {
    private static final Logger logger = LoggerFactory.getLogger(QldbSession.class);
    private final int readAhead;
    private final ExecutorService executorService;
    private Session session;
    private final AtomicBoolean isClosed = new AtomicBoolean(true);
    private final IonSystem ionSystem;

    QldbSession(Session session, int readAhead, IonSystem ionSystem, ExecutorService executorService) {
        this.ionSystem = ionSystem;
        this.session = session;
        this.isClosed.set(false);
        this.readAhead = readAhead;
        this.executorService = executorService;
    }

    void close() {
        if (!this.isClosed.getAndSet(true)) {
            this.session.close();
        }
    }

    boolean isClosed() {
        return this.isClosed.get();
    }

    <T> T execute(Executor<T> executor, RetryPolicy retryPolicy, ExecutionContext executionContext) {
        Validate.paramNotNull(executor, (String)"executor");
        while (true) {
            Transaction transaction;
            block13: {
                executionContext.setLastException(null);
                transaction = null;
                try {
                    transaction = this.startTransaction();
                    Object returnedValue = executor.execute(new TransactionExecutor(transaction));
                    if (returnedValue instanceof StreamResult) {
                        returnedValue = new BufferedResult((Result)returnedValue);
                    }
                    transaction.commit();
                    return returnedValue;
                }
                catch (TransactionAlreadyOpenException taoe) {
                    this.noThrowAbort(transaction);
                    executionContext.setLastException((SdkException)taoe);
                    if (executionContext.retryAttempts() >= retryPolicy.maxRetries()) {
                        throw (BadRequestException)taoe.getCause();
                    }
                    logger.debug("Retrying the transaction. {} ", (Object)taoe.getMessage());
                }
                catch (TransactionAbortedException ae) {
                    this.noThrowAbort(transaction);
                    throw ae;
                }
                catch (InvalidSessionException ise) {
                    if (transaction != null) {
                        logger.warn("Transaction {} expired while executing. Cause {} ", (Object)transaction.getTransactionId(), (Object)ise.getMessage());
                    }
                    this.isClosed.set(true);
                    throw ise;
                }
                catch (OccConflictException occe) {
                    executionContext.setLastException((SdkException)occe);
                    if (executionContext.retryAttempts() >= retryPolicy.maxRetries()) {
                        throw occe;
                    }
                    logger.info("Retrying the transaction. {} ", (Object)occe.getMessage());
                }
                catch (QldbSessionException qse) {
                    executionContext.setLastException((SdkException)qse);
                    this.noThrowAbort(transaction);
                    if (executionContext.retryAttempts() >= retryPolicy.maxRetries() || qse.statusCode() != 500 && qse.statusCode() != 503) {
                        throw qse;
                    }
                }
                catch (SdkClientException sce) {
                    executionContext.setLastException((SdkException)sce);
                    this.noThrowAbort(transaction);
                    if (executionContext.retryAttempts() < retryPolicy.maxRetries()) break block13;
                    throw sce;
                }
            }
            executionContext.increaseAttempt();
            this.retrySleep(executionContext, transaction, retryPolicy);
        }
    }

    String getSessionId() {
        return this.session.getId();
    }

    private Transaction startTransaction() {
        try {
            StartTransactionResult startTransaction = this.session.sendStartTransaction();
            return new Transaction(this.session, startTransaction.transactionId(), this.readAhead, this.ionSystem, this.executorService);
        }
        catch (BadRequestException e) {
            throw new TransactionAlreadyOpenException((QldbSessionException)((Object)e));
        }
    }

    private void noThrowAbort(Transaction transaction) {
        try {
            if (null == transaction) {
                this.session.sendAbort();
            } else {
                transaction.abort();
            }
        }
        catch (SdkException se) {
            logger.warn("Ignored error aborting transaction during execution.", (Throwable)se);
        }
    }

    private void retrySleep(ExecutionContext executionContext, Transaction transaction, RetryPolicy retryPolicy) {
        try {
            String transactionId = transaction != null ? transaction.getTransactionId() : null;
            RetryPolicyContext retryPolicyContext = new RetryPolicyContext(executionContext.lastException(), executionContext.retryAttempts(), transactionId);
            Duration backoffDelay = retryPolicy.backoffStrategy().calculateDelay(retryPolicyContext);
            if (backoffDelay == null || backoffDelay.isNegative()) {
                backoffDelay = Duration.ofMillis(0L);
            }
            TimeUnit.MILLISECONDS.sleep(backoffDelay.toMillis());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

