/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.qldb;

import com.amazon.ion.IonSystem;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.services.qldbsession.AmazonQLDBSession;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.qldb.BaseSyncQldbDriver;
import software.amazon.qldb.BaseSyncQldbDriverBuilder;
import software.amazon.qldb.QldbSession;
import software.amazon.qldb.QldbSessionImpl;
import software.amazon.qldb.Session;
import software.amazon.qldb.exceptions.Errors;

@ThreadSafe
public class QldbDriver
extends BaseSyncQldbDriver {
    private static final Logger logger = LoggerFactory.getLogger(QldbDriver.class);

    protected QldbDriver(String ledgerName, AmazonQLDBSession amazonQLDBSession, int occRetryLimit, int readAhead, IonSystem ionSystem, ExecutorService executorService) {
        super(ledgerName, amazonQLDBSession, occRetryLimit, readAhead, ionSystem, executorService);
    }

    public static QldbDriverBuilder builder() {
        return new QldbDriverBuilder();
    }

    @Override
    public QldbSession getSession() {
        if (this.isClosed.get()) {
            logger.error(Errors.DRIVER_CLOSED.get());
            throw new IllegalStateException(Errors.DRIVER_CLOSED.get());
        }
        logger.debug("Creating new session.");
        Session session = Session.startSession(this.ledgerName, this.amazonQldbSession);
        return new QldbSessionImpl(session, this.retryLimit, this.readAhead, this.ionSystem, this.executorService);
    }

    public static class QldbDriverBuilder
    extends BaseSyncQldbDriverBuilder<QldbDriverBuilder, QldbDriver> {
        protected QldbDriverBuilder() {
        }

        @Override
        protected QldbDriver createDriver() {
            return new QldbDriver(this.ledgerName, this.client, this.retryLimit, this.readAhead, this.ionSystem, this.executorService);
        }
    }
}

