/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.payloadoffloading;

import com.amazonaws.AmazonClientException;
import com.amazonaws.annotation.NotThreadSafe;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.SSEAwsKeyManagementParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@NotThreadSafe
public class PayloadStorageConfiguration {
    private static final Log LOG = LogFactory.getLog(PayloadStorageConfiguration.class);
    private AmazonS3 s3;
    private String s3BucketName;
    private int payloadSizeThreshold = 0;
    private boolean alwaysThroughS3 = false;
    private boolean payloadSupport = false;
    private SSEAwsKeyManagementParams sseAwsKeyManagementParams;

    public PayloadStorageConfiguration() {
        this.s3 = null;
        this.s3BucketName = null;
        this.sseAwsKeyManagementParams = null;
    }

    public PayloadStorageConfiguration(PayloadStorageConfiguration other) {
        this.s3 = other.getAmazonS3Client();
        this.s3BucketName = other.getS3BucketName();
        this.sseAwsKeyManagementParams = other.getSSEAwsKeyManagementParams();
        this.payloadSupport = other.isPayloadSupportEnabled();
        this.alwaysThroughS3 = other.isAlwaysThroughS3();
        this.payloadSizeThreshold = other.getPayloadSizeThreshold();
    }

    public void setPayloadSupportEnabled(AmazonS3 s3, String s3BucketName) {
        if (s3 == null || s3BucketName == null) {
            String errorMessage = "S3 client and/or S3 bucket name cannot be null.";
            LOG.error((Object)errorMessage);
            throw new AmazonClientException(errorMessage);
        }
        if (this.isPayloadSupportEnabled()) {
            LOG.warn((Object)"Payload support is already enabled. Overwriting AmazonS3Client and S3BucketName.");
        }
        this.s3 = s3;
        this.s3BucketName = s3BucketName;
        this.payloadSupport = true;
        LOG.info((Object)"Payload support enabled.");
    }

    public PayloadStorageConfiguration withPayloadSupportEnabled(AmazonS3 s3, String s3BucketName) {
        this.setPayloadSupportEnabled(s3, s3BucketName);
        return this;
    }

    public void setPayloadSupportDisabled() {
        this.s3 = null;
        this.s3BucketName = null;
        this.payloadSupport = false;
        LOG.info((Object)"Payload support disabled.");
    }

    public PayloadStorageConfiguration withPayloadSupportDisabled() {
        this.setPayloadSupportDisabled();
        return this;
    }

    public boolean isPayloadSupportEnabled() {
        return this.payloadSupport;
    }

    public AmazonS3 getAmazonS3Client() {
        return this.s3;
    }

    public String getS3BucketName() {
        return this.s3BucketName;
    }

    public SSEAwsKeyManagementParams getSSEAwsKeyManagementParams() {
        return this.sseAwsKeyManagementParams;
    }

    public void setSSEAwsKeyManagementParams(SSEAwsKeyManagementParams sseAwsKeyManagementParams) {
        this.sseAwsKeyManagementParams = sseAwsKeyManagementParams;
    }

    public PayloadStorageConfiguration withSSEAwsKeyManagementParams(SSEAwsKeyManagementParams sseAwsKeyManagementParams) {
        this.setSSEAwsKeyManagementParams(sseAwsKeyManagementParams);
        return this;
    }

    public PayloadStorageConfiguration withPayloadSizeThreshold(int payloadSizeThreshold) {
        this.setPayloadSizeThreshold(payloadSizeThreshold);
        return this;
    }

    public int getPayloadSizeThreshold() {
        return this.payloadSizeThreshold;
    }

    public void setPayloadSizeThreshold(int payloadSizeThreshold) {
        this.payloadSizeThreshold = payloadSizeThreshold;
    }

    public PayloadStorageConfiguration withAlwaysThroughS3(boolean alwaysThroughS3) {
        this.setAlwaysThroughS3(alwaysThroughS3);
        return this;
    }

    public boolean isAlwaysThroughS3() {
        return this.alwaysThroughS3;
    }

    public void setAlwaysThroughS3(boolean alwaysThroughS3) {
        this.alwaysThroughS3 = alwaysThroughS3;
    }
}

