/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.payloadoffloading;

import com.amazonaws.AmazonClientException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.payloadoffloading.JsonDataConverter;

public class PayloadS3Pointer {
    private static final Log LOG = LogFactory.getLog(PayloadS3Pointer.class);
    private String s3BucketName;
    private String s3Key;

    private PayloadS3Pointer() {
    }

    public PayloadS3Pointer(String s3BucketName, String s3Key) {
        this.s3BucketName = s3BucketName;
        this.s3Key = s3Key;
    }

    public String getS3BucketName() {
        return this.s3BucketName;
    }

    public String getS3Key() {
        return this.s3Key;
    }

    public String toJson() {
        String s3PointerStr = null;
        try {
            JsonDataConverter jsonDataConverter = new JsonDataConverter();
            s3PointerStr = jsonDataConverter.serializeToJson(this);
        }
        catch (Exception e) {
            String errorMessage = "Failed to convert S3 object pointer to text.";
            LOG.error((Object)errorMessage, (Throwable)e);
            throw new AmazonClientException(errorMessage, (Throwable)e);
        }
        return s3PointerStr;
    }

    public static PayloadS3Pointer fromJson(String s3PointerJson) {
        PayloadS3Pointer s3Pointer = null;
        try {
            JsonDataConverter jsonDataConverter = new JsonDataConverter();
            s3Pointer = jsonDataConverter.deserializeFromJson(s3PointerJson, PayloadS3Pointer.class);
        }
        catch (Exception e) {
            String errorMessage = "Failed to read the S3 object pointer from given string.";
            LOG.error((Object)errorMessage, (Throwable)e);
            throw new AmazonClientException(errorMessage, (Throwable)e);
        }
        return s3Pointer;
    }
}

