/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.pay.api;

import com.amazon.pay.api.RetryStrategy;

public class ExponentialRetryStrategy
implements RetryStrategy {
    protected final long initialDelayMillis;
    protected final long initialThrottlingDelayMillis;
    protected final long maxDelayMillis;
    protected final long maxThrottlingDelayMillis;
    protected int maxRetries;

    public ExponentialRetryStrategy(int maxRetries, long initialDelayMillis) {
        this(maxRetries, initialDelayMillis, initialDelayMillis);
    }

    public ExponentialRetryStrategy(int maxRetries, long initialDelayMillis, long initialThrottlingDelayMillis) {
        this(maxRetries, initialDelayMillis, initialThrottlingDelayMillis, Long.MAX_VALUE, Long.MAX_VALUE);
    }

    public ExponentialRetryStrategy(int maxRetries, long initialDelayMillis, long initialThrottlingDelayMillis, long maxDelayMillis, long maxThrottlingDelayMillis) {
        this.maxRetries = maxRetries;
        this.initialDelayMillis = initialDelayMillis;
        this.initialThrottlingDelayMillis = initialThrottlingDelayMillis;
        this.maxDelayMillis = maxDelayMillis;
        this.maxThrottlingDelayMillis = maxThrottlingDelayMillis;
    }

    @Override
    public long getWaitTime(int retryCount, int statusCode) {
        if (this.isThrottledResponse(statusCode)) {
            return Math.min(this.getExponentialWaitTime(retryCount, this.initialThrottlingDelayMillis), this.maxThrottlingDelayMillis);
        }
        return Math.min(this.getExponentialWaitTime(retryCount, this.initialDelayMillis), this.maxDelayMillis);
    }

    @Override
    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    @Override
    public int getMaxRetries() {
        return this.maxRetries;
    }

    public boolean isThrottledResponse(int statusCode) {
        return statusCode == 429;
    }

    long getExponentialWaitTime(int retryCount, long initialDelayMillis) {
        return (long)Math.pow(2.0, retryCount) * initialDelayMillis;
    }
}

