/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.pay.api;

import com.amazon.pay.api.types.Region;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ServiceConstants {
    public static final Map<Region, String> endpointMappings;
    public static final Map<String, Integer> serviceErrors;
    public static final String APPLICATION_LIBRARY_VERSION = "1.0.0";
    public static final String GITHUB_SDK_NAME = "amazon-pay-api-sdk-java";
    public static final String AMAZON_PAY_API_VERSION = "v1";
    public static final String AMAZON_SIGNATURE_ALGORITHM = "AMZN-PAY-RSASSA-PSS";
    public static final String HASH_ALGORITHM = "SHA-256";
    public static final String SIGNATURE_ALGORITHM = "SHA256WithRSA/PSS";
    public static final String MASK_GENERATION_FUNCTION = "MGF1";
    public static final String PRIVATE_KEY = "Private Key";
    public static final String REGION = "Region";
    public static final String PUBLIC_KEY_ID = "Public key id";
    public static final String REDACTED = "Redacted";
    public static final String DELIVERY_TRACKERS = "v1/deliveryTrackers";
    public static final String MERCHANT_SCAN = "in-store/v1/merchantScan";
    public static final String REFUND = "in-store/v1/refund";
    public static final String CHARGE = "in-store/v1/charge";
    public static final String CHECKOUT = "v1/checkoutSessions";
    public static final String CHARGE_PERMISSIONS = "v1/chargePermissions";
    public static final String CHARGES = "v1/charges";
    public static final String REFUNDS = "v1/refunds";
    public static final String AUTHORIZATION_TOKEN = "v1/authorizationTokens";
    public static final int RESPONSE_STATUS_CODE = 0;
    public static final int RESPONSE_STRING = 1;
    public static final int REQUEST_ID = 2;

    static {
        HashMap<Region, String> endpointMappingsMap = new HashMap<Region, String>();
        endpointMappingsMap.put(Region.EU, "https://pay-api.amazon.eu");
        endpointMappingsMap.put(Region.JP, "https://pay-api.amazon.jp");
        endpointMappingsMap.put(Region.NA, "https://pay-api.amazon.com");
        endpointMappings = Collections.unmodifiableMap(endpointMappingsMap);
        HashMap<String, Integer> serviceErrorsMap = new HashMap<String, Integer>();
        serviceErrorsMap.put("Internal Server Error", 500);
        serviceErrorsMap.put("Service Unavailable", 503);
        serviceErrorsMap.put("Too Many Requests", 429);
        serviceErrors = Collections.unmodifiableMap(serviceErrorsMap);
    }
}

