/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.tinkerpop.gremlin.driver.ConnectionMetrics;
import org.apache.tinkerpop.gremlin.driver.MetricsHandler;
import org.apache.tinkerpop.gremlin.driver.MetricsLogger;
import org.apache.tinkerpop.gremlin.driver.RequestMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MetricsHandlerCollection
implements MetricsHandler {
    private static final Logger logger = LoggerFactory.getLogger(MetricsLogger.class);
    private final Collection<MetricsHandler> handlers = new ArrayList<MetricsHandler>();

    MetricsHandlerCollection() {
        this.addHandler(new MetricsLogger());
    }

    void addHandler(MetricsHandler handler) {
        this.handlers.add(handler);
    }

    @Override
    public void onMetricsPublished(ConnectionMetrics connectionMetrics, RequestMetrics requestMetrics) {
        for (MetricsHandler handler : this.handlers) {
            try {
                handler.onMetricsPublished(connectionMetrics, requestMetrics);
            }
            catch (Exception e) {
                logger.error("Error while handling metrics", (Throwable)e);
            }
        }
    }
}

