/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.neptune.cluster;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.tinkerpop.gremlin.driver.EndpointCollection;
import org.apache.tinkerpop.gremlin.driver.GremlinClient;
import org.apache.tinkerpop.gremlin.driver.RefreshTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.neptune.cluster.ClusterEndpointsFetchStrategy;
import software.amazon.neptune.cluster.EndpointsSelector;
import software.amazon.neptune.cluster.GetEndpointsFromLambdaProxy;
import software.amazon.neptune.cluster.GetEndpointsFromNeptuneManagementApi;
import software.amazon.neptune.cluster.NeptuneClusterMetadata;
import software.amazon.neptune.cluster.OnNewClusterMetadata;
import software.amazon.utils.RegionUtils;

public class ClusterEndpointsRefreshAgent
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ClusterEndpointsRefreshAgent.class);
    private final ClusterEndpointsFetchStrategy endpointsFetchStrategy;
    private final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();

    public static ClusterEndpointsRefreshAgent lambdaProxy(String lambdaName) {
        return ClusterEndpointsRefreshAgent.lambdaProxy(lambdaName, RegionUtils.getCurrentRegionName());
    }

    public static ClusterEndpointsRefreshAgent lambdaProxy(String lambdaName, String region) {
        return ClusterEndpointsRefreshAgent.lambdaProxy(lambdaName, region, "default");
    }

    public static ClusterEndpointsRefreshAgent lambdaProxy(String lambdaName, String region, AWSCredentialsProvider credentialsProvider) {
        return new ClusterEndpointsRefreshAgent(new GetEndpointsFromLambdaProxy(lambdaName, region, credentialsProvider));
    }

    public static ClusterEndpointsRefreshAgent lambdaProxy(String lambdaName, String region, AWSCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration) {
        return new ClusterEndpointsRefreshAgent(new GetEndpointsFromLambdaProxy(lambdaName, region, credentialsProvider, clientConfiguration));
    }

    public static ClusterEndpointsRefreshAgent lambdaProxy(String lambdaName, String region, String iamProfile) {
        return new ClusterEndpointsRefreshAgent(new GetEndpointsFromLambdaProxy(lambdaName, region, iamProfile));
    }

    public static ClusterEndpointsRefreshAgent lambdaProxy(String lambdaName, String region, String iamProfile, ClientConfiguration clientConfiguration) {
        return new ClusterEndpointsRefreshAgent(new GetEndpointsFromLambdaProxy(lambdaName, region, iamProfile, clientConfiguration));
    }

    public static ClusterEndpointsRefreshAgent managementApi(String clusterId) {
        return ClusterEndpointsRefreshAgent.managementApi(clusterId, RegionUtils.getCurrentRegionName());
    }

    public static ClusterEndpointsRefreshAgent managementApi(String clusterId, String region) {
        return ClusterEndpointsRefreshAgent.managementApi(clusterId, region, "default");
    }

    public static ClusterEndpointsRefreshAgent managementApi(String clusterId, String region, AWSCredentialsProvider credentialsProvider) {
        return new ClusterEndpointsRefreshAgent(new GetEndpointsFromNeptuneManagementApi(clusterId, region, credentialsProvider));
    }

    public static ClusterEndpointsRefreshAgent managementApi(String clusterId, String region, AWSCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration) {
        return new ClusterEndpointsRefreshAgent(new GetEndpointsFromNeptuneManagementApi(clusterId, region, credentialsProvider, clientConfiguration));
    }

    public static ClusterEndpointsRefreshAgent managementApi(String clusterId, String region, String iamProfile) {
        return new ClusterEndpointsRefreshAgent(new GetEndpointsFromNeptuneManagementApi(clusterId, region, iamProfile));
    }

    public static ClusterEndpointsRefreshAgent managementApi(String clusterId, String region, String iamProfile, ClientConfiguration clientConfiguration) {
        return new ClusterEndpointsRefreshAgent(new GetEndpointsFromNeptuneManagementApi(clusterId, region, iamProfile, clientConfiguration));
    }

    public ClusterEndpointsRefreshAgent(ClusterEndpointsFetchStrategy endpointsFetchStrategy) {
        this.endpointsFetchStrategy = endpointsFetchStrategy;
    }

    public <T extends EndpointsSelector> void startPollingNeptuneAPI(GremlinClient client, T selector, long delay, TimeUnit timeUnit) {
        this.startPollingNeptuneAPI(RefreshTask.refresh(client, selector), delay, timeUnit);
    }

    public <T extends EndpointsSelector> void startPollingNeptuneAPI(RefreshTask refreshTask, long delay, TimeUnit timeUnit) {
        this.startPollingNeptuneAPI(Collections.singletonList(refreshTask), delay, timeUnit);
    }

    public <T extends EndpointsSelector> void startPollingNeptuneAPI(Collection<RefreshTask> tasks, long delay, TimeUnit timeUnit) {
        this.scheduledExecutorService.scheduleWithFixedDelay(() -> {
            try {
                HashMap<EndpointsSelector, GremlinClient> m = new HashMap<EndpointsSelector, GremlinClient>();
                for (RefreshTask task : tasks) {
                    m.put(task.selector(), task.client());
                }
                Map<? extends EndpointsSelector, EndpointCollection> refreshResults = this.refreshEndpoints(m.keySet());
                for (Map.Entry<? extends EndpointsSelector, EndpointCollection> entry : refreshResults.entrySet()) {
                    EndpointCollection endpoints = entry.getValue();
                    GremlinClient client = (GremlinClient)m.get(entry.getKey());
                    logger.info("Refresh: [client: {}, endpoints: {}]", (Object)client.hashCode(), (Object)endpoints);
                    client.refreshEndpoints(endpoints);
                }
            }
            catch (Exception e) {
                logger.error("Error while getting cluster metadata", (Throwable)e);
            }
        }, delay, delay, timeUnit);
    }

    public void startPollingNeptuneAPI(OnNewClusterMetadata onNewClusterMetadata, long delay, TimeUnit timeUnit) {
        this.scheduledExecutorService.scheduleWithFixedDelay(() -> {
            try {
                NeptuneClusterMetadata clusterMetadata = this.refreshClusterMetadata();
                logger.info("New cluster metadata: {}", (Object)clusterMetadata);
                onNewClusterMetadata.apply(clusterMetadata);
            }
            catch (Exception e) {
                logger.error("Error while refreshing cluster metadata", (Throwable)e);
            }
        }, delay, delay, timeUnit);
    }

    public void stop() {
        this.scheduledExecutorService.shutdownNow();
    }

    @Override
    public void close() throws Exception {
        this.stop();
    }

    public Map<? extends EndpointsSelector, EndpointCollection> refreshEndpoints(Collection<EndpointsSelector> selectors) {
        return this.endpointsFetchStrategy.getEndpoints(selectors, true);
    }

    public EndpointCollection refreshEndpoints(EndpointsSelector selector) {
        return this.endpointsFetchStrategy.getEndpoints(Arrays.asList(selector), true).get(selector);
    }

    public <T extends EndpointsSelector> EndpointCollection getEndpoints(T selector) {
        return this.endpointsFetchStrategy.getEndpoints(Arrays.asList(selector), false).get(selector);
    }

    public NeptuneClusterMetadata getClusterMetadata() {
        return this.endpointsFetchStrategy.clusterMetadataSupplier().getClusterMetadata();
    }

    public NeptuneClusterMetadata refreshClusterMetadata() {
        return this.endpointsFetchStrategy.clusterMetadataSupplier().refreshClusterMetadata();
    }
}

