/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.neptune.cluster;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.amazonaws.services.neptune.AmazonNeptune;
import com.amazonaws.services.neptune.AmazonNeptuneClientBuilder;
import com.amazonaws.services.neptune.model.AmazonNeptuneException;
import com.amazonaws.services.neptune.model.DBCluster;
import com.amazonaws.services.neptune.model.DBClusterMember;
import com.amazonaws.services.neptune.model.DescribeDBClustersRequest;
import com.amazonaws.services.neptune.model.DescribeDBClustersResult;
import com.amazonaws.services.neptune.model.DescribeDBInstancesRequest;
import com.amazonaws.services.neptune.model.DescribeDBInstancesResult;
import com.amazonaws.services.neptune.model.Filter;
import com.amazonaws.services.neptune.model.ListTagsForResourceRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.driver.EndpointCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.neptune.cluster.ClusterEndpointsFetchStrategy;
import software.amazon.neptune.cluster.ClusterMetadataSupplier;
import software.amazon.neptune.cluster.CommonClusterEndpointsFetchStrategy;
import software.amazon.neptune.cluster.EndpointsSelector;
import software.amazon.neptune.cluster.NeptuneClusterMetadata;
import software.amazon.neptune.cluster.NeptuneInstanceMetadata;
import software.amazon.utils.RegionUtils;

class GetEndpointsFromNeptuneManagementApi
implements ClusterEndpointsFetchStrategy,
ClusterMetadataSupplier {
    private static final Logger logger = LoggerFactory.getLogger(GetEndpointsFromNeptuneManagementApi.class);
    private final ClusterEndpointsFetchStrategy innerStrategy;
    private static final Map<String, Map<String, String>> instanceTags = new HashMap<String, Map<String, String>>();
    private final String clusterId;
    private final String region;
    private final String iamProfile;
    private final AWSCredentialsProvider credentials;
    private final AtomicReference<NeptuneClusterMetadata> cachedClusterMetadata = new AtomicReference();
    private final ClientConfiguration clientConfiguration;

    GetEndpointsFromNeptuneManagementApi(String clusterId) {
        this(clusterId, RegionUtils.getCurrentRegionName());
    }

    GetEndpointsFromNeptuneManagementApi(String clusterId, String region) {
        this(clusterId, region, "default");
    }

    GetEndpointsFromNeptuneManagementApi(String clusterId, String region, String iamProfile) {
        this(clusterId, region, iamProfile, null, null);
    }

    GetEndpointsFromNeptuneManagementApi(String clusterId, String region, String iamProfile, ClientConfiguration clientConfiguration) {
        this(clusterId, region, iamProfile, null, clientConfiguration);
    }

    GetEndpointsFromNeptuneManagementApi(String clusterId, String region, AWSCredentialsProvider credentials) {
        this(clusterId, region, "default", credentials, null);
    }

    GetEndpointsFromNeptuneManagementApi(String clusterId, String region, AWSCredentialsProvider credentials, ClientConfiguration clientConfiguration) {
        this(clusterId, region, "default", credentials, clientConfiguration);
    }

    private GetEndpointsFromNeptuneManagementApi(String clusterId, String region, String iamProfile, AWSCredentialsProvider credentials, ClientConfiguration clientConfiguration) {
        this.innerStrategy = new CommonClusterEndpointsFetchStrategy(this);
        this.clusterId = clusterId;
        this.region = region;
        this.iamProfile = iamProfile;
        this.credentials = credentials;
        this.clientConfiguration = clientConfiguration;
    }

    @Override
    public NeptuneClusterMetadata refreshClusterMetadata() {
        try {
            AmazonNeptuneClientBuilder builder = AmazonNeptuneClientBuilder.standard();
            if (this.clientConfiguration != null) {
                builder = (AmazonNeptuneClientBuilder)builder.withClientConfiguration(this.clientConfiguration);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.region)) {
                builder = (AmazonNeptuneClientBuilder)builder.withRegion(this.region);
            }
            if (this.credentials != null) {
                builder = (AmazonNeptuneClientBuilder)builder.withCredentials(this.credentials);
            } else if (!this.iamProfile.equals("default")) {
                builder = (AmazonNeptuneClientBuilder)builder.withCredentials((AWSCredentialsProvider)new ProfileCredentialsProvider(this.iamProfile));
            }
            AmazonNeptune neptune = (AmazonNeptune)builder.build();
            DescribeDBClustersResult describeDBClustersResult = neptune.describeDBClusters(new DescribeDBClustersRequest().withDBClusterIdentifier(this.clusterId));
            if (describeDBClustersResult.getDBClusters().isEmpty()) {
                throw new IllegalStateException(String.format("Unable to find cluster %s", this.clusterId));
            }
            DBCluster dbCluster = (DBCluster)describeDBClustersResult.getDBClusters().get(0);
            String clusterEndpoint = dbCluster.getEndpoint();
            String readerEndpoint = dbCluster.getReaderEndpoint();
            List dbClusterMembers = dbCluster.getDBClusterMembers();
            Optional<DBClusterMember> clusterWriter = dbClusterMembers.stream().filter(DBClusterMember::isClusterWriter).findFirst();
            String primary = clusterWriter.map(DBClusterMember::getDBInstanceIdentifier).orElse("");
            List replicas = dbClusterMembers.stream().filter(dbClusterMember -> dbClusterMember.isClusterWriter() == false).map(DBClusterMember::getDBInstanceIdentifier).collect(Collectors.toList());
            DescribeDBInstancesRequest describeDBInstancesRequest = new DescribeDBInstancesRequest().withFilters(Collections.singletonList(new Filter().withName("db-cluster-id").withValues(new String[]{dbCluster.getDBClusterIdentifier()})));
            DescribeDBInstancesResult describeDBInstancesResult = neptune.describeDBInstances(describeDBInstancesRequest);
            ArrayList<NeptuneInstanceMetadata> instances = new ArrayList<NeptuneInstanceMetadata>();
            describeDBInstancesResult.getDBInstances().forEach(c -> {
                String role = "unknown";
                if (primary.equals(c.getDBInstanceIdentifier())) {
                    role = "writer";
                }
                if (replicas.contains(c.getDBInstanceIdentifier())) {
                    role = "reader";
                }
                String address = c.getEndpoint() == null ? null : c.getEndpoint().getAddress();
                instances.add(new NeptuneInstanceMetadata().withInstanceId(c.getDBInstanceIdentifier()).withRole(role).withAddress(address).withStatus(c.getDBInstanceStatus()).withAvailabilityZone(c.getAvailabilityZone()).withInstanceType(c.getDBInstanceClass()).withTags(this.getTags(c.getDBInstanceArn(), neptune)));
            });
            neptune.shutdown();
            NeptuneClusterMetadata clusterMetadata = new NeptuneClusterMetadata().withInstances(instances).withClusterEndpoint(clusterEndpoint).withReaderEndpoint(readerEndpoint);
            this.cachedClusterMetadata.set(clusterMetadata);
            return clusterMetadata;
        }
        catch (AmazonNeptuneException e) {
            if (e.getErrorCode().equals("Throttling")) {
                logger.warn("Calls to the Neptune Management API are being throttled. Reduce the refresh rate and stagger refresh agent requests, or use a NeptuneEndpointsInfoLambda proxy.");
                NeptuneClusterMetadata clusterMetadata = this.cachedClusterMetadata.get();
                if (clusterMetadata != null) {
                    return clusterMetadata;
                }
                throw e;
            }
            throw e;
        }
    }

    @Override
    public NeptuneClusterMetadata getClusterMetadata() {
        NeptuneClusterMetadata clusterMetadata = this.cachedClusterMetadata.get();
        if (clusterMetadata == null) {
            return this.refreshClusterMetadata();
        }
        return clusterMetadata;
    }

    @Override
    public ClusterMetadataSupplier clusterMetadataSupplier() {
        return this;
    }

    @Override
    public Map<? extends EndpointsSelector, EndpointCollection> getEndpoints(Collection<? extends EndpointsSelector> selectors, boolean refresh) {
        return this.innerStrategy.getEndpoints(selectors, refresh);
    }

    private Map<String, String> getTags(String dbInstanceArn, AmazonNeptune neptune) {
        if (instanceTags.containsKey(dbInstanceArn)) {
            return instanceTags.get(dbInstanceArn);
        }
        List tagList = neptune.listTagsForResource(new ListTagsForResourceRequest().withResourceName(dbInstanceArn)).getTagList();
        HashMap<String, String> tags = new HashMap<String, String>();
        tagList.forEach(t -> tags.put(t.getKey(), t.getValue()));
        instanceTags.put(dbInstanceArn, tags);
        return tags;
    }
}

