/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.neptune.cluster;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.neptune.cluster.ClusterEndpointsFetchStrategy;
import software.amazon.neptune.cluster.ClusterMetadataFetchStrategy;
import software.amazon.neptune.cluster.EndpointsSelector;
import software.amazon.neptune.cluster.EndpointsType;
import software.amazon.neptune.cluster.GetEndpointsFromLambdaProxy;
import software.amazon.neptune.cluster.GetEndpointsFromNeptuneManagementApi;
import software.amazon.neptune.cluster.NeptuneClusterMetadata;
import software.amazon.neptune.cluster.OnNewAddresses;
import software.amazon.neptune.cluster.OnNewClusterMetadata;
import software.amazon.utils.RegionUtils;

public class ClusterEndpointsRefreshAgent
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ClusterEndpointsRefreshAgent.class);
    private final ClusterEndpointsFetchStrategy clusterEndpointsFetchStrategy;
    private final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();

    public static ClusterEndpointsRefreshAgent lambdaProxy(EndpointsType endpointsType, String lambdaName) {
        return ClusterEndpointsRefreshAgent.lambdaProxy(endpointsType, lambdaName, RegionUtils.getCurrentRegionName());
    }

    public static ClusterEndpointsRefreshAgent lambdaProxy(EndpointsType endpointsType, String lambdaName, String region) {
        return ClusterEndpointsRefreshAgent.lambdaProxy(endpointsType, lambdaName, region, "default");
    }

    public static ClusterEndpointsRefreshAgent lambdaProxy(EndpointsType endpointsType, String lambdaName, String region, String iamProfile) {
        return new ClusterEndpointsRefreshAgent(new GetEndpointsFromLambdaProxy(endpointsType, lambdaName, region, iamProfile));
    }

    public static ClusterEndpointsRefreshAgent lambdaProxy(EndpointsSelector endpointsSelector, String lambdaName) {
        return ClusterEndpointsRefreshAgent.lambdaProxy(endpointsSelector, lambdaName, RegionUtils.getCurrentRegionName());
    }

    public static ClusterEndpointsRefreshAgent lambdaProxy(EndpointsSelector endpointsSelector, String lambdaName, String region) {
        return ClusterEndpointsRefreshAgent.lambdaProxy(endpointsSelector, lambdaName, region, "default");
    }

    public static ClusterEndpointsRefreshAgent lambdaProxy(EndpointsSelector endpointsSelector, String lambdaName, String region, String iamProfile) {
        return new ClusterEndpointsRefreshAgent(new GetEndpointsFromLambdaProxy(endpointsSelector, lambdaName, region, iamProfile));
    }

    public ClusterEndpointsRefreshAgent(ClusterEndpointsFetchStrategy clusterEndpointsFetchStrategy) {
        this.clusterEndpointsFetchStrategy = clusterEndpointsFetchStrategy;
    }

    public ClusterEndpointsRefreshAgent(String clusterId, EndpointsSelector ... selectors) {
        this(new GetEndpointsFromNeptuneManagementApi(clusterId, Arrays.asList(selectors)));
    }

    public void startPollingNeptuneAPI(OnNewAddresses onNewAddresses, long delay, TimeUnit timeUnit) {
        this.scheduledExecutorService.scheduleWithFixedDelay(() -> {
            try {
                Map<EndpointsSelector, Collection<String>> addresses = this.getAddresses();
                logger.info("New addresses: {}", addresses);
                onNewAddresses.apply(addresses);
            }
            catch (Exception e) {
                logger.error("Error while getting addresses", (Throwable)e);
            }
        }, delay, delay, timeUnit);
    }

    public void startPollingNeptuneAPI(OnNewClusterMetadata onNewClusterMetadata, long delay, TimeUnit timeUnit) {
        if (!ClusterMetadataFetchStrategy.class.isAssignableFrom(this.clusterEndpointsFetchStrategy.getClass())) {
            throw new IllegalStateException("Fetch strategy does not implement ClusterMetadataFetchStrategy: " + this.clusterEndpointsFetchStrategy.getClass().getSimpleName());
        }
        this.scheduledExecutorService.scheduleWithFixedDelay(() -> {
            try {
                NeptuneClusterMetadata clusterMetadata = this.getClusterMetadata();
                logger.info("New cluster metadata: {}", (Object)clusterMetadata);
                onNewClusterMetadata.apply(clusterMetadata);
            }
            catch (Exception e) {
                logger.error("Error while getting cluster metadata", (Throwable)e);
            }
        }, delay, delay, timeUnit);
    }

    public void stop() {
        this.scheduledExecutorService.shutdownNow();
    }

    @Override
    public void close() throws Exception {
        this.stop();
    }

    public Map<EndpointsSelector, Collection<String>> getAddresses() {
        return this.clusterEndpointsFetchStrategy.getAddresses();
    }

    public NeptuneClusterMetadata getClusterMetadata() {
        return ((ClusterMetadataFetchStrategy)((Object)this.clusterEndpointsFetchStrategy)).getClusterMetadata();
    }
}

