/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.driver.Client;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.apache.tinkerpop.gremlin.driver.Connection;
import org.apache.tinkerpop.gremlin.driver.GremlinClusterCollection;
import org.apache.tinkerpop.gremlin.driver.exception.ConnectionException;
import org.apache.tinkerpop.gremlin.driver.exception.NoHostAvailableException;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GremlinClient
extends Client
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(GremlinClient.class);
    private final AtomicReference<List<ClientHolder>> clientHolders = new AtomicReference(new ArrayList());
    private final AtomicLong index = new AtomicLong(0L);
    private final AtomicReference<CompletableFuture<Void>> closing = new AtomicReference<Object>(null);
    private final AtomicBoolean refreshing = new AtomicBoolean(false);
    private final AtomicInteger consecutiveErrorCount = new AtomicInteger(0);
    private final GremlinClusterCollection clusterCollection;
    private final Function<String, Cluster> clusterBuilder;
    private final int refreshOnErrorThreshold;
    private final Supplier<Collection<String>> refreshOnErrorEventHandler;
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();

    GremlinClient(Cluster cluster, Client.Settings settings, List<ClientHolder> clientHolders, GremlinClusterCollection clusterCollection, Function<String, Cluster> clusterBuilder, int refreshOnErrorThreshold, Supplier<Collection<String>> refreshOnErrorEventHandler) {
        super(cluster, settings);
        this.refreshOnErrorThreshold = refreshOnErrorThreshold;
        this.refreshOnErrorEventHandler = refreshOnErrorEventHandler;
        this.clientHolders.set(clientHolders);
        this.clusterCollection = clusterCollection;
        this.clusterBuilder = clusterBuilder;
    }

    public void refreshEndpoints(String ... addresses) {
        this.refreshEndpoints(Arrays.asList(addresses));
    }

    public synchronized void refreshEndpoints(Collection<String> addresses) {
        Cluster cluster;
        if (this.closing.get() != null) {
            return;
        }
        List<ClientHolder> oldClientHolders = this.clientHolders.get();
        ArrayList<ClientHolder> newClientHolders = new ArrayList<ClientHolder>();
        ArrayList<String> addressesToRemove = new ArrayList<String>();
        for (ClientHolder clientHolder : oldClientHolders) {
            String address = clientHolder.getAddress();
            if (addresses.contains(address)) {
                logger.info("Retaining client for {}", (Object)address);
                newClientHolders.add(clientHolder);
                continue;
            }
            addressesToRemove.add(address);
        }
        for (String address : addresses) {
            if (this.clusterCollection.containsAddress(address)) continue;
            logger.info("Adding client for {}", (Object)address);
            cluster = this.clusterBuilder.apply(address);
            ClientHolder clientHolder = new ClientHolder(address, cluster.connect());
            clientHolder.init();
            newClientHolders.add(clientHolder);
            this.clusterCollection.add(address, cluster);
        }
        this.clientHolders.set(newClientHolders);
        for (String address : addressesToRemove) {
            logger.info("Removing client for {}", (Object)address);
            cluster = this.clusterCollection.remove(address);
            if (cluster == null) continue;
            cluster.close();
        }
    }

    protected void initializeImplementation() {
    }

    protected Connection chooseConnection(RequestMessage msg) throws TimeoutException, ConnectionException {
        long start = System.currentTimeMillis();
        logger.debug("Choosing connection");
        Connection connection = null;
        while (connection == null) {
            List<ClientHolder> currentClientHolders = this.clientHolders.get();
            while (currentClientHolders.isEmpty()) {
                try {
                    Thread.sleep(500L);
                    currentClientHolders = this.clientHolders.get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            ClientHolder clientHolder = currentClientHolders.get((int)(this.index.getAndIncrement() % (long)currentClientHolders.size()));
            if (clientHolder.isAvailable()) {
                connection = clientHolder.chooseConnection(msg);
                this.resetErrorCount();
                continue;
            }
            logger.warn("Client for {} not available", (Object)clientHolder.getAddress());
            this.handleError();
        }
        logger.debug("Connection: {} [{} ms]", (Object)connection.getConnectionInfo(), (Object)(System.currentTimeMillis() - start));
        return connection;
    }

    private void handleError() {
        if (this.refreshOnErrorThreshold > 0 && this.consecutiveErrorCount.incrementAndGet() > this.refreshOnErrorThreshold && !this.refreshing.get()) {
            this.consecutiveErrorCount.set(0);
            if (this.refreshOnErrorEventHandler != null) {
                this.executorService.submit(new RefreshOnErrorEventHandler(this, this.refreshing, this.refreshOnErrorEventHandler));
            }
        }
    }

    private void resetErrorCount() {
        if (this.refreshOnErrorThreshold > 0) {
            this.consecutiveErrorCount.set(0);
        }
    }

    public boolean isClosing() {
        return this.closing.get() != null;
    }

    public CompletableFuture<Void> closeAsync() {
        if (this.closing.get() != null) {
            return this.closing.get();
        }
        this.executorService.shutdownNow();
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (ClientHolder clientHolder : this.clientHolders.get()) {
            futures.add(clientHolder.closeAsync());
        }
        this.closing.set(CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])));
        return this.closing.get();
    }

    public synchronized Client init() {
        if (this.initialized) {
            return this;
        }
        logger.debug("Initializing internal clients");
        for (ClientHolder clientHolder : this.clientHolders.get()) {
            clientHolder.init();
        }
        this.initializeImplementation();
        this.initialized = true;
        return this;
    }

    public String toString() {
        return "Client holder queue: " + System.lineSeparator() + this.clientHolders.get().stream().map(c -> String.format("  {address: %s, isAvailable: %s}", c.getAddress(), c.isAvailable())).collect(Collectors.joining(System.lineSeparator())) + System.lineSeparator() + "Cluster collection: " + System.lineSeparator() + this.clusterCollection.toString();
    }

    private static class RefreshOnErrorEventHandler
    implements Runnable {
        private final GremlinClient client;
        private final AtomicBoolean refreshing;
        private final Supplier<Collection<String>> refreshOnErrorEventHandler;

        private RefreshOnErrorEventHandler(GremlinClient client, AtomicBoolean refreshing, Supplier<Collection<String>> refreshOnErrorEventHandler) {
            this.client = client;
            this.refreshing = refreshing;
            this.refreshOnErrorEventHandler = refreshOnErrorEventHandler;
        }

        @Override
        public void run() {
            boolean isAlreadyRefreshing = this.refreshing.getAndSet(true);
            if (isAlreadyRefreshing) {
                return;
            }
            Collection<String> endpoints = this.refreshOnErrorEventHandler.get();
            this.client.refreshEndpoints(endpoints);
            this.refreshing.set(false);
        }
    }

    static class ClientHolder {
        private final String host;
        private final Client client;

        public ClientHolder(String host, Client client) {
            this.host = host;
            this.client = client;
        }

        public String getAddress() {
            return this.host;
        }

        public boolean isAvailable() {
            return !this.client.getCluster().availableHosts().isEmpty();
        }

        public Connection chooseConnection(RequestMessage msg) throws TimeoutException, ConnectionException {
            try {
                Connection connection = this.client.chooseConnection(msg);
                if (connection.isClosing()) {
                    logger.warn("Connection is closing: {}", (Object)this.host);
                    return null;
                }
                if (connection.isDead()) {
                    logger.warn("Connection is dead: {}", (Object)this.host);
                    return null;
                }
                return connection;
            }
            catch (NullPointerException e) {
                logger.warn("NullPointerException: {}", (Object)this.host, (Object)e);
                return null;
            }
            catch (NoHostAvailableException e) {
                logger.warn("No connection available: {}", (Object)this.host, (Object)e);
                return null;
            }
        }

        public CompletableFuture<Void> closeAsync() {
            return this.client.closeAsync();
        }

        public void init() {
            this.client.init();
        }
    }
}

