/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.driver.Cluster;

public class GremlinClusterCollection {
    private final Cluster parentCluster;
    private final Map<String, Cluster> clusters = new ConcurrentHashMap<String, Cluster>();
    private final AtomicReference<CompletableFuture<Void>> closing = new AtomicReference<Object>(null);

    public GremlinClusterCollection(Cluster parentCluster) {
        this.parentCluster = parentCluster;
    }

    public boolean containsAddress(String address) {
        return this.clusters.containsKey(address);
    }

    public void add(String address, Cluster cluster) {
        this.clusters.put(address, cluster);
    }

    public Cluster remove(String address) {
        return this.clusters.remove(address);
    }

    public Cluster getParentCluster() {
        return this.parentCluster;
    }

    public CompletableFuture<Void> closeAsync() {
        if (this.closing.get() != null) {
            return this.closing.get();
        }
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        for (Cluster cluster : this.clusters.values()) {
            futures.add(cluster.closeAsync());
        }
        futures.add(this.parentCluster.closeAsync());
        this.closing.set(CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])));
        return this.closing.get();
    }

    public String toString() {
        return this.clusters.entrySet().stream().map(e -> String.format("  {%s, %s, isClosed: %s}", e.getKey(), ((Cluster)e.getValue()).allHosts().stream().map(h -> h.getHostUri().toString()).collect(Collectors.joining(",")), ((Cluster)e.getValue()).isClosed())).collect(Collectors.joining(System.lineSeparator()));
    }
}

