/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.utilities.jmespath;

import io.burt.jmespath.Adapter;
import io.burt.jmespath.JmesPathType;
import io.burt.jmespath.function.ArgumentConstraints;
import io.burt.jmespath.function.BaseFunction;
import io.burt.jmespath.function.FunctionArgument;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;

public class Base64Function
extends BaseFunction {
    public Base64Function() {
        super("powertools_base64", ArgumentConstraints.typeOf((JmesPathType)JmesPathType.STRING));
    }

    public static String decode(String encodedString) {
        return new String(Base64Function.decode(encodedString.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
    }

    public static String decode(ByteBuffer byteBuffer) {
        return StandardCharsets.UTF_8.decode(byteBuffer).toString();
    }

    public static byte[] decode(byte[] encoded) {
        return Base64.getDecoder().decode(encoded);
    }

    protected <T> T callFunction(Adapter<T> runtime, List<FunctionArgument<T>> arguments) {
        Object value = arguments.get(0).value();
        String encodedString = runtime.toString(value);
        String decodedString = Base64Function.decode(encodedString);
        return (T)runtime.createString(decodedString);
    }
}

