/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.parameters.cache;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import software.amazon.lambda.powertools.parameters.cache.DataStore;

public class CacheManager {
    static final Duration DEFAULT_MAX_AGE_SECS = Duration.of(5L, ChronoUnit.SECONDS);
    private final DataStore store;
    private Duration defaultMaxAge;
    private Duration maxAge;

    public CacheManager() {
        this.maxAge = this.defaultMaxAge = DEFAULT_MAX_AGE_SECS;
        this.store = new DataStore();
    }

    public <T> Optional<T> getIfNotExpired(String key, Instant now) {
        if (this.store.hasExpired(key, now)) {
            return Optional.empty();
        }
        return Optional.of(this.store.get(key));
    }

    public void setExpirationTime(Duration duration) {
        this.maxAge = duration;
    }

    public void setDefaultExpirationTime(Duration duration) {
        this.defaultMaxAge = duration;
        this.maxAge = duration;
    }

    public <T> void putInCache(String key, T value) {
        this.store.put(key, value, Clock.systemDefaultZone().instant().plus(this.maxAge));
    }

    public void resetExpirationTime() {
        this.maxAge = this.defaultMaxAge;
    }
}

