/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.parameters;

import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.lambda.powertools.parameters.SSMProvider;
import software.amazon.lambda.powertools.parameters.SecretsProvider;
import software.amazon.lambda.powertools.parameters.cache.CacheManager;
import software.amazon.lambda.powertools.parameters.transform.TransformationManager;

public final class ParamManager {
    private static final CacheManager cacheManager = new CacheManager();
    private static final TransformationManager transformationManager = new TransformationManager();
    private static SecretsProvider secretsProvider;
    private static SSMProvider ssmProvider;

    public static SecretsProvider getSecretsProvider() {
        if (secretsProvider == null) {
            secretsProvider = SecretsProvider.builder().withCacheManager(cacheManager).withTransformationManager(transformationManager).build();
        }
        return secretsProvider;
    }

    public static SSMProvider getSsmProvider() {
        if (ssmProvider == null) {
            ssmProvider = SSMProvider.builder().withCacheManager(cacheManager).withTransformationManager(transformationManager).build();
        }
        return ssmProvider;
    }

    public static SecretsProvider getSecretsProvider(SecretsManagerClient client) {
        if (secretsProvider == null) {
            secretsProvider = SecretsProvider.builder().withClient(client).withCacheManager(cacheManager).withTransformationManager(transformationManager).build();
        }
        return secretsProvider;
    }

    public static SSMProvider getSsmProvider(SsmClient client) {
        if (ssmProvider == null) {
            ssmProvider = SSMProvider.builder().withClient(client).withCacheManager(cacheManager).withTransformationManager(transformationManager).build();
        }
        return ssmProvider;
    }

    public static CacheManager getCacheManager() {
        return cacheManager;
    }

    public static TransformationManager getTransformationManager() {
        return transformationManager;
    }
}

