/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.logging.internal;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class KeyBuffer<K, T> {
    private final Map<K, Deque<T>> keyBufferCache = new ConcurrentHashMap<K, Deque<T>>();
    private final Map<K, Boolean> overflowTriggered = new ConcurrentHashMap<K, Boolean>();
    private final int maxBytes;
    private final Function<T, Integer> sizeCalculator;
    private final Runnable overflowWarningLogger;

    public KeyBuffer(int maxBytes, Function<T, Integer> sizeCalculator) {
        this(maxBytes, sizeCalculator, () -> System.err.println("WARN [" + KeyBuffer.class.getSimpleName() + "] - Some logs are not displayed because they were evicted from the buffer. Increase buffer size to store more logs in the buffer."));
    }

    public KeyBuffer(int maxBytes, Function<T, Integer> sizeCalculator, Runnable overflowWarningLogger) {
        this.maxBytes = maxBytes;
        this.sizeCalculator = sizeCalculator;
        this.overflowWarningLogger = overflowWarningLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(K key, T event) {
        Deque buffer;
        int eventSize = this.sizeCalculator.apply(event);
        if (eventSize > this.maxBytes) {
            this.overflowTriggered.put(key, true);
            return;
        }
        Deque deque = buffer = this.keyBufferCache.computeIfAbsent(key, k -> new ArrayDeque());
        synchronized (deque) {
            buffer.add(event);
            while (this.getBufferSize(buffer) > this.maxBytes && !buffer.isEmpty()) {
                this.overflowTriggered.put(key, true);
                buffer.removeFirst();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Deque<T> removeAll(K key) {
        this.logOverflowWarningIfNeeded(key);
        Deque<T> buffer = this.keyBufferCache.remove(key);
        if (buffer != null) {
            Deque<T> deque = buffer;
            synchronized (deque) {
                return new ArrayDeque<T>(buffer);
            }
        }
        return buffer;
    }

    public void clear(K key) {
        this.keyBufferCache.remove(key);
        this.overflowTriggered.remove(key);
    }

    private void logOverflowWarningIfNeeded(K key) {
        if (Boolean.TRUE.equals(this.overflowTriggered.remove(key))) {
            this.overflowWarningLogger.run();
        }
    }

    private int getBufferSize(Deque<T> buffer) {
        return buffer.stream().mapToInt(this.sizeCalculator::apply).sum();
    }
}

