/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.logging.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import java.util.Random;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.util.IOUtils;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import software.amazon.lambda.powertools.core.internal.LambdaHandlerProcessor;
import software.amazon.lambda.powertools.logging.PowertoolsLogger;
import software.amazon.lambda.powertools.logging.PowertoolsLogging;
import software.amazon.lambda.powertools.logging.internal.DefaultLambdaFields;

@Aspect
public final class LambdaLoggingAspect {
    private static final Logger LOG = LogManager.getLogger(LambdaLoggingAspect.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final Random SAMPLER = new Random();
    private static final String LOG_LEVEL = System.getenv("LOG_LEVEL");
    private static final String SAMPLING_RATE = System.getenv("POWERTOOLS_LOGGER_SAMPLE_RATE");
    private static Level LEVEL_AT_INITIALISATION;
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ LambdaLoggingAspect ajc$perSingletonInstance;

    static {
        if (LOG_LEVEL != null) {
            LambdaLoggingAspect.resetLogLevels(Level.getLevel((String)LOG_LEVEL));
        }
        LEVEL_AT_INITIALISATION = LOG.getLevel();
        try {
            LambdaLoggingAspect.ajc$perSingletonInstance = new LambdaLoggingAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    @Pointcut(value="@annotation(powertoolsLogging)")
    public /* synthetic */ void callAt(PowertoolsLogging powertoolsLogging) {
    }

    @Around(value="callAt(powertoolsLogging) && execution(@PowertoolsLogging * *.*(..))", argNames="pjp,powertoolsLogging")
    public Object around(ProceedingJoinPoint pjp, PowertoolsLogging powertoolsLogging) throws Throwable {
        Object[] proceedArgs = pjp.getArgs();
        this.setLogLevelBasedOnSamplingRate(pjp, powertoolsLogging);
        LambdaHandlerProcessor.extractContext((ProceedingJoinPoint)pjp).ifPresent(context -> {
            PowertoolsLogger.appendKeys(DefaultLambdaFields.values(context));
            PowertoolsLogger.appendKey("coldStart", LambdaHandlerProcessor.isColdStart() ? "true" : "false");
            PowertoolsLogger.appendKey("service", LambdaHandlerProcessor.serviceName());
        });
        if (powertoolsLogging.logEvent()) {
            proceedArgs = this.logEvent(pjp);
        }
        Object proceed = pjp.proceed(proceedArgs);
        LambdaHandlerProcessor.coldStartDone();
        return proceed;
    }

    private static void resetLogLevels(Level logLevel) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configurator.setAllLevels((String)LogManager.getRootLogger().getName(), (Level)logLevel);
        ctx.updateLoggers();
    }

    private void setLogLevelBasedOnSamplingRate(ProceedingJoinPoint pjp, PowertoolsLogging powertoolsLogging) {
        if (LambdaHandlerProcessor.isHandlerMethod((ProceedingJoinPoint)pjp)) {
            float sample = SAMPLER.nextFloat();
            double samplingRate = this.samplingRate(powertoolsLogging);
            if (samplingRate < 0.0 || samplingRate > 1.0) {
                LOG.debug("Skipping sampling rate configuration because of invalid value. Sampling rate: {}", (Object)samplingRate);
                return;
            }
            PowertoolsLogger.appendKey("samplingRate", String.valueOf(samplingRate));
            if (samplingRate > (double)sample) {
                LambdaLoggingAspect.resetLogLevels(Level.DEBUG);
                LOG.debug("Changed log level to DEBUG based on Sampling configuration. Sampling Rate: {}, Sampler Value: {}.", (Object)samplingRate, (Object)Float.valueOf(sample));
            } else if (LEVEL_AT_INITIALISATION != LOG.getLevel()) {
                LambdaLoggingAspect.resetLogLevels(LEVEL_AT_INITIALISATION);
            }
        }
    }

    private double samplingRate(PowertoolsLogging powertoolsLogging) {
        if (SAMPLING_RATE != null) {
            try {
                return Double.parseDouble(SAMPLING_RATE);
            }
            catch (NumberFormatException numberFormatException) {
                LOG.debug("Skipping sampling rate on environment variable configuration because of invalid value. Sampling rate: {}", (Object)SAMPLING_RATE);
            }
        }
        return powertoolsLogging.samplingRate();
    }

    private Object[] logEvent(ProceedingJoinPoint pjp) {
        Object[] args = pjp.getArgs();
        if (LambdaHandlerProcessor.isHandlerMethod((ProceedingJoinPoint)pjp)) {
            if (LambdaHandlerProcessor.placedOnRequestHandler((ProceedingJoinPoint)pjp)) {
                Logger log = this.logger(pjp);
                log.info(pjp.getArgs()[0]);
            }
            if (LambdaHandlerProcessor.placedOnStreamHandler((ProceedingJoinPoint)pjp)) {
                args = this.logFromInputStream(pjp);
            }
        }
        return args;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object[] logFromInputStream(ProceedingJoinPoint pjp) {
        Object[] args = pjp.getArgs();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try {
                    block20: {
                        OutputStreamWriter writer = new OutputStreamWriter(out);
                        try {
                            try (InputStreamReader reader = new InputStreamReader((InputStream)pjp.getArgs()[0]);){
                                IOUtils.copy((Reader)reader, (Writer)writer);
                                writer.flush();
                                byte[] bytes = out.toByteArray();
                                args[0] = new ByteArrayInputStream(bytes);
                                Logger log = this.logger(pjp);
                                log.info(MAPPER.readValue(bytes, Map.class));
                            }
                            if (writer == null) break block20;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (writer == null) throw throwable;
                            writer.close();
                            throw throwable;
                        }
                        writer.close();
                    }
                    if (out == null) return args;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (out == null) throw throwable;
                    out.close();
                    throw throwable;
                }
                out.close();
                return args;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (IOException e) {
            Logger log = this.logger(pjp);
            log.debug("Failed to log event from supplied input stream.", (Throwable)e);
        }
        return args;
    }

    private Logger logger(ProceedingJoinPoint pjp) {
        return LogManager.getLogger((Class)pjp.getSignature().getDeclaringType());
    }

    public static LambdaLoggingAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("software.amazon.lambda.powertools.logging.internal.LambdaLoggingAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

