/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jsii;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.jsii.JsiiClient;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiException;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiPromise;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.NativeType;

public class JsiiObject
implements JsiiSerializable {
    private final JsiiEngine engine;
    private final Map<Class<? extends JsiiObject>, JsiiObject> proxies = new HashMap<Class<? extends JsiiObject>, JsiiObject>();
    private JsiiObjectRef objRef;

    protected JsiiObject(InitializationMode initializationMode) {
        this(JsiiEngine.getInstance(), initializationMode);
    }

    JsiiObject(JsiiEngine engine, InitializationMode initializationMode) {
        this.engine = Objects.requireNonNull(engine);
        if (initializationMode != InitializationMode.JSII) {
            throw new JsiiException("The only supported initialization mode is '" + (Object)((Object)InitializationMode.JSII) + "'");
        }
    }

    protected JsiiObject(JsiiObjectRef objRef) {
        this(JsiiEngine.getInstance(), objRef);
    }

    JsiiObject(JsiiEngine engine, JsiiObjectRef objRef) {
        this.objRef = objRef;
        this.engine = Objects.requireNonNull(engine);
    }

    @Nullable
    @Deprecated
    protected final <T> T jsiiCall(String method, Class<T> returnType, Object ... args) {
        return this.jsiiCall(method, NativeType.forType(returnType), args);
    }

    @Nullable
    protected final <T> T jsiiCall(String method, NativeType<T> nativeType, Object ... args) {
        JsonNode result = this.engine.getClient().callMethod(this.objRef, method, (ArrayNode)JsiiObjectMapper.valueToTree(args));
        return JsiiObjectMapper.treeToValue(result, nativeType);
    }

    @Nullable
    @Deprecated
    protected static <T> T jsiiStaticCall(Class<?> nativeClass, String method, Class<T> returnType, Object ... args) {
        return JsiiObject.jsiiStaticCall(nativeClass, method, NativeType.forType(returnType), args);
    }

    @Nullable
    protected static <T> T jsiiStaticCall(Class<?> nativeClass, String method, NativeType<T> nativeType, Object ... args) {
        return JsiiObject.jsiiStaticCall(JsiiEngine.getInstance(), nativeClass, method, nativeType, args);
    }

    @Nullable
    static <T> T jsiiStaticCall(JsiiEngine engine, Class<?> nativeClass, String method, NativeType<T> nativeType, Object ... args) {
        String fqn = engine.loadModuleForClass(nativeClass);
        JsonNode result = engine.getClient().callStaticMethod(fqn, method, (ArrayNode)JsiiObjectMapper.valueToTree(args));
        return JsiiObjectMapper.treeToValue(result, nativeType);
    }

    @Nullable
    @Deprecated
    protected final <T> T jsiiAsyncCall(String method, Class<T> returnType, Object ... args) {
        return this.jsiiAsyncCall(method, NativeType.forType(returnType), args);
    }

    @Nullable
    protected final <T> T jsiiAsyncCall(String method, NativeType<T> nativeType, Object ... args) {
        JsiiClient client = this.engine.getClient();
        JsiiPromise promise = client.beginAsyncMethod(this.objRef, method, (ArrayNode)JsiiObjectMapper.valueToTree(args));
        this.engine.processAllPendingCallbacks();
        return JsiiObjectMapper.treeToValue(client.endAsyncMethod(promise), nativeType);
    }

    @Nullable
    @Deprecated
    protected final <T> T jsiiGet(String property, Class<T> type) {
        return this.jsiiGet(property, NativeType.forType(type));
    }

    @Nullable
    protected final <T> T jsiiGet(String property, NativeType<T> type) {
        JsonNode result = this.engine.getClient().getPropertyValue(this.objRef, property);
        return JsiiObjectMapper.treeToValue(result, type);
    }

    @Nullable
    @Deprecated
    protected static <T> T jsiiStaticGet(Class<?> nativeClass, String property, Class<T> type) {
        return JsiiObject.jsiiStaticGet(nativeClass, property, NativeType.forType(type));
    }

    @Nullable
    protected static <T> T jsiiStaticGet(Class<?> nativeClass, String property, NativeType<T> type) {
        return JsiiObject.jsiiStaticGet(JsiiEngine.getInstance(), nativeClass, property, type);
    }

    @Nullable
    static <T> T jsiiStaticGet(JsiiEngine engine, Class<?> nativeClass, String property, NativeType<T> type) {
        String fqn = engine.loadModuleForClass(nativeClass);
        JsonNode result = engine.getClient().getStaticPropertyValue(fqn, property);
        return JsiiObjectMapper.treeToValue(result, type);
    }

    protected final void jsiiSet(String property, @Nullable Object value) {
        this.engine.getClient().setPropertyValue(this.objRef, property, (JsonNode)JsiiObjectMapper.valueToTree(value));
    }

    protected static void jsiiStaticSet(Class<?> nativeClass, String property, @Nullable Object value) {
        JsiiObject.jsiiStaticSet(JsiiEngine.getInstance(), nativeClass, property, value);
    }

    static void jsiiStaticSet(JsiiEngine engine, Class<?> nativeClass, String property, @Nullable Object value) {
        String fqn = engine.loadModuleForClass(nativeClass);
        engine.getClient().setStaticPropertyValue(fqn, property, (JsonNode)JsiiObjectMapper.valueToTree(value));
    }

    final void setObjRef(JsiiObjectRef objRef) {
        this.objRef = objRef;
    }

    final JsiiObjectRef getObjRef() {
        return this.objRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <T extends JsiiObject> T asInterfaceProxy(Class<? extends T> proxyClass) {
        if (!this.proxies.containsKey(proxyClass)) {
            try {
                Constructor<T> constructor = proxyClass.getDeclaredConstructor(JsiiObjectRef.class);
                boolean oldAccessible = constructor.isAccessible();
                try {
                    constructor.setAccessible(true);
                    JsiiObject proxyInstance = (JsiiObject)constructor.newInstance(this.getObjRef());
                    this.proxies.put(proxyClass, proxyInstance);
                }
                finally {
                    constructor.setAccessible(oldAccessible);
                }
            }
            catch (NoSuchMethodException nsme) {
                throw new JsiiException("Unable to find interface proxy constructor on " + proxyClass.getCanonicalName(), nsme);
            }
            catch (InstantiationException | InvocationTargetException e) {
                throw new JsiiException("Unable to initialize interface proxy " + proxyClass.getCanonicalName(), e);
            }
            catch (IllegalAccessException iae) {
                throw new JsiiException("Unable to invoke constructor of " + proxyClass.getCanonicalName(), iae);
            }
        }
        JsiiObject result = this.proxies.get(proxyClass);
        return (T)result;
    }

    public static enum InitializationMode {
        JSII;

    }
}

