/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jsii;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import software.amazon.jsii.JsiiClient;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiException;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiPromise;
import software.amazon.jsii.JsiiSerializable;

public class JsiiObject
implements JsiiSerializable {
    private static final JsiiEngine engine = JsiiEngine.getInstance();
    private final Map<Class<? extends JsiiObject>, JsiiObject> proxies = new HashMap<Class<? extends JsiiObject>, JsiiObject>();
    private JsiiObjectRef objRef;

    protected JsiiObject(InitializationMode initializationMode) {
        if (initializationMode != InitializationMode.JSII) {
            throw new JsiiException("The only supported initialization mode is '" + (Object)((Object)InitializationMode.JSII) + "'");
        }
    }

    protected JsiiObject(JsiiObjectRef objRef) {
        this.objRef = objRef;
    }

    @Nullable
    protected final <T> T jsiiCall(String method, Class<T> returnType, Object ... args) {
        return JsiiObjectMapper.treeToValue(engine.getClient().callMethod(this.objRef, method, (ArrayNode)JsiiObjectMapper.valueToTree(args)), returnType);
    }

    @Nullable
    protected static <T> T jsiiStaticCall(Class<?> nativeClass, String method, Class<T> returnType, Object ... args) {
        String fqn = engine.loadModuleForClass(nativeClass);
        return JsiiObjectMapper.treeToValue(engine.getClient().callStaticMethod(fqn, method, (ArrayNode)JsiiObjectMapper.valueToTree(args)), returnType);
    }

    @Nullable
    protected final <T> T jsiiAsyncCall(String method, Class<T> returnType, Object ... args) {
        JsiiClient client = engine.getClient();
        JsiiPromise promise = client.beginAsyncMethod(this.objRef, method, (ArrayNode)JsiiObjectMapper.valueToTree(args));
        engine.processAllPendingCallbacks();
        return JsiiObjectMapper.treeToValue(client.endAsyncMethod(promise), returnType);
    }

    @Nullable
    protected final <T> T jsiiGet(String property, Class<T> type) {
        return JsiiObjectMapper.treeToValue(engine.getClient().getPropertyValue(this.objRef, property), type);
    }

    @Nullable
    protected static <T> T jsiiStaticGet(Class<?> nativeClass, String property, Class<T> type) {
        String fqn = engine.loadModuleForClass(nativeClass);
        return JsiiObjectMapper.treeToValue(engine.getClient().getStaticPropertyValue(fqn, property), type);
    }

    protected final void jsiiSet(String property, @Nullable Object value) {
        engine.getClient().setPropertyValue(this.objRef, property, (JsonNode)JsiiObjectMapper.valueToTree(value));
    }

    protected static void jsiiStaticSet(Class<?> nativeClass, String property, @Nullable Object value) {
        String fqn = engine.loadModuleForClass(nativeClass);
        engine.getClient().setStaticPropertyValue(fqn, property, (JsonNode)JsiiObjectMapper.valueToTree(value));
    }

    final void setObjRef(JsiiObjectRef objRef) {
        this.objRef = objRef;
    }

    final JsiiObjectRef getObjRef() {
        return this.objRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final JsiiObject asInterfaceProxy(Class<? extends JsiiObject> proxyClass) {
        if (!this.proxies.containsKey(proxyClass)) {
            try {
                Constructor<? extends JsiiObject> constructor = proxyClass.getDeclaredConstructor(JsiiObjectRef.class);
                boolean oldAccessible = constructor.isAccessible();
                try {
                    constructor.setAccessible(true);
                    JsiiObject proxyInstance = constructor.newInstance(this.getObjRef());
                    this.proxies.put(proxyClass, proxyInstance);
                }
                finally {
                    constructor.setAccessible(oldAccessible);
                }
            }
            catch (NoSuchMethodException nsme) {
                throw new JsiiException("Unable to find interface proxy constructor on " + proxyClass.getCanonicalName(), nsme);
            }
            catch (InstantiationException | InvocationTargetException e) {
                throw new JsiiException("Unable to initialize interface proxy " + proxyClass.getCanonicalName(), e);
            }
            catch (IllegalAccessException iae) {
                throw new JsiiException("Unable to invoke constructor of " + proxyClass.getCanonicalName(), iae);
            }
        }
        return this.proxies.get(proxyClass);
    }

    public static enum InitializationMode {
        JSII;

    }
}

