/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.util.storage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.storage.CacheItem;
import software.amazon.jdbc.util.storage.ExpirationCache;

public class ExternallyManagedCache<K, V> {
    private static final Logger LOGGER = Logger.getLogger(ExpirationCache.class.getName());
    protected final Map<K, CacheItem<V>> cache = new ConcurrentHashMap<K, CacheItem<V>>();
    protected final long timeToLiveNanos;

    public ExternallyManagedCache(long timeToLiveNanos) {
        this.timeToLiveNanos = timeToLiveNanos;
    }

    public @Nullable V put(@NonNull K key, @NonNull V value) {
        CacheItem<V> cacheItem = this.cache.put(key, new CacheItem<V>(value, System.nanoTime() + this.timeToLiveNanos));
        if (cacheItem == null) {
            return null;
        }
        return cacheItem.item;
    }

    public @Nullable V get(@NonNull K key) {
        CacheItem<V> cacheItem = this.cache.get(key);
        if (cacheItem == null) {
            return null;
        }
        if (cacheItem.isExpired()) {
            return null;
        }
        return cacheItem.item;
    }

    public @NonNull V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        CacheItem cacheItem = this.cache.compute(key, (k, valueItem) -> {
            if (valueItem == null) {
                return new CacheItem(mappingFunction.apply((K)k), System.nanoTime() + this.timeToLiveNanos);
            }
            valueItem.extendExpiration(this.timeToLiveNanos);
            return valueItem;
        });
        return cacheItem.item;
    }

    public void extendExpiration(K key) {
        CacheItem<V> cacheItem = this.cache.get(key);
        if (cacheItem != null) {
            cacheItem.extendExpiration(this.timeToLiveNanos);
        } else {
            LOGGER.finest(Messages.get("ExternallyManagedCache.extendExpirationOnNonExistingKey", new Object[]{key}));
        }
    }

    public @Nullable V remove(K key) {
        CacheItem<V> cacheItem = this.cache.remove(key);
        if (cacheItem == null) {
            return null;
        }
        return cacheItem.item;
    }

    public @Nullable V removeIf(K key, Predicate<V> predicate) {
        ArrayList removedItemList = new ArrayList(1);
        this.cache.computeIfPresent(key, (k, valueItem) -> {
            if (predicate.test(valueItem.item)) {
                removedItemList.add(valueItem.item);
                return null;
            }
            return valueItem;
        });
        if (removedItemList.isEmpty()) {
            return null;
        }
        return (V)removedItemList.get(0);
    }

    public @Nullable V removeExpiredIf(K key, Predicate<V> predicate) {
        ArrayList removedItemList = new ArrayList(1);
        this.cache.computeIfPresent(key, (k, valueItem) -> {
            if (valueItem.isExpired() && predicate.test(valueItem.item)) {
                removedItemList.add(valueItem.item);
                return null;
            }
            return valueItem;
        });
        if (removedItemList.isEmpty()) {
            return null;
        }
        return (V)removedItemList.get(0);
    }

    public Map<K, V> getEntries() {
        HashMap entries = new HashMap();
        for (Map.Entry<K, CacheItem<V>> entry : this.cache.entrySet()) {
            entries.put(entry.getKey(), entry.getValue().item);
        }
        return entries;
    }
}

