/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.failover2;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import software.amazon.jdbc.AwsWrapperProperty;
import software.amazon.jdbc.HostListProviderService;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.JdbcCallable;
import software.amazon.jdbc.JdbcMethod;
import software.amazon.jdbc.PluginManagerService;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.hostavailability.HostAvailability;
import software.amazon.jdbc.plugin.AbstractConnectionPlugin;
import software.amazon.jdbc.plugin.failover.FailoverFailedSQLException;
import software.amazon.jdbc.plugin.failover.FailoverMode;
import software.amazon.jdbc.plugin.failover.FailoverSuccessSQLException;
import software.amazon.jdbc.plugin.failover.TransactionStateUnknownSQLException;
import software.amazon.jdbc.plugin.failover2.ReaderFailoverResult;
import software.amazon.jdbc.plugin.staledns.AuroraStaleDnsHelper;
import software.amazon.jdbc.targetdriverdialect.TargetDriverDialect;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.RdsUrlType;
import software.amazon.jdbc.util.RdsUtils;
import software.amazon.jdbc.util.SqlState;
import software.amazon.jdbc.util.Utils;
import software.amazon.jdbc.util.WrapperUtils;
import software.amazon.jdbc.util.telemetry.TelemetryContext;
import software.amazon.jdbc.util.telemetry.TelemetryCounter;
import software.amazon.jdbc.util.telemetry.TelemetryFactory;
import software.amazon.jdbc.util.telemetry.TelemetryTraceLevel;

public class FailoverConnectionPlugin
extends AbstractConnectionPlugin {
    private static final Logger LOGGER = Logger.getLogger(FailoverConnectionPlugin.class.getName());
    private static final String TELEMETRY_WRITER_FAILOVER = "failover to writer node";
    private static final String TELEMETRY_READER_FAILOVER = "failover to replica";
    public static final AwsWrapperProperty FAILOVER_TIMEOUT_MS = new AwsWrapperProperty("failoverTimeoutMs", "300000", "Maximum allowed time for the failover process.");
    public static final AwsWrapperProperty FAILOVER_MODE = new AwsWrapperProperty("failoverMode", null, "Set node role to follow during failover.");
    public static final AwsWrapperProperty TELEMETRY_FAILOVER_ADDITIONAL_TOP_TRACE = new AwsWrapperProperty("telemetryFailoverAdditionalTopTrace", "false", "Post an additional top-level trace for failover process.");
    public static final AwsWrapperProperty FAILOVER_READER_HOST_SELECTOR_STRATEGY = new AwsWrapperProperty("failoverReaderHostSelectorStrategy", "random", "The strategy that should be used to select a new reader host while opening a new connection.");
    public static final AwsWrapperProperty ENABLE_CONNECT_FAILOVER = new AwsWrapperProperty("enableConnectFailover", "false", "Enable/disable cluster-aware failover if the initial connection to the database fails due to a network exception. Note that this may result in a connection to a different instance in the cluster than was specified by the URL.");
    public static final AwsWrapperProperty SKIP_FAILOVER_ON_INTERRUPTED_THREAD = new AwsWrapperProperty("skipFailoverOnInterruptedThread", "false", "Enable to skip failover if the current thread is interrupted.");
    private final Set<String> subscribedMethods;
    protected final PluginService pluginService;
    protected final Properties properties;
    protected int failoverTimeoutMsSetting;
    protected FailoverMode failoverMode;
    protected boolean telemetryFailoverAdditionalTopTraceSetting;
    protected String failoverReaderHostSelectorStrategySetting;
    protected boolean closedExplicitly = false;
    protected boolean isClosed = false;
    protected final RdsUtils rdsHelper;
    protected Throwable lastExceptionDealtWith = null;
    protected PluginManagerService pluginManagerService;
    protected boolean isInTransaction = false;
    protected RdsUrlType rdsUrlType;
    protected HostListProviderService hostListProviderService;
    protected final AuroraStaleDnsHelper staleDnsHelper;
    protected final TelemetryCounter failoverWriterTriggeredCounter;
    protected final TelemetryCounter failoverWriterSuccessCounter;
    protected final TelemetryCounter failoverWriterFailedCounter;
    protected final TelemetryCounter failoverReaderTriggeredCounter;
    protected final TelemetryCounter failoverReaderSuccessCounter;
    protected final TelemetryCounter failoverReaderFailedCounter;
    protected final boolean skipFailoverOnInterruptedThread;

    public FailoverConnectionPlugin(PluginService pluginService, Properties properties) {
        this(pluginService, properties, new RdsUtils());
    }

    FailoverConnectionPlugin(PluginService pluginService, Properties properties, RdsUtils rdsHelper) {
        this.pluginService = pluginService;
        this.properties = properties;
        this.rdsHelper = rdsHelper;
        if (pluginService instanceof PluginManagerService) {
            this.pluginManagerService = (PluginManagerService)((Object)pluginService);
        }
        this.staleDnsHelper = new AuroraStaleDnsHelper(this.pluginService);
        this.failoverTimeoutMsSetting = FAILOVER_TIMEOUT_MS.getInteger(this.properties);
        this.telemetryFailoverAdditionalTopTraceSetting = TELEMETRY_FAILOVER_ADDITIONAL_TOP_TRACE.getBoolean(this.properties);
        this.failoverReaderHostSelectorStrategySetting = FAILOVER_READER_HOST_SELECTOR_STRATEGY.getString(this.properties);
        this.skipFailoverOnInterruptedThread = SKIP_FAILOVER_ON_INTERRUPTED_THREAD.getBoolean(this.properties);
        TelemetryFactory telemetryFactory = this.pluginService.getTelemetryFactory();
        this.failoverWriterTriggeredCounter = telemetryFactory.createCounter("writerFailover.triggered.count");
        this.failoverWriterSuccessCounter = telemetryFactory.createCounter("writerFailover.completed.success.count");
        this.failoverWriterFailedCounter = telemetryFactory.createCounter("writerFailover.completed.failed.count");
        this.failoverReaderTriggeredCounter = telemetryFactory.createCounter("readerFailover.triggered.count");
        this.failoverReaderSuccessCounter = telemetryFactory.createCounter("readerFailover.completed.success.count");
        this.failoverReaderFailedCounter = telemetryFactory.createCounter("readerFailover.completed.failed.count");
        HashSet<String> methods = new HashSet<String>();
        methods.add(JdbcMethod.CONNECTION_CLEARWARNINGS.methodName);
        methods.add(JdbcMethod.INITHOSTPROVIDER.methodName);
        methods.add(JdbcMethod.CONNECT.methodName);
        methods.add(JdbcMethod.CONNECTION_SETAUTOCOMMIT.methodName);
        methods.addAll(this.pluginService.getTargetDriverDialect().getNetworkBoundMethodNames(this.properties));
        this.subscribedMethods = Collections.unmodifiableSet(methods);
    }

    @Override
    public Set<String> getSubscribedMethods() {
        return this.subscribedMethods;
    }

    @Override
    public <T, E extends Exception> T execute(Class<T> resultClass, Class<E> exceptionClass, Object methodInvokeOn, String methodName, JdbcCallable<T, E> jdbcMethodFunc, Object[] jdbcMethodArgs) throws E {
        try {
            if (this.pluginService.getCurrentConnection() != null && !this.canDirectExecute(methodName) && !this.closedExplicitly && this.pluginService.getCurrentConnection().isClosed()) {
                this.pickNewConnection();
            }
        }
        catch (SQLException ex) {
            throw WrapperUtils.wrapExceptionIfNeeded(exceptionClass, ex);
        }
        if (this.canDirectExecute(methodName)) {
            return jdbcMethodFunc.call();
        }
        if (this.isClosed && !this.allowedOnClosedConnection(methodName)) {
            try {
                this.invalidInvocationOnClosedConnection();
            }
            catch (SQLException ex) {
                throw WrapperUtils.wrapExceptionIfNeeded(exceptionClass, ex);
            }
        }
        T result = null;
        try {
            result = jdbcMethodFunc.call();
        }
        catch (IllegalStateException e) {
            this.dealWithIllegalStateException(e, exceptionClass);
        }
        catch (Exception e) {
            this.dealWithOriginalException(e, null, exceptionClass);
        }
        return result;
    }

    @Override
    public void initHostProvider(String driverProtocol, String initialUrl, Properties properties, HostListProviderService hostListProviderService, JdbcCallable<Void, SQLException> initHostProviderFunc) throws SQLException {
        this.initHostProvider(hostListProviderService, initHostProviderFunc);
    }

    void initHostProvider(HostListProviderService hostListProviderService, JdbcCallable<Void, SQLException> initHostProviderFunc) throws SQLException {
        this.hostListProviderService = hostListProviderService;
        initHostProviderFunc.call();
    }

    protected boolean isFailoverEnabled() {
        return !RdsUrlType.RDS_PROXY.equals((Object)this.rdsUrlType) && !Utils.isNullOrEmpty(this.pluginService.getAllHosts());
    }

    protected void invalidInvocationOnClosedConnection() throws SQLException {
        if (!this.closedExplicitly) {
            this.isClosed = false;
            this.pickNewConnection();
            LOGGER.info(Messages.get("Failover.connectionChangedError"));
            throw new FailoverSuccessSQLException();
        }
        String reason = Messages.get("Failover.noOperationsAfterConnectionClosed");
        throw new SQLException(reason, SqlState.CONNECTION_NOT_OPEN.getState());
    }

    protected boolean allowedOnClosedConnection(String methodName) {
        TargetDriverDialect dialect = this.pluginService.getTargetDriverDialect();
        return dialect.getAllowedOnConnectionMethodNames().contains(methodName);
    }

    protected <E extends Exception> void dealWithOriginalException(Throwable originalException, Throwable wrapperException, Class<E> exceptionClass) throws E {
        Throwable exceptionToThrow = wrapperException;
        if (originalException != null) {
            LOGGER.finer(() -> Messages.get("Failover.detectedException", new Object[]{originalException.getMessage()}));
            if (this.lastExceptionDealtWith != originalException && this.shouldExceptionTriggerConnectionSwitch(originalException)) {
                this.invalidateCurrentConnection();
                this.pluginService.setAvailability(this.pluginService.getCurrentHostSpec().getAliases(), HostAvailability.NOT_AVAILABLE);
                try {
                    this.pickNewConnection();
                }
                catch (SQLException e) {
                    throw WrapperUtils.wrapExceptionIfNeeded(exceptionClass, e);
                }
                this.lastExceptionDealtWith = originalException;
            }
            if (originalException instanceof Error) {
                throw (Error)originalException;
            }
            exceptionToThrow = originalException;
        }
        if (exceptionToThrow instanceof Error) {
            throw (Error)exceptionToThrow;
        }
        throw WrapperUtils.wrapExceptionIfNeeded(exceptionClass, exceptionToThrow);
    }

    protected <E extends Exception> void dealWithIllegalStateException(IllegalStateException e, Class<E> exceptionClass) throws E {
        this.dealWithOriginalException(e.getCause(), e, exceptionClass);
    }

    protected void failover() throws SQLException {
        if (this.failoverMode == FailoverMode.STRICT_WRITER) {
            this.failoverWriter();
        } else {
            this.failoverReader();
        }
    }

    protected void failoverReader() throws SQLException {
        TelemetryFactory telemetryFactory = this.pluginService.getTelemetryFactory();
        TelemetryContext telemetryContext = telemetryFactory.openTelemetryContext(TELEMETRY_READER_FAILOVER, TelemetryTraceLevel.NESTED);
        if (this.failoverReaderTriggeredCounter != null) {
            this.failoverReaderTriggeredCounter.inc();
        }
        long failoverStartNano = System.nanoTime();
        long failoverEndNano = failoverStartNano + TimeUnit.MILLISECONDS.toNanos(this.failoverTimeoutMsSetting);
        try {
            LOGGER.fine(() -> Messages.get("Failover.startReaderFailover"));
            if (!this.pluginService.forceRefreshHostList(false, 0L)) {
                LOGGER.severe(Messages.get("Failover.failoverReaderUnableToRefreshHostList"));
                throw new FailoverFailedSQLException(Messages.get("Failover.failoverReaderUnableToRefreshHostList"));
            }
            try {
                ReaderFailoverResult result = this.getReaderFailoverConnection(failoverEndNano);
                this.pluginService.setCurrentConnection(result.getConnection(), result.getHostSpec());
            }
            catch (TimeoutException e) {
                LOGGER.severe(Messages.get("Failover.unableToConnectToReader"));
                throw new FailoverFailedSQLException(Messages.get("Failover.unableToConnectToReader"));
            }
            LOGGER.info(() -> Messages.get("Failover.establishedConnection", new Object[]{this.pluginService.getCurrentHostSpec()}));
            this.throwFailoverSuccessException();
        }
        catch (FailoverSuccessSQLException ex) {
            if (this.failoverReaderSuccessCounter != null) {
                this.failoverReaderSuccessCounter.inc();
            }
            if (telemetryContext != null) {
                telemetryContext.setSuccess(true);
                telemetryContext.setException(ex);
            }
            throw ex;
        }
        catch (Exception ex) {
            if (telemetryContext != null) {
                telemetryContext.setSuccess(false);
                telemetryContext.setException(ex);
            }
            if (this.failoverReaderFailedCounter != null) {
                this.failoverReaderFailedCounter.inc();
            }
            throw ex;
        }
        finally {
            LOGGER.finest(() -> Messages.get("Failover.readerFailoverElapsed", new Object[]{TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - failoverStartNano)}));
            if (telemetryContext != null) {
                telemetryContext.closeContext();
                if (this.telemetryFailoverAdditionalTopTraceSetting) {
                    telemetryFactory.postCopy(telemetryContext, TelemetryTraceLevel.FORCE_TOP_LEVEL);
                }
            }
        }
    }

    protected ReaderFailoverResult getReaderFailoverConnection(long failoverEndTimeNano) throws TimeoutException {
        List<HostSpec> hosts = this.pluginService.getHosts();
        Set readerCandidates = hosts.stream().filter(hostSpec -> HostRole.READER.equals((Object)hostSpec.getRole())).collect(Collectors.toSet());
        HostSpec originalWriter = hosts.stream().filter(hostSpec -> HostRole.WRITER.equals((Object)hostSpec.getRole())).findFirst().orElse(null);
        boolean isOriginalWriterStillWriter = false;
        do {
            HashSet remainingReaders = new HashSet(readerCandidates);
            while (!remainingReaders.isEmpty() && System.nanoTime() < failoverEndTimeNano) {
                HostSpec readerCandidate;
                try {
                    readerCandidate = this.pluginService.getHostSpecByStrategy(new ArrayList<HostSpec>(remainingReaders), HostRole.READER, this.failoverReaderHostSelectorStrategySetting);
                }
                catch (UnsupportedOperationException | SQLException ex) {
                    LOGGER.finest(Utils.logTopology(new ArrayList<HostSpec>(remainingReaders), Messages.get("Failover.errorSelectingReaderHost", new Object[]{ex.getMessage()})));
                    break;
                }
                if (readerCandidate == null) {
                    LOGGER.finest(Utils.logTopology(new ArrayList<HostSpec>(remainingReaders), Messages.get("Failover.readerCandidateNull")));
                    break;
                }
                try {
                    Connection candidateConn = this.pluginService.connect(readerCandidate, this.properties, this);
                    HostRole role = this.pluginService.getHostRole(candidateConn);
                    if (role == HostRole.READER || this.failoverMode != FailoverMode.STRICT_READER) {
                        HostSpec updatedHostSpec = new HostSpec(readerCandidate, role);
                        return new ReaderFailoverResult(candidateConn, updatedHostSpec);
                    }
                    remainingReaders.remove(readerCandidate);
                    candidateConn.close();
                    if (role == HostRole.WRITER) {
                        readerCandidates.remove(readerCandidate);
                        continue;
                    }
                    LOGGER.fine(Messages.get("Failover.strictReaderUnknownHostRole", new Object[]{readerCandidate.getUrl()}));
                }
                catch (SQLException ex) {
                    remainingReaders.remove(readerCandidate);
                }
            }
            if (originalWriter == null || System.nanoTime() > failoverEndTimeNano || this.failoverMode == FailoverMode.STRICT_READER && isOriginalWriterStillWriter) continue;
            try {
                Connection candidateConn = this.pluginService.connect(originalWriter, this.properties, this);
                HostRole role = this.pluginService.getHostRole(candidateConn);
                if (role == HostRole.READER || this.failoverMode != FailoverMode.STRICT_READER) {
                    HostSpec updatedHostSpec = new HostSpec(originalWriter, role);
                    return new ReaderFailoverResult(candidateConn, updatedHostSpec);
                }
                candidateConn.close();
                if (role == HostRole.WRITER) {
                    isOriginalWriterStillWriter = true;
                    continue;
                }
                LOGGER.fine(Messages.get("Failover.strictReaderUnknownHostRole", new Object[]{originalWriter.getUrl()}));
            }
            catch (SQLException ex) {
                LOGGER.fine(Messages.get("Failover.failedReaderConnection", new Object[]{originalWriter.getUrl()}));
            }
        } while (System.nanoTime() < failoverEndTimeNano);
        throw new TimeoutException(Messages.get("Failover.failoverReaderTimeout"));
    }

    protected void throwFailoverSuccessException() throws SQLException {
        if (this.isInTransaction || this.pluginService.isInTransaction()) {
            if (this.pluginManagerService != null) {
                this.pluginManagerService.setInTransaction(false);
            }
            String errorMessage = Messages.get("Failover.transactionResolutionUnknownError");
            LOGGER.info(errorMessage);
            throw new TransactionStateUnknownSQLException();
        }
        LOGGER.severe(() -> Messages.get("Failover.connectionChangedError"));
        throw new FailoverSuccessSQLException();
    }

    protected void failoverWriter() throws SQLException {
        TelemetryFactory telemetryFactory = this.pluginService.getTelemetryFactory();
        TelemetryContext telemetryContext = telemetryFactory.openTelemetryContext(TELEMETRY_WRITER_FAILOVER, TelemetryTraceLevel.NESTED);
        if (this.failoverWriterTriggeredCounter != null) {
            this.failoverWriterTriggeredCounter.inc();
        }
        long failoverStartTimeNano = System.nanoTime();
        try {
            Connection writerCandidateConn;
            LOGGER.info(() -> Messages.get("Failover.startWriterFailover"));
            if (!this.pluginService.forceRefreshHostList(true, this.failoverTimeoutMsSetting)) {
                if (this.failoverWriterFailedCounter != null) {
                    this.failoverWriterFailedCounter.inc();
                }
                LOGGER.severe(Messages.get("Failover.unableToRefreshHostList"));
                throw new FailoverFailedSQLException(Messages.get("Failover.unableToRefreshHostList"));
            }
            List<HostSpec> updatedHosts = this.pluginService.getAllHosts();
            HostSpec writerCandidate = updatedHosts.stream().filter(x -> x.getRole() == HostRole.WRITER).findFirst().orElse(null);
            if (writerCandidate == null) {
                if (this.failoverWriterFailedCounter != null) {
                    this.failoverWriterFailedCounter.inc();
                }
                String message = Utils.logTopology(updatedHosts, Messages.get("Failover.noWriterHost"));
                LOGGER.severe(message);
                throw new FailoverFailedSQLException(message);
            }
            List<HostSpec> allowedHosts = this.pluginService.getHosts();
            if (!Utils.containsUrl(allowedHosts, writerCandidate.getUrl())) {
                if (this.failoverWriterFailedCounter != null) {
                    this.failoverWriterFailedCounter.inc();
                }
                String topologyString = Utils.logTopology(allowedHosts, "");
                LOGGER.severe(Messages.get("Failover.newWriterNotAllowed", new Object[]{writerCandidate.getUrl(), topologyString}));
                throw new FailoverFailedSQLException(Messages.get("Failover.newWriterNotAllowed", new Object[]{writerCandidate.getUrl(), topologyString}));
            }
            try {
                writerCandidateConn = this.pluginService.connect(writerCandidate, this.properties, this);
            }
            catch (SQLException ex) {
                if (this.failoverWriterFailedCounter != null) {
                    this.failoverWriterFailedCounter.inc();
                }
                LOGGER.severe(Messages.get("Failover.exceptionConnectingToWriter", new Object[]{writerCandidate.getHost()}));
                throw new FailoverFailedSQLException(Messages.get("Failover.exceptionConnectingToWriter", new Object[]{writerCandidate.getHost()}), ex);
            }
            HostRole role = this.pluginService.getHostRole(writerCandidateConn);
            if (role != HostRole.WRITER) {
                try {
                    writerCandidateConn.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                if (this.failoverWriterFailedCounter != null) {
                    this.failoverWriterFailedCounter.inc();
                }
                LOGGER.severe(Messages.get("Failover.unexpectedReaderRole", new Object[]{writerCandidate.getHost(), role}));
                throw new FailoverFailedSQLException(Messages.get("Failover.unexpectedReaderRole", new Object[]{writerCandidate.getHost(), role}));
            }
            this.pluginService.setCurrentConnection(writerCandidateConn, writerCandidate);
            LOGGER.fine(() -> Messages.get("Failover.establishedConnection", new Object[]{this.pluginService.getCurrentHostSpec()}));
            this.throwFailoverSuccessException();
        }
        catch (FailoverSuccessSQLException ex) {
            if (this.failoverWriterSuccessCounter != null) {
                this.failoverWriterSuccessCounter.inc();
            }
            if (telemetryContext != null) {
                telemetryContext.setSuccess(true);
                telemetryContext.setException(ex);
            }
            throw ex;
        }
        catch (Exception ex) {
            if (telemetryContext != null) {
                telemetryContext.setSuccess(false);
                telemetryContext.setException(ex);
            }
            if (this.failoverWriterFailedCounter != null) {
                this.failoverWriterFailedCounter.inc();
            }
            throw ex;
        }
        finally {
            LOGGER.finest(() -> Messages.get("Failover.writerFailoverElapsed", new Object[]{TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - failoverStartTimeNano)}));
            if (telemetryContext != null) {
                telemetryContext.closeContext();
                if (this.telemetryFailoverAdditionalTopTraceSetting) {
                    telemetryFactory.postCopy(telemetryContext, TelemetryTraceLevel.FORCE_TOP_LEVEL);
                }
            }
        }
    }

    protected void invalidateCurrentConnection() {
        Connection conn = this.pluginService.getCurrentConnection();
        if (conn == null) {
            return;
        }
        if (this.pluginService.isInTransaction()) {
            this.isInTransaction = this.pluginService.isInTransaction();
            try {
                conn.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        try {
            if (!conn.isClosed()) {
                conn.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void pickNewConnection() throws SQLException {
        if (this.isClosed && this.closedExplicitly) {
            LOGGER.fine(() -> Messages.get("Failover.connectionClosedExplicitly"));
            return;
        }
        this.failover();
    }

    protected boolean shouldExceptionTriggerConnectionSwitch(Throwable t) {
        if (!this.isFailoverEnabled()) {
            LOGGER.fine(() -> Messages.get("Failover.failoverDisabled"));
            return false;
        }
        if (this.skipFailoverOnInterruptedThread && Thread.currentThread().isInterrupted()) {
            LOGGER.fine(() -> Messages.get("Failover.skipFailoverOnInterruptedThread"));
            return false;
        }
        String sqlState = null;
        if (t instanceof SQLException) {
            sqlState = ((SQLException)t).getSQLState();
        }
        if (sqlState == null) {
            return false;
        }
        return this.pluginService.isNetworkException(t, this.pluginService.getTargetDriverDialect());
    }

    protected boolean canDirectExecute(String methodName) {
        return methodName.equals(JdbcMethod.CONNECTION_CLOSE.methodName) || methodName.equals(JdbcMethod.CONNECTION_ISCLOSED.methodName) || methodName.equals(JdbcMethod.CONNECTION_ABORT.methodName);
    }

    protected void initFailoverMode() {
        if (this.rdsUrlType == null) {
            this.failoverMode = FailoverMode.fromValue(FAILOVER_MODE.getString(this.properties));
            HostSpec initialHostSpec = this.hostListProviderService.getInitialConnectionHostSpec();
            this.rdsUrlType = this.rdsHelper.identifyRdsType(initialHostSpec.getHost());
            if (this.failoverMode == null) {
                this.failoverMode = this.rdsUrlType == RdsUrlType.RDS_READER_CLUSTER ? FailoverMode.READER_OR_WRITER : FailoverMode.STRICT_WRITER;
            }
            LOGGER.finer(() -> Messages.get("Failover.parameterValue", new Object[]{"failoverMode", this.failoverMode}));
        }
    }

    @Override
    public Connection connect(String driverProtocol, HostSpec hostSpec, Properties props, boolean isInitialConnection, JdbcCallable<Connection, SQLException> connectFunc) throws SQLException {
        this.initFailoverMode();
        Connection conn = null;
        if (!ENABLE_CONNECT_FAILOVER.getBoolean(props)) {
            return this.staleDnsHelper.getVerifiedConnection(isInitialConnection, this.hostListProviderService, driverProtocol, hostSpec, props, connectFunc);
        }
        HostSpec hostSpecWithAvailability = this.pluginService.getHosts().stream().filter(x -> x.getHostAndPort().equals(hostSpec.getHostAndPort())).findFirst().orElse(null);
        if (hostSpecWithAvailability == null || hostSpecWithAvailability.getAvailability() != HostAvailability.NOT_AVAILABLE) {
            try {
                conn = this.staleDnsHelper.getVerifiedConnection(isInitialConnection, this.hostListProviderService, driverProtocol, hostSpec, props, connectFunc);
            }
            catch (SQLException e) {
                if (!this.shouldExceptionTriggerConnectionSwitch(e)) {
                    throw e;
                }
                this.pluginService.setAvailability(hostSpec.asAliases(), HostAvailability.NOT_AVAILABLE);
                try {
                    this.failover();
                }
                catch (FailoverSuccessSQLException failoverSuccessException) {
                    conn = this.pluginService.getCurrentConnection();
                }
            }
        } else {
            try {
                this.pluginService.refreshHostList();
                this.failover();
            }
            catch (FailoverSuccessSQLException failoverSuccessException) {
                conn = this.pluginService.getCurrentConnection();
            }
        }
        if (conn == null) {
            throw new SQLException(Messages.get("Failover.unableToConnect"));
        }
        if (isInitialConnection) {
            this.pluginService.refreshHostList(conn);
        }
        return conn;
    }

    static {
        PropertyDefinition.registerPluginProperties(FailoverConnectionPlugin.class);
    }
}

