/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.AllowedAndBlockedHosts;
import software.amazon.jdbc.BlockingHostListProvider;
import software.amazon.jdbc.ConnectionPlugin;
import software.amazon.jdbc.ConnectionPluginManager;
import software.amazon.jdbc.ConnectionProvider;
import software.amazon.jdbc.ConnectionProviderManager;
import software.amazon.jdbc.HostListProvider;
import software.amazon.jdbc.HostListProviderService;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.HostSpecBuilder;
import software.amazon.jdbc.NodeChangeOptions;
import software.amazon.jdbc.OldConnectionSuggestedAction;
import software.amazon.jdbc.PluginManagerService;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.PooledConnectionProvider;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.cleanup.CanReleaseResources;
import software.amazon.jdbc.dialect.Dialect;
import software.amazon.jdbc.dialect.DialectManager;
import software.amazon.jdbc.dialect.DialectProvider;
import software.amazon.jdbc.dialect.HostListProviderSupplier;
import software.amazon.jdbc.exceptions.ExceptionHandler;
import software.amazon.jdbc.exceptions.ExceptionManager;
import software.amazon.jdbc.hostavailability.HostAvailability;
import software.amazon.jdbc.hostavailability.HostAvailabilityStrategyFactory;
import software.amazon.jdbc.hostlistprovider.StaticHostListProvider;
import software.amazon.jdbc.profile.ConfigurationProfile;
import software.amazon.jdbc.states.SessionStateService;
import software.amazon.jdbc.states.SessionStateServiceImpl;
import software.amazon.jdbc.targetdriverdialect.TargetDriverDialect;
import software.amazon.jdbc.util.FullServicesContainer;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.Utils;
import software.amazon.jdbc.util.storage.CacheMap;
import software.amazon.jdbc.util.telemetry.TelemetryFactory;

public class PluginServiceImpl
implements PluginService,
CanReleaseResources,
HostListProviderService,
PluginManagerService {
    private static final Logger LOGGER = Logger.getLogger(PluginServiceImpl.class.getName());
    protected static final long DEFAULT_HOST_AVAILABILITY_CACHE_EXPIRE_NANO = TimeUnit.MINUTES.toNanos(5L);
    protected static final CacheMap<String, HostAvailability> hostAvailabilityExpiringCache = new CacheMap();
    protected final FullServicesContainer servicesContainer;
    protected static final CacheMap<String, Object> statusesExpiringCache = new CacheMap();
    protected static final long DEFAULT_STATUS_CACHE_EXPIRE_NANO = TimeUnit.MINUTES.toNanos(60L);
    protected final ConnectionPluginManager pluginManager;
    private final Properties props;
    private final String originalUrl;
    private final String driverProtocol;
    protected volatile HostListProvider hostListProvider;
    protected List<HostSpec> allHosts = new ArrayList<HostSpec>();
    protected Connection currentConnection;
    protected HostSpec currentHostSpec;
    protected HostSpec initialConnectionHostSpec;
    private boolean isInTransaction;
    private final ExceptionManager exceptionManager;
    protected final @Nullable ExceptionHandler exceptionHandler;
    protected final DialectProvider dialectProvider;
    protected Dialect dialect;
    protected TargetDriverDialect targetDriverDialect;
    protected final @Nullable ConfigurationProfile configurationProfile;
    protected final ConnectionProviderManager connectionProviderManager;
    protected final SessionStateService sessionStateService;
    protected final ReentrantLock connectionSwitchLock = new ReentrantLock();

    public PluginServiceImpl(@NonNull FullServicesContainer servicesContainer, @NonNull Properties props, @NonNull String originalUrl, @NonNull String targetDriverProtocol, @NonNull TargetDriverDialect targetDriverDialect) throws SQLException {
        this(servicesContainer, new ExceptionManager(), props, originalUrl, targetDriverProtocol, null, targetDriverDialect, null, null);
    }

    public PluginServiceImpl(@NonNull FullServicesContainer servicesContainer, @NonNull Properties props, @NonNull String originalUrl, @NonNull String targetDriverProtocol, @NonNull TargetDriverDialect targetDriverDialect, @Nullable ConfigurationProfile configurationProfile) throws SQLException {
        this(servicesContainer, new ExceptionManager(), props, originalUrl, targetDriverProtocol, null, targetDriverDialect, configurationProfile, null);
    }

    public PluginServiceImpl(@NonNull FullServicesContainer servicesContainer, @NonNull ExceptionManager exceptionManager, @NonNull Properties props, @NonNull String originalUrl, @NonNull String targetDriverProtocol, @Nullable DialectProvider dialectProvider, @NonNull TargetDriverDialect targetDriverDialect, @Nullable ConfigurationProfile configurationProfile, @Nullable SessionStateService sessionStateService) throws SQLException {
        this.servicesContainer = servicesContainer;
        this.pluginManager = servicesContainer.getConnectionPluginManager();
        this.props = props;
        this.originalUrl = originalUrl;
        this.driverProtocol = targetDriverProtocol;
        this.configurationProfile = configurationProfile;
        this.exceptionManager = exceptionManager;
        this.dialectProvider = dialectProvider != null ? dialectProvider : new DialectManager(this);
        this.targetDriverDialect = targetDriverDialect;
        this.connectionProviderManager = new ConnectionProviderManager(this.pluginManager.getDefaultConnProvider(), this.pluginManager.getEffectiveConnProvider());
        this.sessionStateService = sessionStateService != null ? sessionStateService : new SessionStateServiceImpl(this, this.props);
        this.exceptionHandler = this.configurationProfile != null && this.configurationProfile.getExceptionHandler() != null ? this.configurationProfile.getExceptionHandler() : null;
        this.dialect = this.configurationProfile != null && this.configurationProfile.getDialect() != null ? this.configurationProfile.getDialect() : this.dialectProvider.getDialect(this.driverProtocol, this.originalUrl, this.props);
    }

    @Override
    public Connection getCurrentConnection() {
        return this.currentConnection;
    }

    @Override
    public HostSpec getCurrentHostSpec() {
        if (this.currentHostSpec == null) {
            this.currentHostSpec = this.initialConnectionHostSpec;
            if (this.currentHostSpec == null) {
                if (this.getAllHosts().isEmpty()) {
                    throw new RuntimeException(Messages.get("PluginServiceImpl.hostListEmpty"));
                }
                this.currentHostSpec = this.getWriter(this.getAllHosts());
                List<HostSpec> allowedHosts = this.getHosts();
                if (!Utils.containsUrl(allowedHosts, this.currentHostSpec.getUrl())) {
                    throw new RuntimeException(Messages.get("PluginServiceImpl.currentHostNotAllowed", new Object[]{this.currentHostSpec == null ? "<null>" : this.currentHostSpec.getUrl(), Utils.logTopology(allowedHosts, "")}));
                }
                if (this.currentHostSpec == null) {
                    this.currentHostSpec = this.getHosts().get(0);
                }
            }
            if (this.currentHostSpec == null) {
                throw new RuntimeException("Current host is undefined.");
            }
            LOGGER.finest(() -> "Set current host to " + this.currentHostSpec);
        }
        return this.currentHostSpec;
    }

    @Override
    public void setInitialConnectionHostSpec(@NonNull HostSpec initialConnectionHostSpec) {
        this.initialConnectionHostSpec = initialConnectionHostSpec;
    }

    @Override
    public HostSpec getInitialConnectionHostSpec() {
        return this.initialConnectionHostSpec;
    }

    @Override
    public String getOriginalUrl() {
        return this.originalUrl;
    }

    @Override
    @Deprecated
    public void setAllowedAndBlockedHosts(AllowedAndBlockedHosts allowedAndBlockedHosts) {
        this.servicesContainer.getStorageService().set(this.initialConnectionHostSpec.getHost(), allowedAndBlockedHosts);
    }

    @Override
    public boolean acceptsStrategy(HostRole role, String strategy) throws SQLException {
        return this.pluginManager.acceptsStrategy(role, strategy);
    }

    @Override
    public HostSpec getHostSpecByStrategy(HostRole role, String strategy) throws SQLException {
        return this.pluginManager.getHostSpecByStrategy(role, strategy);
    }

    @Override
    public HostSpec getHostSpecByStrategy(List<HostSpec> hosts, HostRole role, String strategy) throws SQLException {
        return this.pluginManager.getHostSpecByStrategy(hosts, role, strategy);
    }

    @Override
    public HostRole getHostRole(Connection conn) throws SQLException {
        return this.hostListProvider.getHostRole(conn);
    }

    private HostSpec getWriter(@NonNull List<HostSpec> hosts) {
        for (HostSpec hostSpec : hosts) {
            if (hostSpec.getRole() != HostRole.WRITER) continue;
            return hostSpec;
        }
        return null;
    }

    @Override
    @Deprecated
    public ConnectionProvider getConnectionProvider() {
        return this.pluginManager.defaultConnProvider;
    }

    @Override
    public boolean isPooledConnectionProvider(HostSpec host, Properties props) {
        ConnectionProvider connectionProvider = this.connectionProviderManager.getConnectionProvider(this.driverProtocol, host, props);
        return connectionProvider instanceof PooledConnectionProvider;
    }

    @Override
    public String getDriverProtocol() {
        return this.driverProtocol;
    }

    @Override
    public void setCurrentConnection(@NonNull Connection connection, @NonNull HostSpec hostSpec) throws SQLException {
        this.setCurrentConnection(connection, hostSpec, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnumSet<NodeChangeOptions> setCurrentConnection(@NonNull Connection connection, @NonNull HostSpec hostSpec, @Nullable ConnectionPlugin skipNotificationForThisPlugin) throws SQLException {
        this.connectionSwitchLock.lock();
        try {
            EnumSet<NodeChangeOptions> changes;
            block16: {
                if (this.currentConnection == null) {
                    this.currentConnection = connection;
                    this.currentHostSpec = hostSpec;
                    this.sessionStateService.reset();
                    EnumSet<NodeChangeOptions> changes2 = EnumSet.of(NodeChangeOptions.INITIAL_CONNECTION);
                    this.pluginManager.notifyConnectionChanged(changes2, skipNotificationForThisPlugin);
                    EnumSet<NodeChangeOptions> enumSet = changes2;
                    return enumSet;
                }
                changes = this.compare(this.currentConnection, this.currentHostSpec, connection, hostSpec);
                if (!changes.isEmpty()) {
                    Connection oldConnection = this.currentConnection;
                    boolean isInTransaction = this.isInTransaction;
                    this.sessionStateService.begin();
                    try {
                        boolean shouldCloseConnection;
                        this.currentConnection = connection;
                        this.currentHostSpec = hostSpec;
                        this.sessionStateService.applyCurrentSessionState(connection);
                        this.setInTransaction(false);
                        if (isInTransaction && PropertyDefinition.ROLLBACK_ON_SWITCH.getBoolean(this.props)) {
                            try {
                                oldConnection.rollback();
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                        }
                        EnumSet<OldConnectionSuggestedAction> pluginOpinions = this.pluginManager.notifyConnectionChanged(changes, skipNotificationForThisPlugin);
                        boolean bl = shouldCloseConnection = changes.contains((Object)NodeChangeOptions.CONNECTION_OBJECT_CHANGED) && !oldConnection.isClosed() && !pluginOpinions.contains((Object)OldConnectionSuggestedAction.PRESERVE);
                        if (!shouldCloseConnection) break block16;
                        try {
                            this.sessionStateService.applyPristineSessionState(oldConnection);
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        try {
                            oldConnection.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    finally {
                        this.sessionStateService.complete();
                    }
                }
            }
            EnumSet<NodeChangeOptions> enumSet = changes;
            return enumSet;
        }
        finally {
            this.connectionSwitchLock.unlock();
        }
    }

    protected EnumSet<NodeChangeOptions> compare(@NonNull Connection connA, @NonNull HostSpec hostSpecA, @NonNull Connection connB, @NonNull HostSpec hostSpecB) {
        EnumSet<NodeChangeOptions> changes = EnumSet.noneOf(NodeChangeOptions.class);
        if (connA != connB) {
            changes.add(NodeChangeOptions.CONNECTION_OBJECT_CHANGED);
        }
        changes.addAll(this.compare(hostSpecA, hostSpecB));
        return changes;
    }

    protected EnumSet<NodeChangeOptions> compare(@NonNull HostSpec hostSpecA, @NonNull HostSpec hostSpecB) {
        EnumSet<NodeChangeOptions> changes = EnumSet.noneOf(NodeChangeOptions.class);
        if (!hostSpecA.getHost().equals(hostSpecB.getHost()) || hostSpecA.getPort() != hostSpecB.getPort()) {
            changes.add(NodeChangeOptions.HOSTNAME);
        }
        if (hostSpecA.getRole() != hostSpecB.getRole()) {
            if (hostSpecB.getRole() == HostRole.WRITER) {
                changes.add(NodeChangeOptions.PROMOTED_TO_WRITER);
            } else if (hostSpecB.getRole() == HostRole.READER) {
                changes.add(NodeChangeOptions.PROMOTED_TO_READER);
            }
        }
        if (hostSpecA.getAvailability() != hostSpecB.getAvailability()) {
            if (hostSpecB.getAvailability() == HostAvailability.AVAILABLE) {
                changes.add(NodeChangeOptions.WENT_UP);
            } else if (hostSpecB.getAvailability() == HostAvailability.NOT_AVAILABLE) {
                changes.add(NodeChangeOptions.WENT_DOWN);
            }
        }
        if (!changes.isEmpty()) {
            changes.add(NodeChangeOptions.NODE_CHANGED);
        }
        return changes;
    }

    @Override
    public List<HostSpec> getAllHosts() {
        return this.allHosts;
    }

    @Override
    public List<HostSpec> getHosts() {
        AllowedAndBlockedHosts hostPermissions = this.servicesContainer.getStorageService().get(AllowedAndBlockedHosts.class, this.initialConnectionHostSpec.getUrl());
        if (hostPermissions == null) {
            return this.allHosts;
        }
        List<HostSpec> hosts = this.allHosts;
        Set<String> allowedHostIds = hostPermissions.getAllowedHostIds();
        Set<String> blockedHostIds = hostPermissions.getBlockedHostIds();
        if (!Utils.isNullOrEmpty(allowedHostIds)) {
            hosts = hosts.stream().filter(hostSpec -> allowedHostIds.contains(hostSpec.getHostId())).collect(Collectors.toList());
        }
        if (!Utils.isNullOrEmpty(blockedHostIds)) {
            hosts = hosts.stream().filter(hostSpec -> !blockedHostIds.contains(hostSpec.getHostId())).collect(Collectors.toList());
        }
        return hosts;
    }

    @Override
    public void setAvailability(@NonNull Set<String> hostAliases, @NonNull HostAvailability availability) {
        if (hostAliases.isEmpty()) {
            return;
        }
        List hostsToChange = this.getAllHosts().stream().filter(host -> {
            if (hostAliases.contains(host.asAlias())) return true;
            if (!host.getAliases().stream().anyMatch(hostAliases::contains)) return false;
            return true;
        }).distinct().collect(Collectors.toList());
        if (hostsToChange.isEmpty()) {
            LOGGER.finest(() -> Messages.get("PluginServiceImpl.hostsChangelistEmpty"));
            return;
        }
        HashMap<String, EnumSet<NodeChangeOptions>> changes = new HashMap<String, EnumSet<NodeChangeOptions>>();
        for (HostSpec host2 : hostsToChange) {
            HostAvailability currentAvailability = host2.getAvailability();
            host2.setAvailability(availability);
            hostAvailabilityExpiringCache.put(host2.getUrl(), availability, DEFAULT_HOST_AVAILABILITY_CACHE_EXPIRE_NANO);
            if (currentAvailability == availability) continue;
            EnumSet<NodeChangeOptions> hostChanges = availability == HostAvailability.AVAILABLE ? EnumSet.of(NodeChangeOptions.WENT_UP, NodeChangeOptions.NODE_CHANGED) : EnumSet.of(NodeChangeOptions.WENT_DOWN, NodeChangeOptions.NODE_CHANGED);
            changes.put(host2.getUrl(), hostChanges);
        }
        if (!changes.isEmpty()) {
            this.pluginManager.notifyNodeListChanged(changes);
        }
    }

    @Override
    public boolean isInTransaction() {
        return this.isInTransaction;
    }

    @Override
    public void setInTransaction(boolean inTransaction) {
        this.isInTransaction = inTransaction;
    }

    @Override
    public HostListProvider getHostListProvider() {
        return this.hostListProvider;
    }

    @Override
    public void refreshHostList() throws SQLException {
        List<HostSpec> updatedHostList = this.getHostListProvider().refresh();
        if (!Objects.equals(updatedHostList, this.allHosts)) {
            this.updateHostAvailability(updatedHostList);
            this.setNodeList(this.allHosts, updatedHostList);
        }
    }

    @Override
    public void refreshHostList(Connection connection) throws SQLException {
        List<HostSpec> updatedHostList = this.getHostListProvider().refresh(connection);
        if (!Objects.equals(updatedHostList, this.allHosts)) {
            this.updateHostAvailability(updatedHostList);
            this.setNodeList(this.allHosts, updatedHostList);
        }
    }

    @Override
    public void forceRefreshHostList() throws SQLException {
        List<HostSpec> updatedHostList = this.getHostListProvider().forceRefresh();
        if (updatedHostList != null) {
            this.updateHostAvailability(updatedHostList);
            this.setNodeList(this.allHosts, updatedHostList);
        }
    }

    @Override
    public void forceRefreshHostList(Connection connection) throws SQLException {
        List<HostSpec> updatedHostList = this.getHostListProvider().forceRefresh(connection);
        if (updatedHostList != null) {
            this.updateHostAvailability(updatedHostList);
            this.setNodeList(this.allHosts, updatedHostList);
        }
    }

    @Override
    public boolean forceRefreshHostList(boolean shouldVerifyWriter, long timeoutMs) throws SQLException {
        HostListProvider hostListProvider = this.getHostListProvider();
        if (!(hostListProvider instanceof BlockingHostListProvider)) {
            throw new UnsupportedOperationException(Messages.get("PluginServiceImpl.requiredBlockingHostListProvider", new Object[]{hostListProvider.getClass().getName()}));
        }
        try {
            List<HostSpec> updatedHostList = ((BlockingHostListProvider)hostListProvider).forceRefresh(shouldVerifyWriter, timeoutMs);
            if (updatedHostList != null) {
                this.updateHostAvailability(updatedHostList);
                this.setNodeList(this.allHosts, updatedHostList);
                return true;
            }
        }
        catch (TimeoutException ex) {
            LOGGER.finest(Messages.get("PluginServiceImpl.forceRefreshTimeout", new Object[]{timeoutMs}));
        }
        return false;
    }

    void setNodeList(@Nullable List<HostSpec> oldHosts, @Nullable List<HostSpec> newHosts) {
        HashMap oldHostMap = oldHosts == null ? new HashMap() : oldHosts.stream().collect(Collectors.toMap(HostSpec::getUrl, value -> value));
        HashMap newHostMap = newHosts == null ? new HashMap() : newHosts.stream().collect(Collectors.toMap(HostSpec::getUrl, value -> value));
        HashMap<String, EnumSet<NodeChangeOptions>> changes = new HashMap<String, EnumSet<NodeChangeOptions>>();
        for (Map.Entry entry : oldHostMap.entrySet()) {
            HostSpec correspondingNewHost = (HostSpec)newHostMap.get(entry.getKey());
            if (correspondingNewHost == null) {
                changes.put((String)entry.getKey(), EnumSet.of(NodeChangeOptions.NODE_DELETED));
                continue;
            }
            EnumSet<NodeChangeOptions> hostChanges = this.compare((HostSpec)entry.getValue(), correspondingNewHost);
            if (hostChanges.isEmpty()) continue;
            changes.put((String)entry.getKey(), hostChanges);
        }
        for (Map.Entry entry : newHostMap.entrySet()) {
            if (oldHostMap.containsKey(entry.getKey())) continue;
            changes.put((String)entry.getKey(), EnumSet.of(NodeChangeOptions.NODE_ADDED));
        }
        if (!changes.isEmpty()) {
            this.allHosts = newHosts != null ? newHosts : new ArrayList();
            this.pluginManager.notifyNodeListChanged(changes);
        }
    }

    @Override
    public boolean isStaticHostListProvider() {
        return this.getHostListProvider() instanceof StaticHostListProvider;
    }

    @Override
    public void setHostListProvider(HostListProvider hostListProvider) {
        this.hostListProvider = hostListProvider;
    }

    @Override
    public Connection connect(HostSpec hostSpec, Properties props) throws SQLException {
        return this.connect(hostSpec, props, null);
    }

    @Override
    public Connection connect(HostSpec hostSpec, Properties props, @Nullable ConnectionPlugin pluginToSkip) throws SQLException {
        return this.pluginManager.connect(this.driverProtocol, hostSpec, props, this.currentConnection == null, pluginToSkip);
    }

    @Override
    public Connection forceConnect(HostSpec hostSpec, Properties props) throws SQLException {
        return this.forceConnect(hostSpec, props, null);
    }

    @Override
    public Connection forceConnect(HostSpec hostSpec, Properties props, @Nullable ConnectionPlugin pluginToSkip) throws SQLException {
        return this.pluginManager.forceConnect(this.driverProtocol, hostSpec, props, this.currentConnection == null, pluginToSkip);
    }

    private void updateHostAvailability(List<HostSpec> hosts) {
        for (HostSpec host : hosts) {
            HostAvailability availability = hostAvailabilityExpiringCache.get(host.getUrl());
            if (availability == null) continue;
            host.setAvailability(availability);
        }
    }

    @Override
    public void releaseResources() {
        LOGGER.finest(() -> Messages.get("PluginServiceImpl.releaseResources"));
        try {
            if (this.currentConnection != null && !this.currentConnection.isClosed()) {
                this.currentConnection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (this.hostListProvider != null && this.hostListProvider instanceof CanReleaseResources) {
            CanReleaseResources canReleaseResourcesObject = (CanReleaseResources)((Object)this.hostListProvider);
            canReleaseResourcesObject.releaseResources();
        }
    }

    @Override
    @Deprecated
    public boolean isNetworkException(Throwable throwable) {
        return this.isNetworkException(throwable, this.targetDriverDialect);
    }

    @Override
    public boolean isNetworkException(Throwable throwable, @Nullable TargetDriverDialect targetDriverDialect) {
        if (this.exceptionHandler != null) {
            return this.exceptionHandler.isNetworkException(throwable, targetDriverDialect);
        }
        return this.exceptionManager.isNetworkException(this.dialect, throwable, targetDriverDialect);
    }

    @Override
    public boolean isNetworkException(String sqlState) {
        if (this.exceptionHandler != null) {
            return this.exceptionHandler.isNetworkException(sqlState);
        }
        return this.exceptionManager.isNetworkException(this.dialect, sqlState);
    }

    @Override
    @Deprecated
    public boolean isLoginException(Throwable throwable) {
        return this.isLoginException(throwable, this.targetDriverDialect);
    }

    @Override
    public boolean isLoginException(Throwable throwable, @Nullable TargetDriverDialect targetDriverDialect) {
        if (this.exceptionHandler != null) {
            return this.exceptionHandler.isLoginException(throwable, targetDriverDialect);
        }
        return this.exceptionManager.isLoginException(this.dialect, throwable, targetDriverDialect);
    }

    @Override
    public boolean isLoginException(String sqlState) {
        if (this.exceptionHandler != null) {
            return this.exceptionHandler.isLoginException(sqlState);
        }
        return this.exceptionManager.isLoginException(this.dialect, sqlState);
    }

    @Override
    public Dialect getDialect() {
        return this.dialect;
    }

    @Override
    public TargetDriverDialect getTargetDriverDialect() {
        return this.targetDriverDialect;
    }

    @Override
    public void updateDialect(@NonNull Connection connection) throws SQLException {
        Dialect originalDialect = this.dialect;
        this.dialect = this.dialectProvider.getDialect(this.originalUrl, this.initialConnectionHostSpec, connection);
        if (originalDialect == this.dialect) {
            return;
        }
        HostListProviderSupplier supplier = this.dialect.getHostListProvider();
        this.setHostListProvider(supplier.getProvider(this.props, this.originalUrl, this.servicesContainer));
        this.refreshHostList(connection);
    }

    @Override
    public HostSpec identifyConnection(Connection connection) throws SQLException {
        return this.getHostListProvider().identifyConnection(connection);
    }

    @Override
    public void fillAliases(Connection connection, HostSpec hostSpec) throws SQLException {
        if (hostSpec == null) {
            return;
        }
        if (!hostSpec.getAliases().isEmpty()) {
            LOGGER.finest(() -> Messages.get("PluginServiceImpl.nonEmptyAliases", new Object[]{hostSpec.getAliases()}));
            return;
        }
        hostSpec.addAlias(hostSpec.asAlias());
        try (Statement stmt = connection.createStatement();
             ResultSet rs = stmt.executeQuery(this.getDialect().getHostAliasQuery());){
            while (rs.next()) {
                hostSpec.addAlias(rs.getString(1));
            }
        }
        catch (SQLException sqlException) {
            LOGGER.finest(() -> Messages.get("PluginServiceImpl.failedToRetrieveHostPort"));
        }
        HostSpec host = this.identifyConnection(connection);
        if (host != null) {
            hostSpec.addAlias(host.asAliases().toArray(new String[0]));
        }
    }

    @Override
    public HostSpecBuilder getHostSpecBuilder() {
        return new HostSpecBuilder(new HostAvailabilityStrategyFactory().create(this.props));
    }

    @Override
    public Properties getProperties() {
        return this.props;
    }

    @Override
    public TelemetryFactory getTelemetryFactory() {
        return this.pluginManager.getTelemetryFactory();
    }

    @Override
    public String getTargetName() {
        return this.pluginManager.getDefaultConnProvider().getTargetName();
    }

    @Override
    public @NonNull SessionStateService getSessionStateService() {
        return this.sessionStateService;
    }

    @Override
    public <T> T getPlugin(Class<T> pluginClazz) {
        for (ConnectionPlugin p : this.pluginManager.plugins) {
            if (!pluginClazz.isAssignableFrom(p.getClass())) continue;
            return pluginClazz.cast(p);
        }
        return null;
    }

    public static void clearCache() {
        hostAvailabilityExpiringCache.clear();
    }

    @Override
    @Deprecated
    public <T> void setStatus(Class<T> clazz, @Nullable T status, boolean clusterBound) {
        String clusterId = null;
        if (clusterBound) {
            try {
                clusterId = this.hostListProvider.getClusterId();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setStatus(clazz, status, clusterId);
    }

    @Override
    @Deprecated
    public <T> void setStatus(Class<T> clazz, @Nullable T status, String key) {
        String cacheKey = this.getStatusCacheKey(clazz, key);
        if (status == null) {
            statusesExpiringCache.remove(cacheKey);
        } else {
            statusesExpiringCache.put(cacheKey, status, DEFAULT_STATUS_CACHE_EXPIRE_NANO);
        }
    }

    @Override
    @Deprecated
    public <T> T getStatus(@NonNull Class<T> clazz, boolean clusterBound) {
        String clusterId = null;
        if (clusterBound) {
            try {
                clusterId = this.hostListProvider.getClusterId();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.getStatus(clazz, clusterId);
    }

    @Override
    @Deprecated
    public <T> T getStatus(@NonNull Class<T> clazz, String key) {
        return clazz.cast(statusesExpiringCache.get(this.getStatusCacheKey(clazz, key)));
    }

    protected <T> String getStatusCacheKey(Class<T> clazz, String key) {
        return String.format("%s::%s", key == null ? "" : key.trim().toLowerCase(), clazz.getName());
    }

    @Override
    public boolean isPluginInUse(Class<? extends ConnectionPlugin> pluginClazz) {
        try {
            return this.pluginManager.isWrapperFor(pluginClazz);
        }
        catch (SQLException e) {
            return false;
        }
    }
}

