/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.util.storage;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.util.storage.CacheItem;

public class CacheMap<K, V> {
    protected final Map<K, CacheItem<V>> cache = new ConcurrentHashMap<K, CacheItem<V>>();
    protected final long cleanupIntervalNanos = TimeUnit.MINUTES.toNanos(10L);
    protected final AtomicLong cleanupTimeNanos = new AtomicLong(System.nanoTime() + this.cleanupIntervalNanos);

    public @Nullable V get(K key) {
        CacheItem cacheItem = this.cache.computeIfPresent(key, (kk, vv) -> vv.isExpired() ? null : vv);
        return cacheItem == null ? null : (V)cacheItem.item;
    }

    public V get(K key, V defaultItemValue, long itemExpirationNano) {
        CacheItem cacheItem = this.cache.compute(key, (kk, vv) -> vv == null || vv.isExpired() ? new CacheItem<Object>(defaultItemValue, System.nanoTime() + itemExpirationNano) : vv);
        return cacheItem.item;
    }

    public void put(K key, V item, long itemExpirationNano) {
        this.cache.put(key, new CacheItem<V>(item, System.nanoTime() + itemExpirationNano));
        this.cleanUp();
    }

    public void putIfAbsent(K key, V item, long itemExpirationNano) {
        this.cache.putIfAbsent(key, new CacheItem<V>(item, System.nanoTime() + itemExpirationNano));
        this.cleanUp();
    }

    public void remove(K key) {
        this.cache.remove(key);
        this.cleanUp();
    }

    public void clear() {
        this.cache.clear();
    }

    public Map<K, V> getEntries() {
        HashMap entries = new HashMap();
        for (Map.Entry<K, CacheItem<V>> entry : this.cache.entrySet()) {
            entries.put(entry.getKey(), entry.getValue().item);
        }
        return entries;
    }

    public int size() {
        return this.cache.size();
    }

    protected void cleanUp() {
        if (this.cleanupTimeNanos.get() < System.nanoTime()) {
            this.cleanupTimeNanos.set(System.nanoTime() + this.cleanupIntervalNanos);
            this.cache.forEach((key, value) -> {
                if (value == null || value.isExpired()) {
                    this.cache.remove(key);
                    if (value != null && value.item instanceof AutoCloseable) {
                        try {
                            ((AutoCloseable)value.item).close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
        }
    }
}

