/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.util.monitoring;

import java.sql.Driver;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.DriverConnectionProvider;
import software.amazon.jdbc.TargetDriverHelper;
import software.amazon.jdbc.dialect.Dialect;
import software.amazon.jdbc.hostlistprovider.Topology;
import software.amazon.jdbc.hostlistprovider.monitoring.ClusterTopologyMonitorImpl;
import software.amazon.jdbc.hostlistprovider.monitoring.MultiAzClusterTopologyMonitorImpl;
import software.amazon.jdbc.targetdriverdialect.TargetDriverDialect;
import software.amazon.jdbc.util.ExecutorFactory;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.PropertyUtils;
import software.amazon.jdbc.util.connection.ConnectionServiceImpl;
import software.amazon.jdbc.util.events.DataAccessEvent;
import software.amazon.jdbc.util.events.Event;
import software.amazon.jdbc.util.events.EventPublisher;
import software.amazon.jdbc.util.events.EventSubscriber;
import software.amazon.jdbc.util.monitoring.Monitor;
import software.amazon.jdbc.util.monitoring.MonitorErrorResponse;
import software.amazon.jdbc.util.monitoring.MonitorInitializer;
import software.amazon.jdbc.util.monitoring.MonitorService;
import software.amazon.jdbc.util.monitoring.MonitorSettings;
import software.amazon.jdbc.util.monitoring.MonitorState;
import software.amazon.jdbc.util.storage.ExternallyManagedCache;
import software.amazon.jdbc.util.storage.StorageService;
import software.amazon.jdbc.util.telemetry.TelemetryFactory;

public class MonitorServiceImpl
implements MonitorService,
EventSubscriber {
    private static final Logger LOGGER = Logger.getLogger(MonitorServiceImpl.class.getName());
    protected static final long DEFAULT_CLEANUP_INTERVAL_NANOS = TimeUnit.MINUTES.toNanos(1L);
    protected static final Map<Class<? extends Monitor>, Supplier<CacheContainer>> defaultSuppliers;
    protected final EventPublisher publisher;
    protected final Map<Class<? extends Monitor>, CacheContainer> monitorCaches = new ConcurrentHashMap<Class<? extends Monitor>, CacheContainer>();
    protected final ScheduledExecutorService cleanupExecutor = ExecutorFactory.newSingleThreadScheduledThreadExecutor("msi");

    public MonitorServiceImpl(EventPublisher publisher) {
        this(DEFAULT_CLEANUP_INTERVAL_NANOS, publisher);
    }

    public MonitorServiceImpl(long cleanupIntervalNanos, EventPublisher publisher) {
        this.publisher = publisher;
        this.publisher.subscribe(this, new HashSet<Class<? extends Event>>(Collections.singletonList(DataAccessEvent.class)));
        this.initCleanupThread(cleanupIntervalNanos);
    }

    protected void initCleanupThread(long cleanupIntervalNanos) {
        this.cleanupExecutor.scheduleAtFixedRate(this::checkMonitors, cleanupIntervalNanos, cleanupIntervalNanos, TimeUnit.NANOSECONDS);
    }

    protected void checkMonitors() {
        LOGGER.finest(Messages.get("MonitorServiceImpl.checkingMonitors"));
        for (CacheContainer container : this.monitorCaches.values()) {
            ExternallyManagedCache<Object, MonitorItem> cache = container.getCache();
            for (Map.Entry<Object, MonitorItem> entry : cache.getEntries().entrySet()) {
                Object key = entry.getKey();
                MonitorItem removedItem = cache.removeIf(key, mi -> mi.getMonitor().getState() == MonitorState.STOPPED);
                if (removedItem != null) {
                    removedItem.getMonitor().stop();
                    continue;
                }
                MonitorSettings monitorSettings = container.getSettings();
                removedItem = cache.removeIf(key, mi -> mi.getMonitor().getState() == MonitorState.ERROR);
                if (removedItem != null) {
                    LOGGER.finest(Messages.get("MonitorServiceImpl.removedErrorMonitor", new Object[]{removedItem.getMonitor()}));
                    this.handleMonitorError(container, key, removedItem);
                    continue;
                }
                long inactiveTimeoutNanos = monitorSettings.getInactiveTimeoutNanos();
                removedItem = cache.removeIf(key, mi -> System.nanoTime() - mi.getMonitor().getLastActivityTimestampNanos() > inactiveTimeoutNanos);
                if (removedItem != null) {
                    LOGGER.fine(Messages.get("MonitorServiceImpl.monitorStuck", new Object[]{removedItem.getMonitor(), TimeUnit.NANOSECONDS.toMillis(inactiveTimeoutNanos)}));
                    this.handleMonitorError(container, key, removedItem);
                    continue;
                }
                removedItem = cache.removeExpiredIf(key, mi -> mi.getMonitor().canDispose());
                if (removedItem == null) continue;
                LOGGER.fine(Messages.get("MonitorServiceImpl.removedExpiredMonitor", new Object[]{removedItem.getMonitor()}));
                removedItem.getMonitor().stop();
            }
        }
    }

    protected void handleMonitorError(CacheContainer cacheContainer, Object key, MonitorItem errorMonitorItem) {
        Monitor monitor = errorMonitorItem.getMonitor();
        monitor.stop();
        Set<MonitorErrorResponse> errorResponses = cacheContainer.getSettings().getErrorResponses();
        if (errorResponses != null && errorResponses.contains((Object)MonitorErrorResponse.RECREATE)) {
            cacheContainer.getCache().computeIfAbsent(key, k -> {
                LOGGER.fine(Messages.get("MonitorServiceImpl.recreatingMonitor", new Object[]{monitor}));
                MonitorItem newMonitorItem = new MonitorItem(errorMonitorItem.getMonitorSupplier());
                newMonitorItem.getMonitor().start();
                return newMonitorItem;
            });
        }
    }

    @Override
    public <T extends Monitor> void registerMonitorTypeIfAbsent(Class<T> monitorClass, long expirationTimeoutNanos, long heartbeatTimeoutNanos, Set<MonitorErrorResponse> errorResponses, @Nullable Class<?> producedDataClass) {
        this.monitorCaches.computeIfAbsent(monitorClass, mc -> new CacheContainer(new MonitorSettings(expirationTimeoutNanos, heartbeatTimeoutNanos, errorResponses), producedDataClass));
    }

    @Override
    public <T extends Monitor> T runIfAbsent(Class<T> monitorClass, Object key, StorageService storageService, TelemetryFactory telemetryFactory, String originalUrl, String driverProtocol, TargetDriverDialect driverDialect, Dialect dbDialect, Properties originalProps, MonitorInitializer initializer) throws SQLException {
        CacheContainer cacheContainer = this.monitorCaches.get(monitorClass);
        if (cacheContainer == null) {
            Supplier<CacheContainer> supplier = defaultSuppliers.get(monitorClass);
            if (supplier == null) {
                throw new IllegalStateException(Messages.get("MonitorServiceImpl.monitorTypeNotRegistered", new Object[]{monitorClass}));
            }
            cacheContainer = this.monitorCaches.computeIfAbsent(monitorClass, k -> (CacheContainer)supplier.get());
        }
        TargetDriverHelper helper = new TargetDriverHelper();
        Driver driver = helper.getTargetDriver(originalUrl, originalProps);
        DriverConnectionProvider defaultConnectionProvider = new DriverConnectionProvider(driver);
        Properties propsCopy = PropertyUtils.copyProperties(originalProps);
        ConnectionServiceImpl connectionService = new ConnectionServiceImpl(storageService, this, telemetryFactory, defaultConnectionProvider, originalUrl, driverProtocol, driverDialect, dbDialect, propsCopy);
        Monitor monitor = cacheContainer.getCache().computeIfAbsent(key, k -> {
            MonitorItem monitorItem = new MonitorItem(() -> initializer.createMonitor(connectionService, connectionService.getPluginService()));
            monitorItem.getMonitor().start();
            return monitorItem;
        }).getMonitor();
        if (monitorClass.isInstance(monitor)) {
            return (T)((Monitor)monitorClass.cast(monitor));
        }
        throw new IllegalStateException(Messages.get("MonitorServiceImpl.unexpectedMonitorClass", new Object[]{monitorClass, monitor}));
    }

    @Override
    public <T extends Monitor> @Nullable T get(Class<T> monitorClass, Object key) {
        CacheContainer cacheContainer = this.monitorCaches.get(monitorClass);
        if (cacheContainer == null) {
            return null;
        }
        MonitorItem item = cacheContainer.getCache().get(key);
        if (item == null) {
            return null;
        }
        Monitor monitor = item.getMonitor();
        if (monitorClass.isInstance(monitor)) {
            return (T)((Monitor)monitorClass.cast(monitor));
        }
        LOGGER.fine(Messages.get("MonitorServiceImpl.monitorClassMismatch", new Object[]{key, monitorClass, monitor, monitor.getClass()}));
        return null;
    }

    @Override
    public <T extends Monitor> T remove(Class<T> monitorClass, Object key) {
        CacheContainer cacheContainer = this.monitorCaches.get(monitorClass);
        if (cacheContainer == null) {
            return null;
        }
        MonitorItem item = cacheContainer.getCache().removeIf(key, monitorItem -> monitorClass.isInstance(monitorItem.getMonitor()));
        if (item == null) {
            return null;
        }
        return (T)((Monitor)monitorClass.cast(item.getMonitor()));
    }

    @Override
    public <T extends Monitor> void stopAndRemove(Class<T> monitorClass, Object key) {
        CacheContainer cacheContainer = this.monitorCaches.get(monitorClass);
        if (cacheContainer == null) {
            LOGGER.fine(Messages.get("MonitorServiceImpl.stopAndRemoveMissingMonitorType", new Object[]{monitorClass, key}));
            return;
        }
        MonitorItem monitorItem = cacheContainer.getCache().remove(key);
        if (monitorItem != null) {
            monitorItem.getMonitor().stop();
        }
    }

    @Override
    public <T extends Monitor> void stopAndRemoveMonitors(Class<T> monitorClass) {
        CacheContainer cacheContainer = this.monitorCaches.get(monitorClass);
        if (cacheContainer == null) {
            LOGGER.fine(Messages.get("MonitorServiceImpl.stopAndRemoveMonitorsMissingType", new Object[]{monitorClass}));
            return;
        }
        ExternallyManagedCache<Object, MonitorItem> cache = cacheContainer.getCache();
        for (Map.Entry<Object, MonitorItem> entry : cache.getEntries().entrySet()) {
            MonitorItem monitorItem = cache.remove(entry.getKey());
            if (monitorItem == null) continue;
            monitorItem.getMonitor().stop();
        }
    }

    @Override
    public void stopAndRemoveAll() {
        for (Class<? extends Monitor> monitorClass : this.monitorCaches.keySet()) {
            this.stopAndRemoveMonitors(monitorClass);
        }
    }

    @Override
    public void releaseResources() {
        this.cleanupExecutor.shutdownNow();
        this.stopAndRemoveAll();
    }

    @Override
    public void processEvent(Event event) {
        if (!(event instanceof DataAccessEvent)) {
            return;
        }
        DataAccessEvent accessEvent = (DataAccessEvent)event;
        for (CacheContainer container : this.monitorCaches.values()) {
            if (container.getProducedDataClass() == null || !accessEvent.getDataClass().equals(container.getProducedDataClass())) continue;
            container.getCache().extendExpiration(accessEvent.getKey());
        }
    }

    static {
        HashMap<Class, Supplier<CacheContainer>> suppliers = new HashMap<Class, Supplier<CacheContainer>>();
        HashSet<MonitorErrorResponse> recreateOnError = new HashSet<MonitorErrorResponse>(Collections.singletonList(MonitorErrorResponse.RECREATE));
        MonitorSettings defaultSettings = new MonitorSettings(TimeUnit.MINUTES.toNanos(15L), TimeUnit.MINUTES.toNanos(3L), recreateOnError);
        suppliers.put(ClusterTopologyMonitorImpl.class, () -> new CacheContainer(defaultSettings, Topology.class));
        suppliers.put(MultiAzClusterTopologyMonitorImpl.class, () -> new CacheContainer(defaultSettings, Topology.class));
        defaultSuppliers = Collections.unmodifiableMap(suppliers);
    }

    protected static class MonitorItem {
        private final @NonNull Supplier<? extends Monitor> monitorSupplier;
        private final @NonNull Monitor monitor;

        protected MonitorItem(@NonNull Supplier<? extends Monitor> monitorSupplier) {
            this.monitorSupplier = monitorSupplier;
            this.monitor = monitorSupplier.get();
        }

        public @NonNull Supplier<? extends Monitor> getMonitorSupplier() {
            return this.monitorSupplier;
        }

        public @NonNull Monitor getMonitor() {
            return this.monitor;
        }
    }

    protected static class CacheContainer {
        private final @NonNull MonitorSettings settings;
        private final @NonNull ExternallyManagedCache<Object, MonitorItem> cache;
        private final @Nullable Class<?> producedDataClass;

        public CacheContainer(@NonNull MonitorSettings settings, @Nullable Class<?> producedDataClass) {
            this.settings = settings;
            this.cache = new ExternallyManagedCache(settings.getExpirationTimeoutNanos());
            this.producedDataClass = producedDataClass;
        }

        public @NonNull MonitorSettings getSettings() {
            return this.settings;
        }

        public @NonNull ExternallyManagedCache<Object, MonitorItem> getCache() {
            return this.cache;
        }

        public @Nullable Class<?> getProducedDataClass() {
            return this.producedDataClass;
        }
    }
}

