/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.strategy.fastestresponse;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.plugin.strategy.fastestresponse.HostResponseTimeService;
import software.amazon.jdbc.plugin.strategy.fastestresponse.NodeResponseTimeMonitor;
import software.amazon.jdbc.util.storage.SlidingExpirationCacheWithCleanupThread;
import software.amazon.jdbc.util.telemetry.TelemetryFactory;
import software.amazon.jdbc.util.telemetry.TelemetryGauge;

public class HostResponseTimeServiceImpl
implements HostResponseTimeService {
    private static final Logger LOGGER = Logger.getLogger(HostResponseTimeServiceImpl.class.getName());
    protected static final long CACHE_EXPIRATION_NANO = TimeUnit.MINUTES.toNanos(10L);
    protected static final long CACHE_CLEANUP_NANO = TimeUnit.MINUTES.toNanos(1L);
    protected static final SlidingExpirationCacheWithCleanupThread<String, NodeResponseTimeMonitor> monitoringNodes = new SlidingExpirationCacheWithCleanupThread(monitor -> true, monitor -> {
        try {
            monitor.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }, CACHE_CLEANUP_NANO);
    protected static final ReentrantLock cacheLock = new ReentrantLock();
    protected int intervalMs;
    protected List<HostSpec> hosts = new ArrayList<HostSpec>();
    protected final @NonNull PluginService pluginService;
    protected final @NonNull Properties props;
    protected final TelemetryFactory telemetryFactory;
    private final TelemetryGauge nodeCountGauge;

    public HostResponseTimeServiceImpl(@NonNull PluginService pluginService, @NonNull Properties props, int intervalMs) {
        this.pluginService = pluginService;
        this.props = props;
        this.intervalMs = intervalMs;
        this.telemetryFactory = this.pluginService.getTelemetryFactory();
        this.nodeCountGauge = this.telemetryFactory.createGauge("frt.nodes.count", () -> monitoringNodes.size());
        monitoringNodes.setCleanupIntervalNanos(CACHE_CLEANUP_NANO);
    }

    @Override
    public int getResponseTime(HostSpec hostSpec) {
        NodeResponseTimeMonitor monitor = (NodeResponseTimeMonitor)monitoringNodes.get(hostSpec.getUrl(), CACHE_EXPIRATION_NANO);
        if (monitor == null) {
            return Integer.MAX_VALUE;
        }
        return monitor.getResponseTime();
    }

    @Override
    public void setHosts(@NonNull List<HostSpec> hosts) {
        Set oldHosts = this.hosts.stream().map(HostSpec::getUrl).collect(Collectors.toSet());
        this.hosts = hosts;
        this.hosts.stream().filter(hostSpec -> !oldHosts.contains(hostSpec.getUrl())).forEach(hostSpec -> {
            cacheLock.lock();
            try {
                monitoringNodes.computeIfAbsent(hostSpec.getUrl(), key -> new NodeResponseTimeMonitor(this.pluginService, (HostSpec)hostSpec, this.props, this.intervalMs), CACHE_EXPIRATION_NANO);
            }
            finally {
                cacheLock.unlock();
            }
        });
    }

    public static void closeAllMonitors() {
        monitoringNodes.getEntries().values().forEach(monitor -> {
            try {
                monitor.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        monitoringNodes.clear();
    }
}

