/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.bluegreen;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.AwsWrapperProperty;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.HostSpecBuilder;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.dialect.BlueGreenDialect;
import software.amazon.jdbc.dialect.Dialect;
import software.amazon.jdbc.hostavailability.SimpleHostAvailabilityStrategy;
import software.amazon.jdbc.plugin.bluegreen.BlueGreenInterimStatus;
import software.amazon.jdbc.plugin.bluegreen.BlueGreenIntervalRate;
import software.amazon.jdbc.plugin.bluegreen.BlueGreenPhase;
import software.amazon.jdbc.plugin.bluegreen.BlueGreenRole;
import software.amazon.jdbc.plugin.bluegreen.BlueGreenStatus;
import software.amazon.jdbc.plugin.bluegreen.BlueGreenStatusMonitor;
import software.amazon.jdbc.plugin.bluegreen.routing.ConnectRouting;
import software.amazon.jdbc.plugin.bluegreen.routing.ExecuteRouting;
import software.amazon.jdbc.plugin.bluegreen.routing.RejectConnectRouting;
import software.amazon.jdbc.plugin.bluegreen.routing.SubstituteConnectRouting;
import software.amazon.jdbc.plugin.bluegreen.routing.SuspendConnectRouting;
import software.amazon.jdbc.plugin.bluegreen.routing.SuspendExecuteRouting;
import software.amazon.jdbc.plugin.bluegreen.routing.SuspendUntilCorrespondingNodeFoundConnectRouting;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.Pair;
import software.amazon.jdbc.util.PropertyUtils;
import software.amazon.jdbc.util.RdsUtils;
import software.amazon.jdbc.util.StringUtils;
import software.amazon.jdbc.util.Utils;

public class BlueGreenStatusProvider {
    private static final Logger LOGGER = Logger.getLogger(BlueGreenStatusProvider.class.getName());
    public static final AwsWrapperProperty BG_INTERVAL_BASELINE_MS = new AwsWrapperProperty("bgBaselineMs", "60000", "Baseline Blue/Green Deployment status checking interval (in msec).");
    public static final AwsWrapperProperty BG_INTERVAL_INCREASED_MS = new AwsWrapperProperty("bgIncreasedMs", "1000", "Increased Blue/Green Deployment status checking interval (in msec).");
    public static final AwsWrapperProperty BG_INTERVAL_HIGH_MS = new AwsWrapperProperty("bgHighMs", "100", "High Blue/Green Deployment status checking interval (in msec).");
    private static final String MONITORING_PROPERTY_PREFIX = "blue-green-monitoring-";
    private static final String DEFAULT_CONNECT_TIMEOUT_MS = String.valueOf(TimeUnit.SECONDS.toMillis(10L));
    private static final String DEFAULT_SOCKET_TIMEOUT_MS = String.valueOf(TimeUnit.SECONDS.toMillis(10L));
    public static final AwsWrapperProperty BG_SWITCHOVER_TIMEOUT_MS = new AwsWrapperProperty("bgSwitchoverTimeoutMs", "180000", "Blue/Green Deployment switchover timeout (in msec).");
    public static final AwsWrapperProperty BG_SUSPEND_NEW_BLUE_CONNECTIONS = new AwsWrapperProperty("bgSuspendNewBlueConnections", "false", "Enables Blue/Green Deployment switchover to suspend new blue connection requests while the switchover process is in progress.");
    protected final HostSpecBuilder hostSpecBuilder = new HostSpecBuilder(new SimpleHostAvailabilityStrategy());
    protected final BlueGreenStatusMonitor[] monitors = new BlueGreenStatusMonitor[]{null, null};
    protected int[] interimStatusHashes = new int[]{0, 0};
    protected int lastContextHash = 0;
    protected BlueGreenInterimStatus[] interimStatuses = new BlueGreenInterimStatus[]{null, null};
    protected final Map<String, Optional<String>> hostIpAddresses = new ConcurrentHashMap<String, Optional<String>>();
    protected final Map<String, Pair<HostSpec, HostSpec>> correspondingNodes = new ConcurrentHashMap<String, Pair<HostSpec, HostSpec>>();
    protected final Map<String, BlueGreenRole> roleByHost = new ConcurrentHashMap<String, BlueGreenRole>();
    protected final Map<String, Set<String>> iamHostSuccessfulConnects = new ConcurrentHashMap<String, Set<String>>();
    protected final Map<String, Instant> greenNodeChangeNameTimes = new ConcurrentHashMap<String, Instant>();
    protected BlueGreenStatus summaryStatus = null;
    protected BlueGreenPhase latestStatusPhase = BlueGreenPhase.NOT_CREATED;
    protected boolean rollback = false;
    protected boolean blueDnsUpdateCompleted = false;
    protected boolean greenDnsRemoved = false;
    protected boolean greenTopologyChanged = false;
    protected final AtomicBoolean allGreenNodesChangedName = new AtomicBoolean(false);
    protected long postStatusEndTimeNano = 0L;
    protected final ReentrantLock processStatusLock = new ReentrantLock();
    protected final Map<BlueGreenIntervalRate, Long> statusCheckIntervalMap = new HashMap<BlueGreenIntervalRate, Long>();
    protected final long switchoverTimeoutNano;
    protected final boolean suspendNewBlueConnectionsWhenInProgress;
    protected final PluginService pluginService;
    protected final Properties props;
    protected final String bgdId;
    protected Map<String, PhaseTimeInfo> phaseTimeNano = new ConcurrentHashMap<String, PhaseTimeInfo>();
    protected final RdsUtils rdsUtils = new RdsUtils();

    public BlueGreenStatusProvider(@NonNull PluginService pluginService, @NonNull Properties props, @NonNull String bgdId) {
        this.pluginService = pluginService;
        this.props = props;
        this.bgdId = bgdId;
        this.statusCheckIntervalMap.put(BlueGreenIntervalRate.BASELINE, BG_INTERVAL_BASELINE_MS.getLong(props));
        this.statusCheckIntervalMap.put(BlueGreenIntervalRate.INCREASED, BG_INTERVAL_INCREASED_MS.getLong(props));
        this.statusCheckIntervalMap.put(BlueGreenIntervalRate.HIGH, BG_INTERVAL_HIGH_MS.getLong(props));
        this.switchoverTimeoutNano = TimeUnit.MILLISECONDS.toNanos(BG_SWITCHOVER_TIMEOUT_MS.getLong(props));
        this.suspendNewBlueConnectionsWhenInProgress = BG_SUSPEND_NEW_BLUE_CONNECTIONS.getBoolean(props);
        Dialect dialect = this.pluginService.getDialect();
        if (dialect instanceof BlueGreenDialect) {
            this.initMonitoring();
        } else {
            LOGGER.warning(() -> Messages.get("bgd.unsupportedDialect", new Object[]{this.bgdId, dialect.getClass().getSimpleName()}));
        }
    }

    protected void initMonitoring() {
        this.monitors[BlueGreenRole.SOURCE.getValue()] = new BlueGreenStatusMonitor(BlueGreenRole.SOURCE, this.bgdId, this.pluginService.getCurrentHostSpec(), this.pluginService, this.getMonitoringProperties(), this.statusCheckIntervalMap, this::prepareStatus);
        this.monitors[BlueGreenRole.TARGET.getValue()] = new BlueGreenStatusMonitor(BlueGreenRole.TARGET, this.bgdId, this.pluginService.getCurrentHostSpec(), this.pluginService, this.getMonitoringProperties(), this.statusCheckIntervalMap, this::prepareStatus);
    }

    protected Properties getMonitoringProperties() {
        Properties monitoringConnProperties = PropertyUtils.copyProperties(this.props);
        this.props.stringPropertyNames().stream().filter(p -> p.startsWith(MONITORING_PROPERTY_PREFIX)).forEach(p -> {
            monitoringConnProperties.put(p.substring(MONITORING_PROPERTY_PREFIX.length()), this.props.getProperty((String)p));
            monitoringConnProperties.remove(p);
        });
        monitoringConnProperties.putIfAbsent(PropertyDefinition.CONNECT_TIMEOUT.name, DEFAULT_CONNECT_TIMEOUT_MS);
        monitoringConnProperties.putIfAbsent(PropertyDefinition.SOCKET_TIMEOUT.name, DEFAULT_SOCKET_TIMEOUT_MS);
        return monitoringConnProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareStatus(BlueGreenRole role, BlueGreenInterimStatus interimStatus) {
        this.processStatusLock.lock();
        try {
            int statusHash = interimStatus == null ? 0 : interimStatus.getCustomHashCode();
            int contextHash = this.getContextHash();
            if (this.interimStatusHashes[role.getValue()] == statusHash && this.lastContextHash == contextHash) {
                return;
            }
            LOGGER.finest(() -> Messages.get("bgd.interimStatus", new Object[]{this.bgdId, role, interimStatus}));
            this.updatePhase(role, interimStatus);
            this.interimStatuses[role.getValue()] = interimStatus;
            this.interimStatusHashes[role.getValue()] = statusHash;
            this.lastContextHash = contextHash;
            this.hostIpAddresses.putAll(interimStatus.startIpAddressesByHostMap);
            interimStatus.hostNames.forEach(x -> this.roleByHost.put(x.toLowerCase(), role));
            this.updateCorrespondingNodes();
            this.updateSummaryStatus(role, interimStatus);
            this.updateMonitors();
            this.updateStatusCache();
            this.logCurrentContext();
            this.logSwitchoverFinalSummary();
            this.resetContextWhenCompleted();
        }
        finally {
            this.processStatusLock.unlock();
        }
    }

    protected void updatePhase(BlueGreenRole role, BlueGreenInterimStatus interimStatus) {
        BlueGreenPhase latestInterimPhase;
        BlueGreenPhase blueGreenPhase = latestInterimPhase = this.interimStatuses[role.getValue()] == null ? BlueGreenPhase.NOT_CREATED : this.interimStatuses[role.getValue()].blueGreenPhase;
        if (latestInterimPhase != null && interimStatus.blueGreenPhase != null && interimStatus.blueGreenPhase.getValue() < latestInterimPhase.getValue()) {
            this.rollback = true;
            LOGGER.finest(() -> Messages.get("bgd.rollback", new Object[]{this.bgdId}));
        }
        if (interimStatus.blueGreenPhase == null) {
            return;
        }
        if (!this.rollback) {
            if (interimStatus.blueGreenPhase.getValue() >= this.latestStatusPhase.getValue()) {
                this.latestStatusPhase = interimStatus.blueGreenPhase;
            }
        } else if (interimStatus.blueGreenPhase.getValue() < this.latestStatusPhase.getValue()) {
            this.latestStatusPhase = interimStatus.blueGreenPhase;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateStatusCache() {
        BlueGreenStatus latestStatus = this.pluginService.getStatus(BlueGreenStatus.class, this.bgdId);
        this.pluginService.setStatus(BlueGreenStatus.class, this.summaryStatus, this.bgdId);
        this.storePhaseTime(this.summaryStatus.getCurrentPhase());
        if (latestStatus != null) {
            BlueGreenStatus blueGreenStatus = latestStatus;
            synchronized (blueGreenStatus) {
                latestStatus.notifyAll();
            }
        }
    }

    protected void updateCorrespondingNodes() {
        this.correspondingNodes.clear();
        if (this.interimStatuses[BlueGreenRole.SOURCE.getValue()] != null && !Utils.isNullOrEmpty(this.interimStatuses[BlueGreenRole.SOURCE.getValue()].startTopology) && this.interimStatuses[BlueGreenRole.TARGET.getValue()] != null && !Utils.isNullOrEmpty(this.interimStatuses[BlueGreenRole.TARGET.getValue()].startTopology)) {
            HostSpec blueWriterHostSpec = this.getWriterHost(BlueGreenRole.SOURCE);
            HostSpec greenWriterHostSpec = this.getWriterHost(BlueGreenRole.TARGET);
            List<HostSpec> sortedBlueReaderHostSpecs = this.getReaderHosts(BlueGreenRole.SOURCE);
            List<HostSpec> sortedGreenReaderHostSpecs = this.getReaderHosts(BlueGreenRole.TARGET);
            if (blueWriterHostSpec != null) {
                this.correspondingNodes.put(blueWriterHostSpec.getHost(), Pair.create(blueWriterHostSpec, greenWriterHostSpec));
            }
            if (!sortedGreenReaderHostSpecs.isEmpty()) {
                int greenIndex = 0;
                for (HostSpec blueHostSpec : sortedBlueReaderHostSpecs) {
                    this.correspondingNodes.put(blueHostSpec.getHost(), Pair.create(blueHostSpec, sortedGreenReaderHostSpecs.get(greenIndex++)));
                    greenIndex %= sortedGreenReaderHostSpecs.size();
                }
            } else {
                for (HostSpec blueHostSpec : sortedBlueReaderHostSpecs) {
                    this.correspondingNodes.put(blueHostSpec.getHost(), Pair.create(blueHostSpec, greenWriterHostSpec));
                }
            }
        }
        if (this.interimStatuses[BlueGreenRole.SOURCE.getValue()] != null && !Utils.isNullOrEmpty(this.interimStatuses[BlueGreenRole.SOURCE.getValue()].hostNames) && this.interimStatuses[BlueGreenRole.TARGET.getValue()] != null && !Utils.isNullOrEmpty(this.interimStatuses[BlueGreenRole.TARGET.getValue()].hostNames)) {
            Set<String> blueHosts = this.interimStatuses[BlueGreenRole.SOURCE.getValue()].hostNames;
            Set<String> greenHosts = this.interimStatuses[BlueGreenRole.TARGET.getValue()].hostNames;
            String blueClusterHost = blueHosts.stream().filter(this.rdsUtils::isWriterClusterDns).findFirst().orElse(null);
            String greenClusterHost = greenHosts.stream().filter(this.rdsUtils::isWriterClusterDns).findFirst().orElse(null);
            if (!StringUtils.isNullOrEmpty(blueClusterHost) && !StringUtils.isNullOrEmpty(greenClusterHost)) {
                this.correspondingNodes.putIfAbsent(blueClusterHost, Pair.create(this.hostSpecBuilder.host(blueClusterHost).build(), this.hostSpecBuilder.host(greenClusterHost).build()));
            }
            String blueClusterReaderHost = blueHosts.stream().filter(this.rdsUtils::isReaderClusterDns).findFirst().orElse(null);
            String greenClusterReaderHost = greenHosts.stream().filter(this.rdsUtils::isReaderClusterDns).findFirst().orElse(null);
            if (!StringUtils.isNullOrEmpty(blueClusterReaderHost) && !StringUtils.isNullOrEmpty(greenClusterReaderHost)) {
                this.correspondingNodes.putIfAbsent(blueClusterReaderHost, Pair.create(this.hostSpecBuilder.host(blueClusterReaderHost).build(), this.hostSpecBuilder.host(greenClusterReaderHost).build()));
            }
            blueHosts.stream().filter(this.rdsUtils::isRdsCustomClusterDns).forEach(blueHost -> {
                String customClusterName = this.rdsUtils.getRdsClusterId((String)blueHost);
                if (customClusterName != null) {
                    greenHosts.stream().filter(x -> this.rdsUtils.isRdsCustomClusterDns((String)x) && customClusterName.equals(this.rdsUtils.removeGreenInstancePrefix(this.rdsUtils.getRdsClusterId((String)x)))).findFirst().ifPresent(y -> this.correspondingNodes.putIfAbsent((String)blueHost, Pair.create(this.hostSpecBuilder.host((String)y).build(), this.hostSpecBuilder.host((String)y).build())));
                }
            });
        }
    }

    protected HostSpec getWriterHost(BlueGreenRole role) {
        return this.interimStatuses[role.getValue()].startTopology.stream().filter(x -> x.getRole() == HostRole.WRITER).findFirst().orElse(null);
    }

    protected List<HostSpec> getReaderHosts(BlueGreenRole role) {
        return this.interimStatuses[role.getValue()].startTopology.stream().filter(x -> x.getRole() != HostRole.WRITER).sorted(Comparator.comparing(HostSpec::getHost)).collect(Collectors.toList());
    }

    protected void updateSummaryStatus(BlueGreenRole role, BlueGreenInterimStatus interimStatus) {
        switch (this.latestStatusPhase) {
            case NOT_CREATED: {
                this.summaryStatus = new BlueGreenStatus(this.bgdId, BlueGreenPhase.NOT_CREATED);
                break;
            }
            case CREATED: {
                this.updateDnsFlags(role, interimStatus);
                this.summaryStatus = this.getStatusOfCreated();
                break;
            }
            case PREPARATION: {
                this.startSwitchoverTimer();
                this.updateDnsFlags(role, interimStatus);
                this.summaryStatus = this.getStatusOfPreparation();
                break;
            }
            case IN_PROGRESS: {
                this.updateDnsFlags(role, interimStatus);
                this.summaryStatus = this.getStatusOfInProgress();
                break;
            }
            case POST: {
                this.updateDnsFlags(role, interimStatus);
                this.summaryStatus = this.getStatusOfPost();
                break;
            }
            case COMPLETED: {
                this.updateDnsFlags(role, interimStatus);
                this.summaryStatus = this.getStatusOfCompleted();
                break;
            }
            default: {
                throw new UnsupportedOperationException(Messages.get("bgd.unknownPhase", new Object[]{this.bgdId, this.latestStatusPhase}));
            }
        }
    }

    protected void updateMonitors() {
        switch (this.summaryStatus.getCurrentPhase()) {
            case NOT_CREATED: {
                Arrays.stream(this.monitors).forEach(x -> {
                    x.setIntervalRate(BlueGreenIntervalRate.BASELINE);
                    x.setCollectIpAddresses(false);
                    x.setCollectTopology(false);
                    x.setUseIpAddress(false);
                });
                break;
            }
            case CREATED: {
                Arrays.stream(this.monitors).forEach(x -> {
                    x.setIntervalRate(BlueGreenIntervalRate.INCREASED);
                    x.setCollectIpAddresses(true);
                    x.setCollectTopology(true);
                    x.setUseIpAddress(false);
                    if (this.rollback) {
                        x.resetCollectedData();
                    }
                });
                break;
            }
            case PREPARATION: 
            case IN_PROGRESS: 
            case POST: {
                Arrays.stream(this.monitors).forEach(x -> {
                    x.setIntervalRate(BlueGreenIntervalRate.HIGH);
                    x.setCollectIpAddresses(false);
                    x.setCollectTopology(false);
                    x.setUseIpAddress(true);
                });
                break;
            }
            case COMPLETED: {
                Arrays.stream(this.monitors).forEach(x -> {
                    x.setIntervalRate(BlueGreenIntervalRate.BASELINE);
                    x.setCollectIpAddresses(false);
                    x.setCollectTopology(false);
                    x.setUseIpAddress(false);
                    x.resetCollectedData();
                });
                if (this.rollback || this.monitors[BlueGreenRole.SOURCE.getValue()] == null) break;
                this.monitors[BlueGreenRole.SOURCE.getValue()].setStop(true);
                break;
            }
            default: {
                throw new UnsupportedOperationException(Messages.get("bgd.unknownPhase", new Object[]{this.bgdId, this.summaryStatus.getCurrentPhase()}));
            }
        }
    }

    protected void updateDnsFlags(BlueGreenRole role, BlueGreenInterimStatus interimStatus) {
        if (role == BlueGreenRole.SOURCE && !this.blueDnsUpdateCompleted && interimStatus.allStartTopologyIpChanged) {
            LOGGER.finest(() -> Messages.get("bgd.blueDnsCompleted", new Object[]{this.bgdId}));
            this.blueDnsUpdateCompleted = true;
            this.storeBlueDnsUpdateTime();
        }
        if (role == BlueGreenRole.TARGET && !this.greenDnsRemoved && interimStatus.allStartTopologyEndpointsRemoved) {
            LOGGER.finest(() -> Messages.get("bgd.greenDnsRemoved", new Object[]{this.bgdId}));
            this.greenDnsRemoved = true;
            this.storeGreenDnsRemoveTime();
        }
        if (role == BlueGreenRole.TARGET && !this.greenTopologyChanged && interimStatus.allTopologyChanged) {
            LOGGER.finest(() -> Messages.get("bgd.greenTopologyChanged", new Object[]{this.bgdId}));
            this.greenTopologyChanged = true;
            this.storeGreenTopologyChangeTime();
        }
    }

    protected int getInterimStatusHash(BlueGreenInterimStatus interimStatus) {
        int result = this.getValueHash(1, interimStatus.blueGreenPhase == null ? "" : interimStatus.blueGreenPhase.toString());
        result = this.getValueHash(result, interimStatus.version == null ? "" : interimStatus.version);
        result = this.getValueHash(result, String.valueOf(interimStatus.port));
        result = this.getValueHash(result, String.valueOf(interimStatus.allStartTopologyIpChanged));
        result = this.getValueHash(result, String.valueOf(interimStatus.allStartTopologyEndpointsRemoved));
        result = this.getValueHash(result, String.valueOf(interimStatus.allTopologyChanged));
        result = this.getValueHash(result, interimStatus.hostNames == null ? "" : interimStatus.hostNames.stream().sorted(Comparator.comparing(x -> x)).collect(Collectors.joining(",")));
        result = this.getValueHash(result, interimStatus.startTopology == null ? "" : interimStatus.startTopology.stream().map(x -> x.getHostAndPort() + (Object)((Object)x.getRole())).sorted(Comparator.comparing(x -> x)).collect(Collectors.joining(",")));
        result = this.getValueHash(result, interimStatus.currentTopology == null ? "" : interimStatus.currentTopology.stream().map(x -> x.getHostAndPort() + (Object)((Object)x.getRole())).sorted(Comparator.comparing(x -> x)).collect(Collectors.joining(",")));
        result = this.getValueHash(result, interimStatus.startIpAddressesByHostMap == null ? "" : interimStatus.startIpAddressesByHostMap.entrySet().stream().map(x -> (String)x.getKey() + x.getValue()).sorted(Comparator.comparing(x -> x)).collect(Collectors.joining(",")));
        result = this.getValueHash(result, interimStatus.currentIpAddressesByHostMap == null ? "" : interimStatus.currentIpAddressesByHostMap.entrySet().stream().map(x -> (String)x.getKey() + x.getValue()).sorted(Comparator.comparing(x -> x)).collect(Collectors.joining(",")));
        return result;
    }

    protected int getContextHash() {
        int result = this.getValueHash(1, String.valueOf(this.allGreenNodesChangedName.get()));
        result = this.getValueHash(result, String.valueOf(this.iamHostSuccessfulConnects.size()));
        return result;
    }

    protected int getValueHash(int currentHash, String val) {
        return currentHash * 31 + val.hashCode();
    }

    protected String getHostAndPort(String host, int port) {
        if (port > 0) {
            return String.format("%s:%d", host, port);
        }
        return host;
    }

    protected BlueGreenStatus getStatusOfCreated() {
        return new BlueGreenStatus(this.bgdId, BlueGreenPhase.CREATED, new ArrayList<ConnectRouting>(), new ArrayList<ExecuteRouting>(), this.roleByHost, this.correspondingNodes);
    }

    protected BlueGreenStatus getStatusOfPreparation() {
        if (this.isSwitchoverTimerExpired()) {
            LOGGER.finest(Messages.get("bgd.switchoverTimeout"));
            if (this.rollback) {
                return this.getStatusOfCreated();
            }
            return this.getStatusOfCompleted();
        }
        List<ConnectRouting> connectRouting = this.addSubstituteBlueWithIpAddressConnectRouting();
        return new BlueGreenStatus(this.bgdId, BlueGreenPhase.PREPARATION, connectRouting, new ArrayList<ExecuteRouting>(), this.roleByHost, this.correspondingNodes);
    }

    protected List<ConnectRouting> addSubstituteBlueWithIpAddressConnectRouting() {
        ArrayList<ConnectRouting> connectRouting = new ArrayList<ConnectRouting>();
        this.roleByHost.entrySet().stream().filter(x -> x.getValue() == BlueGreenRole.SOURCE && this.correspondingNodes.containsKey(x.getKey())).forEach(x -> {
            HostSpec hostSpec = this.correspondingNodes.get(x.getKey()).getValue1();
            Optional<String> blueIp = this.hostIpAddresses.get(hostSpec.getHost());
            HostSpec substituteHostSpecWithIp = blueIp == null || !blueIp.isPresent() ? hostSpec : this.hostSpecBuilder.copyFrom(hostSpec).host(blueIp.get()).build();
            connectRouting.add(new SubstituteConnectRouting((String)x.getKey(), (BlueGreenRole)((Object)((Object)x.getValue())), substituteHostSpecWithIp, Collections.singletonList(hostSpec), null));
            connectRouting.add(new SubstituteConnectRouting(this.getHostAndPort((String)x.getKey(), this.interimStatuses[((BlueGreenRole)((Object)((Object)x.getValue()))).getValue()].port), (BlueGreenRole)((Object)((Object)x.getValue())), substituteHostSpecWithIp, Collections.singletonList(hostSpec), null));
        });
        return connectRouting;
    }

    protected BlueGreenStatus getStatusOfInProgress() {
        List<ConnectRouting> connectRouting;
        if (this.isSwitchoverTimerExpired()) {
            LOGGER.finest(Messages.get("bgd.switchoverTimeout"));
            if (this.rollback) {
                return this.getStatusOfCreated();
            }
            return this.getStatusOfCompleted();
        }
        if (this.suspendNewBlueConnectionsWhenInProgress) {
            connectRouting = new ArrayList<ConnectRouting>();
            connectRouting.add(new SuspendConnectRouting(null, BlueGreenRole.SOURCE, this.bgdId));
        } else {
            connectRouting = this.addSubstituteBlueWithIpAddressConnectRouting();
        }
        connectRouting.add(new SuspendConnectRouting(null, BlueGreenRole.TARGET, this.bgdId));
        this.hostIpAddresses.values().stream().filter(Optional::isPresent).map(Optional::get).distinct().forEach(ipAddress -> {
            BlueGreenInterimStatus interimStatus;
            if (this.suspendNewBlueConnectionsWhenInProgress && (interimStatus = this.interimStatuses[BlueGreenRole.SOURCE.getValue()]) != null && interimStatus.startIpAddressesByHostMap.values().stream().filter(x -> x.isPresent() && ((String)x.get()).equals(ipAddress)).map(x -> true).findFirst().orElse(false).booleanValue()) {
                connectRouting.add(new SuspendConnectRouting((String)ipAddress, null, this.bgdId));
                connectRouting.add(new SuspendConnectRouting(this.getHostAndPort((String)ipAddress, interimStatus.port), null, this.bgdId));
                return;
            }
            interimStatus = this.interimStatuses[BlueGreenRole.TARGET.getValue()];
            if (interimStatus != null && interimStatus.startIpAddressesByHostMap.values().stream().filter(x -> x.isPresent() && ((String)x.get()).equals(ipAddress)).map(x -> true).findFirst().orElse(false).booleanValue()) {
                connectRouting.add(new SuspendConnectRouting((String)ipAddress, null, this.bgdId));
                connectRouting.add(new SuspendConnectRouting(this.getHostAndPort((String)ipAddress, interimStatus.port), null, this.bgdId));
                return;
            }
        });
        ArrayList<ExecuteRouting> executeRouting = new ArrayList<ExecuteRouting>();
        executeRouting.add(new SuspendExecuteRouting(null, BlueGreenRole.SOURCE, this.bgdId));
        executeRouting.add(new SuspendExecuteRouting(null, BlueGreenRole.TARGET, this.bgdId));
        this.hostIpAddresses.values().stream().filter(Optional::isPresent).map(Optional::get).distinct().forEach(ipAddress -> {
            BlueGreenInterimStatus interimStatus = this.interimStatuses[BlueGreenRole.SOURCE.getValue()];
            if (interimStatus != null && interimStatus.startIpAddressesByHostMap.values().stream().filter(x -> x.isPresent() && ((String)x.get()).equals(ipAddress)).map(x -> true).findFirst().orElse(false).booleanValue()) {
                executeRouting.add(new SuspendExecuteRouting((String)ipAddress, null, this.bgdId));
                executeRouting.add(new SuspendExecuteRouting(this.getHostAndPort((String)ipAddress, interimStatus.port), null, this.bgdId));
                return;
            }
            interimStatus = this.interimStatuses[BlueGreenRole.TARGET.getValue()];
            if (interimStatus != null && interimStatus.startIpAddressesByHostMap.values().stream().filter(x -> x.isPresent() && ((String)x.get()).equals(ipAddress)).map(x -> true).findFirst().orElse(false).booleanValue()) {
                executeRouting.add(new SuspendExecuteRouting((String)ipAddress, null, this.bgdId));
                executeRouting.add(new SuspendExecuteRouting(this.getHostAndPort((String)ipAddress, interimStatus.port), null, this.bgdId));
                return;
            }
            executeRouting.add(new SuspendExecuteRouting((String)ipAddress, null, this.bgdId));
        });
        return new BlueGreenStatus(this.bgdId, BlueGreenPhase.IN_PROGRESS, connectRouting, executeRouting, this.roleByHost, this.correspondingNodes);
    }

    protected BlueGreenStatus getStatusOfPost() {
        if (this.isSwitchoverTimerExpired()) {
            LOGGER.finest(Messages.get("bgd.switchoverTimeout"));
            if (this.rollback) {
                return this.getStatusOfCreated();
            }
            return this.getStatusOfCompleted();
        }
        ArrayList<ConnectRouting> connectRouting = new ArrayList<ConnectRouting>();
        ArrayList<ExecuteRouting> executeRouting = new ArrayList<ExecuteRouting>();
        this.createPostRouting(connectRouting);
        return new BlueGreenStatus(this.bgdId, BlueGreenPhase.POST, connectRouting, executeRouting, this.roleByHost, this.correspondingNodes);
    }

    protected void createPostRouting(List<ConnectRouting> connectRouting) {
        if (!this.blueDnsUpdateCompleted || !this.allGreenNodesChangedName.get()) {
            this.roleByHost.entrySet().stream().filter(x -> x.getValue() == BlueGreenRole.SOURCE).filter(x -> this.correspondingNodes.containsKey(x.getKey())).forEach(x -> {
                String blueHost = (String)x.getKey();
                boolean isBlueHostInstance = this.rdsUtils.isRdsInstance(blueHost);
                HostSpec blueHostSpec = this.correspondingNodes.get(x.getKey()).getValue1();
                HostSpec greenHostSpec = this.correspondingNodes.get(x.getKey()).getValue2();
                if (greenHostSpec == null) {
                    connectRouting.add(new SuspendUntilCorrespondingNodeFoundConnectRouting(blueHost, (BlueGreenRole)((Object)((Object)x.getValue())), this.bgdId));
                    connectRouting.add(new SuspendUntilCorrespondingNodeFoundConnectRouting(this.getHostAndPort(blueHost, this.interimStatuses[((BlueGreenRole)((Object)((Object)x.getValue()))).getValue()].port), (BlueGreenRole)((Object)((Object)x.getValue())), this.bgdId));
                } else {
                    String greenHost = greenHostSpec.getHost();
                    Optional<String> greenIp = this.hostIpAddresses.get(greenHostSpec.getHost());
                    HostSpec greenHostSpecWithIp = greenIp == null || !greenIp.isPresent() ? greenHostSpec : this.hostSpecBuilder.copyFrom(greenHostSpec).host(greenIp.get()).build();
                    List<HostSpec> iamHosts = this.isAlreadySuccessfullyConnected(greenHost, blueHost) ? Collections.singletonList(blueHostSpec) : Arrays.asList(greenHostSpec, blueHostSpec);
                    connectRouting.add(new SubstituteConnectRouting(blueHost, (BlueGreenRole)((Object)((Object)x.getValue())), greenHostSpecWithIp, iamHosts, isBlueHostInstance ? iamHost -> this.registerIamHost(greenHost, iamHost) : null));
                    connectRouting.add(new SubstituteConnectRouting(this.getHostAndPort(blueHost, this.interimStatuses[((BlueGreenRole)((Object)((Object)x.getValue()))).getValue()].port), (BlueGreenRole)((Object)((Object)x.getValue())), greenHostSpecWithIp, iamHosts, isBlueHostInstance ? iamHost -> this.registerIamHost(greenHost, iamHost) : null));
                }
            });
        }
        if (!this.greenDnsRemoved) {
            connectRouting.add(new RejectConnectRouting(null, BlueGreenRole.TARGET));
        }
    }

    protected BlueGreenStatus getStatusOfCompleted() {
        if (this.isSwitchoverTimerExpired()) {
            LOGGER.finest(Messages.get("bgd.switchoverTimeout"));
            if (this.rollback) {
                return this.getStatusOfCreated();
            }
            return new BlueGreenStatus(this.bgdId, BlueGreenPhase.COMPLETED, new ArrayList<ConnectRouting>(), new ArrayList<ExecuteRouting>(), this.roleByHost, this.correspondingNodes);
        }
        if (!this.blueDnsUpdateCompleted || !this.greenDnsRemoved) {
            return this.getStatusOfPost();
        }
        return new BlueGreenStatus(this.bgdId, BlueGreenPhase.COMPLETED, new ArrayList<ConnectRouting>(), new ArrayList<ExecuteRouting>(), this.roleByHost, new HashMap<String, Pair<HostSpec, HostSpec>>());
    }

    protected void registerIamHost(String connectHost, String iamHost) {
        boolean allHostChangedNames;
        boolean alreadyChangedName;
        boolean differentNodeNames;
        boolean bl = differentNodeNames = connectHost != null && !connectHost.equals(iamHost);
        if (differentNodeNames && !(alreadyChangedName = this.iamHostSuccessfulConnects.computeIfAbsent(connectHost, key -> ConcurrentHashMap.newKeySet()).contains(iamHost))) {
            this.greenNodeChangeNameTimes.computeIfAbsent(connectHost, key -> Instant.now());
            LOGGER.finest(() -> Messages.get("bgd.greenNodeChangedName", new Object[]{connectHost, iamHost}));
        }
        this.iamHostSuccessfulConnects.computeIfAbsent(connectHost, key -> ConcurrentHashMap.newKeySet()).add(iamHost);
        if (differentNodeNames && (allHostChangedNames = this.iamHostSuccessfulConnects.entrySet().stream().filter(x -> !((Set)x.getValue()).isEmpty()).allMatch(x -> ((Set)x.getValue()).stream().anyMatch(y -> !((String)x.getKey()).equals(y)))) && !this.allGreenNodesChangedName.get()) {
            LOGGER.finest("allGreenNodesChangedName: true");
            this.allGreenNodesChangedName.set(true);
            this.storeGreenNodeChangeNameTime();
        }
    }

    protected boolean isAlreadySuccessfullyConnected(String connectHost, String iamHost) {
        return this.iamHostSuccessfulConnects.computeIfAbsent(connectHost, key -> ConcurrentHashMap.newKeySet()).contains(iamHost);
    }

    protected long getNanoTime() {
        return System.nanoTime();
    }

    protected void storePhaseTime(BlueGreenPhase phase) {
        if (phase == null) {
            return;
        }
        this.phaseTimeNano.putIfAbsent(phase.name() + (this.rollback ? " (rollback)" : ""), new PhaseTimeInfo(Instant.now(), this.getNanoTime(), phase));
    }

    protected void storeBlueDnsUpdateTime() {
        this.phaseTimeNano.putIfAbsent("Blue DNS updated" + (this.rollback ? " (rollback)" : ""), new PhaseTimeInfo(Instant.now(), this.getNanoTime(), null));
    }

    protected void storeGreenDnsRemoveTime() {
        this.phaseTimeNano.putIfAbsent("Green DNS removed" + (this.rollback ? " (rollback)" : ""), new PhaseTimeInfo(Instant.now(), this.getNanoTime(), null));
    }

    protected void storeGreenNodeChangeNameTime() {
        this.phaseTimeNano.putIfAbsent("Green node certificates changed" + (this.rollback ? " (rollback)" : ""), new PhaseTimeInfo(Instant.now(), this.getNanoTime(), null));
    }

    protected void storeGreenTopologyChangeTime() {
        this.phaseTimeNano.putIfAbsent("Green topology changed" + (this.rollback ? " (rollback)" : ""), new PhaseTimeInfo(Instant.now(), this.getNanoTime(), null));
    }

    protected void logSwitchoverFinalSummary() {
        boolean switchoverCompleted = !this.rollback && this.summaryStatus.getCurrentPhase() == BlueGreenPhase.COMPLETED || this.rollback && this.summaryStatus.getCurrentPhase() == BlueGreenPhase.CREATED;
        boolean hasActiveSwitchoverPhases = this.phaseTimeNano.entrySet().stream().anyMatch(x -> ((PhaseTimeInfo)x.getValue()).phase != null && ((PhaseTimeInfo)x.getValue()).phase.isActiveSwitchoverOrCompleted());
        if (!switchoverCompleted || !hasActiveSwitchoverPhases) {
            return;
        }
        PhaseTimeInfo timeZero = this.rollback ? this.phaseTimeNano.get(BlueGreenPhase.PREPARATION.name()) : this.phaseTimeNano.get(BlueGreenPhase.IN_PROGRESS.name());
        String divider = "----------------------------------------------------------------------------------\n";
        String logMessage = String.format("[bgdId: '%s']", this.bgdId) + "\n" + divider + String.format("%-28s %21s %31s\n", "timestamp", "time offset (ms)", "event") + divider + this.phaseTimeNano.entrySet().stream().sorted(Comparator.comparing(y -> ((PhaseTimeInfo)y.getValue()).timestampNano)).map(x -> String.format("%28s %18s ms %31s", ((PhaseTimeInfo)x.getValue()).timestamp, timeZero == null ? "" : Long.valueOf(TimeUnit.NANOSECONDS.toMillis(((PhaseTimeInfo)x.getValue()).timestampNano - timeZero.timestampNano)), x.getKey())).collect(Collectors.joining("\n")) + "\n" + divider;
        LOGGER.fine(logMessage);
    }

    protected void resetContextWhenCompleted() {
        boolean switchoverCompleted = !this.rollback && this.summaryStatus.getCurrentPhase() == BlueGreenPhase.COMPLETED || this.rollback && this.summaryStatus.getCurrentPhase() == BlueGreenPhase.CREATED;
        boolean hasActiveSwitchoverPhases = this.phaseTimeNano.entrySet().stream().anyMatch(x -> ((PhaseTimeInfo)x.getValue()).phase != null && ((PhaseTimeInfo)x.getValue()).phase.isActiveSwitchoverOrCompleted());
        if (switchoverCompleted && hasActiveSwitchoverPhases) {
            LOGGER.finest(Messages.get("bgd.resetContext"));
            this.rollback = false;
            this.summaryStatus = null;
            this.latestStatusPhase = BlueGreenPhase.NOT_CREATED;
            this.phaseTimeNano.clear();
            this.blueDnsUpdateCompleted = false;
            this.greenDnsRemoved = false;
            this.greenTopologyChanged = false;
            this.allGreenNodesChangedName.set(false);
            this.postStatusEndTimeNano = 0L;
            this.interimStatusHashes = new int[]{0, 0};
            this.lastContextHash = 0;
            this.interimStatuses = new BlueGreenInterimStatus[]{null, null};
            this.hostIpAddresses.clear();
            this.correspondingNodes.clear();
            this.roleByHost.clear();
            this.iamHostSuccessfulConnects.clear();
            this.greenNodeChangeNameTimes.clear();
        }
    }

    protected void startSwitchoverTimer() {
        if (this.postStatusEndTimeNano == 0L) {
            this.postStatusEndTimeNano = this.getNanoTime() + this.switchoverTimeoutNano;
        }
    }

    protected boolean isSwitchoverTimerExpired() {
        return this.postStatusEndTimeNano > 0L && this.postStatusEndTimeNano < this.getNanoTime();
    }

    protected void logCurrentContext() {
        if (!LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.fine(() -> String.format("[bgdId: '%s'] BG status: %s", this.bgdId, this.summaryStatus == null || this.summaryStatus.getCurrentPhase() == null ? "<null>" : this.summaryStatus.getCurrentPhase()));
        }
        LOGGER.finest(() -> String.format("[bgdId: '%s'] Summary status:\n%s", this.bgdId, this.summaryStatus == null ? "<null>" : this.summaryStatus.toString()));
        LOGGER.finest(() -> "Corresponding nodes:\n" + this.correspondingNodes.entrySet().stream().map(x -> String.format("   %s -> %s", x.getKey(), ((Pair)x.getValue()).getValue2() == null ? "<null>" : ((HostSpec)((Pair)x.getValue()).getValue2()).getHostAndPort())).collect(Collectors.joining("\n")));
        LOGGER.finest(() -> "Phase times:\n" + this.phaseTimeNano.entrySet().stream().map(x -> String.format("   %s -> %s", x.getKey(), ((PhaseTimeInfo)x.getValue()).timestamp)).collect(Collectors.joining("\n")));
        LOGGER.finest(() -> "Green node certificate change times:\n" + this.greenNodeChangeNameTimes.entrySet().stream().map(x -> String.format("   %s -> %s", x.getKey(), x.getValue())).collect(Collectors.joining("\n")));
        LOGGER.finest(() -> String.format("\n   latestStatusPhase: %s\n   blueDnsUpdateCompleted: %s\n   greenDnsRemoved: %s\n   greenNodeChangedName: %s\n   greenTopologyChanged: %s", new Object[]{this.latestStatusPhase, this.blueDnsUpdateCompleted, this.greenDnsRemoved, this.allGreenNodesChangedName.get(), this.greenTopologyChanged}));
    }

    public static class PhaseTimeInfo {
        public final Instant timestamp;
        public final long timestampNano;
        public final @Nullable BlueGreenPhase phase;

        public PhaseTimeInfo(Instant timestamp, long timestampNano, @Nullable BlueGreenPhase phase) {
            this.timestamp = timestamp;
            this.timestampNano = timestampNano;
            this.phase = phase;
        }
    }
}

