/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.ConnectionPlugin;
import software.amazon.jdbc.ConnectionPluginFactory;
import software.amazon.jdbc.ConnectionProvider;
import software.amazon.jdbc.PluginManagerService;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.plugin.AuroraConnectionTrackerPluginFactory;
import software.amazon.jdbc.plugin.AuroraInitialConnectionStrategyPluginFactory;
import software.amazon.jdbc.plugin.AwsSecretsManagerConnectionPluginFactory;
import software.amazon.jdbc.plugin.ConnectTimeConnectionPluginFactory;
import software.amazon.jdbc.plugin.DataCacheConnectionPluginFactory;
import software.amazon.jdbc.plugin.DefaultConnectionPlugin;
import software.amazon.jdbc.plugin.DriverMetaDataConnectionPluginFactory;
import software.amazon.jdbc.plugin.ExecutionTimeConnectionPluginFactory;
import software.amazon.jdbc.plugin.LogQueryConnectionPluginFactory;
import software.amazon.jdbc.plugin.customendpoint.CustomEndpointPluginFactory;
import software.amazon.jdbc.plugin.dev.DeveloperConnectionPluginFactory;
import software.amazon.jdbc.plugin.efm2.HostMonitoringConnectionPluginFactory;
import software.amazon.jdbc.plugin.failover2.FailoverConnectionPluginFactory;
import software.amazon.jdbc.plugin.federatedauth.FederatedAuthPluginFactory;
import software.amazon.jdbc.plugin.federatedauth.OktaAuthPluginFactory;
import software.amazon.jdbc.plugin.iam.IamAuthConnectionPluginFactory;
import software.amazon.jdbc.plugin.limitless.LimitlessConnectionPluginFactory;
import software.amazon.jdbc.plugin.readwritesplitting.ReadWriteSplittingPluginFactory;
import software.amazon.jdbc.plugin.staledns.AuroraStaleDnsPluginFactory;
import software.amazon.jdbc.plugin.strategy.fastestresponse.FastestResponseStrategyPluginFactory;
import software.amazon.jdbc.profile.ConfigurationProfile;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.SqlState;
import software.amazon.jdbc.util.StringUtils;
import software.amazon.jdbc.util.WrapperUtils;

public class ConnectionPluginChainBuilder {
    private static final Logger LOGGER = Logger.getLogger(ConnectionPluginChainBuilder.class.getName());
    private static final int WEIGHT_RELATIVE_TO_PRIOR_PLUGIN = -1;
    protected static final Map<String, Class<? extends ConnectionPluginFactory>> pluginFactoriesByCode = new HashMap<String, Class<? extends ConnectionPluginFactory>>(){
        {
            this.put("executionTime", ExecutionTimeConnectionPluginFactory.class);
            this.put("logQuery", LogQueryConnectionPluginFactory.class);
            this.put("dataCache", DataCacheConnectionPluginFactory.class);
            this.put("customEndpoint", CustomEndpointPluginFactory.class);
            this.put("efm", software.amazon.jdbc.plugin.efm.HostMonitoringConnectionPluginFactory.class);
            this.put("efm2", HostMonitoringConnectionPluginFactory.class);
            this.put("failover", software.amazon.jdbc.plugin.failover.FailoverConnectionPluginFactory.class);
            this.put("failover2", FailoverConnectionPluginFactory.class);
            this.put("iam", IamAuthConnectionPluginFactory.class);
            this.put("awsSecretsManager", AwsSecretsManagerConnectionPluginFactory.class);
            this.put("federatedAuth", FederatedAuthPluginFactory.class);
            this.put("okta", OktaAuthPluginFactory.class);
            this.put("auroraStaleDns", AuroraStaleDnsPluginFactory.class);
            this.put("readWriteSplitting", ReadWriteSplittingPluginFactory.class);
            this.put("auroraConnectionTracker", AuroraConnectionTrackerPluginFactory.class);
            this.put("driverMetaData", DriverMetaDataConnectionPluginFactory.class);
            this.put("connectTime", ConnectTimeConnectionPluginFactory.class);
            this.put("dev", DeveloperConnectionPluginFactory.class);
            this.put("fastestResponseStrategy", FastestResponseStrategyPluginFactory.class);
            this.put("initialConnection", AuroraInitialConnectionStrategyPluginFactory.class);
            this.put("limitless", LimitlessConnectionPluginFactory.class);
        }
    };
    protected static final Map<Class<? extends ConnectionPluginFactory>, Integer> pluginWeightByPluginFactory = new HashMap<Class<? extends ConnectionPluginFactory>, Integer>(){
        {
            this.put(DriverMetaDataConnectionPluginFactory.class, 100);
            this.put(DataCacheConnectionPluginFactory.class, 200);
            this.put(CustomEndpointPluginFactory.class, 380);
            this.put(AuroraInitialConnectionStrategyPluginFactory.class, 390);
            this.put(AuroraConnectionTrackerPluginFactory.class, 400);
            this.put(AuroraStaleDnsPluginFactory.class, 500);
            this.put(ReadWriteSplittingPluginFactory.class, 600);
            this.put(software.amazon.jdbc.plugin.failover.FailoverConnectionPluginFactory.class, 700);
            this.put(FailoverConnectionPluginFactory.class, 710);
            this.put(software.amazon.jdbc.plugin.efm.HostMonitoringConnectionPluginFactory.class, 800);
            this.put(HostMonitoringConnectionPluginFactory.class, 810);
            this.put(FastestResponseStrategyPluginFactory.class, 900);
            this.put(LimitlessConnectionPluginFactory.class, 950);
            this.put(IamAuthConnectionPluginFactory.class, 1000);
            this.put(AwsSecretsManagerConnectionPluginFactory.class, 1100);
            this.put(FederatedAuthPluginFactory.class, 1200);
            this.put(LogQueryConnectionPluginFactory.class, 1300);
            this.put(ConnectTimeConnectionPluginFactory.class, -1);
            this.put(ExecutionTimeConnectionPluginFactory.class, -1);
            this.put(DeveloperConnectionPluginFactory.class, -1);
        }
    };
    protected static final String DEFAULT_PLUGINS = "auroraConnectionTracker,failover,efm2";

    public List<ConnectionPlugin> getPlugins(PluginService pluginService, ConnectionProvider defaultConnProvider, ConnectionProvider effectiveConnProvider, PluginManagerService pluginManagerService, Properties props, @Nullable ConfigurationProfile configurationProfile) throws SQLException {
        ArrayList<ConnectionPlugin> plugins;
        List pluginFactories;
        if (configurationProfile != null && configurationProfile.getPluginFactories() != null) {
            pluginFactories = configurationProfile.getPluginFactories();
        } else {
            List<String> pluginCodeList = ConnectionPluginChainBuilder.getPluginCodes(props);
            pluginFactories = new ArrayList<Class<? extends ConnectionPluginFactory>>(pluginCodeList.size());
            for (String pluginCode : pluginCodeList) {
                if (!pluginFactoriesByCode.containsKey(pluginCode)) {
                    throw new SQLException(Messages.get("ConnectionPluginManager.unknownPluginCode", new Object[]{pluginCode}));
                }
                pluginFactories.add(pluginFactoriesByCode.get(pluginCode));
            }
        }
        if (!pluginFactories.isEmpty()) {
            if (PropertyDefinition.AUTO_SORT_PLUGIN_ORDER.getBoolean(props)) {
                List tempPluginFactories = pluginFactories = this.sortPluginFactories(pluginFactories);
                LOGGER.finest(() -> "Plugins order has been rearranged. The following order is in effect: " + tempPluginFactories.stream().map(Class::getSimpleName).collect(Collectors.joining(", ")));
            }
            try {
                ConnectionPluginFactory[] factories = WrapperUtils.loadClasses(pluginFactories, ConnectionPluginFactory.class, "ConnectionPluginManager.unableToLoadPlugin").toArray(new ConnectionPluginFactory[0]);
                plugins = new ArrayList(factories.length + 1);
                for (ConnectionPluginFactory factory : factories) {
                    plugins.add(factory.getInstance(pluginService, props));
                }
            }
            catch (InstantiationException instEx) {
                throw new SQLException(instEx.getMessage(), SqlState.UNKNOWN_STATE.getState(), instEx);
            }
        } else {
            plugins = new ArrayList<ConnectionPlugin>(1);
        }
        DefaultConnectionPlugin defaultPlugin = new DefaultConnectionPlugin(pluginService, defaultConnProvider, effectiveConnProvider, pluginManagerService);
        plugins.add(defaultPlugin);
        return plugins;
    }

    public static List<String> getPluginCodes(Properties props) {
        String pluginCodes = PropertyDefinition.PLUGINS.getString(props);
        if (pluginCodes == null) {
            pluginCodes = DEFAULT_PLUGINS;
        }
        return StringUtils.split(pluginCodes, ",", true);
    }

    protected List<Class<? extends ConnectionPluginFactory>> sortPluginFactories(List<Class<? extends ConnectionPluginFactory>> unsortedPluginFactories) {
        ArrayList<PluginFactoryInfo> weights = new ArrayList<PluginFactoryInfo>();
        int lastWeight = 0;
        for (Class<? extends ConnectionPluginFactory> pluginFactory : unsortedPluginFactories) {
            Integer pluginFactoryWeight = pluginWeightByPluginFactory.get(pluginFactory);
            if (pluginFactoryWeight == null || pluginFactoryWeight == -1) {
                weights.add(new PluginFactoryInfo(pluginFactory, ++lastWeight));
                continue;
            }
            weights.add(new PluginFactoryInfo(pluginFactory, pluginFactoryWeight));
            lastWeight = pluginFactoryWeight;
        }
        return weights.stream().sorted(Comparator.comparingInt(o -> o.weight)).map(info -> info.factory).collect(Collectors.toList());
    }

    private static class PluginFactoryInfo {
        public Class<? extends ConnectionPluginFactory> factory;
        public int weight;

        public PluginFactoryInfo(Class<? extends ConnectionPluginFactory> factory, int weight) {
            this.factory = factory;
            this.weight = weight;
        }
    }
}

