/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.customendpoint;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.model.DBClusterEndpoint;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsResponse;
import software.amazon.awssdk.services.rds.model.Filter;
import software.amazon.jdbc.AllowedAndBlockedHosts;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.plugin.customendpoint.CustomEndpointInfo;
import software.amazon.jdbc.plugin.customendpoint.CustomEndpointMonitor;
import software.amazon.jdbc.plugin.customendpoint.CustomEndpointPlugin;
import software.amazon.jdbc.plugin.customendpoint.MemberListType;
import software.amazon.jdbc.util.CacheMap;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.StringUtils;
import software.amazon.jdbc.util.telemetry.TelemetryCounter;
import software.amazon.jdbc.util.telemetry.TelemetryFactory;

public class CustomEndpointMonitorImpl
implements CustomEndpointMonitor {
    private static final Logger LOGGER = Logger.getLogger(CustomEndpointPlugin.class.getName());
    private static final String TELEMETRY_ENDPOINT_INFO_CHANGED = "customEndpoint.infoChanged.counter";
    protected static final CacheMap<String, CustomEndpointInfo> customEndpointInfoCache = new CacheMap();
    protected static final long CUSTOM_ENDPOINT_INFO_EXPIRATION_NANO = TimeUnit.MINUTES.toNanos(5L);
    protected final AtomicBoolean stop = new AtomicBoolean(false);
    protected final RdsClient rdsClient;
    protected final HostSpec customEndpointHostSpec;
    protected final String endpointIdentifier;
    protected final Region region;
    protected final long refreshRateNano;
    protected final PluginService pluginService;
    protected final ExecutorService monitorExecutor = Executors.newSingleThreadExecutor(runnableTarget -> {
        Thread monitoringThread = new Thread(runnableTarget);
        monitoringThread.setDaemon(true);
        if (!StringUtils.isNullOrEmpty(monitoringThread.getName())) {
            monitoringThread.setName(monitoringThread.getName() + "-cem");
        }
        return monitoringThread;
    });
    private final TelemetryCounter infoChangedCounter;

    public CustomEndpointMonitorImpl(PluginService pluginService, HostSpec customEndpointHostSpec, String endpointIdentifier, Region region, long refreshRateNano, BiFunction<HostSpec, Region, RdsClient> rdsClientFunc) {
        this.pluginService = pluginService;
        this.customEndpointHostSpec = customEndpointHostSpec;
        this.endpointIdentifier = endpointIdentifier;
        this.region = region;
        this.refreshRateNano = refreshRateNano;
        this.rdsClient = rdsClientFunc.apply(customEndpointHostSpec, this.region);
        TelemetryFactory telemetryFactory = this.pluginService.getTelemetryFactory();
        this.infoChangedCounter = telemetryFactory.createCounter(TELEMETRY_ENDPOINT_INFO_CHANGED);
        this.monitorExecutor.submit(this);
        this.monitorExecutor.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOGGER.fine(Messages.get("CustomEndpointMonitorImpl.startingMonitor", new Object[]{this.customEndpointHostSpec.getHost()}));
        try {
            while (!this.stop.get() && !Thread.currentThread().isInterrupted()) {
                try {
                    long start = System.nanoTime();
                    Filter customEndpointFilter = (Filter)Filter.builder().name("db-cluster-endpoint-type").values(new String[]{"custom"}).build();
                    DescribeDbClusterEndpointsResponse endpointsResponse = this.rdsClient.describeDBClusterEndpoints(builder -> builder.dbClusterEndpointIdentifier(this.endpointIdentifier).filters(new Filter[]{customEndpointFilter}));
                    List endpoints = endpointsResponse.dbClusterEndpoints();
                    if (endpoints.size() != 1) {
                        List endpointURLs = endpoints.stream().map(DBClusterEndpoint::endpoint).collect(Collectors.toList());
                        LOGGER.warning(Messages.get("CustomEndpointMonitorImpl.unexpectedNumberOfEndpoints", new Object[]{this.endpointIdentifier, this.region.id(), endpoints.size(), endpointURLs}));
                        TimeUnit.NANOSECONDS.sleep(this.refreshRateNano);
                        continue;
                    }
                    CustomEndpointInfo endpointInfo = CustomEndpointInfo.fromDBClusterEndpoint((DBClusterEndpoint)endpoints.get(0));
                    CustomEndpointInfo cachedEndpointInfo = customEndpointInfoCache.get(this.customEndpointHostSpec.getHost());
                    if (cachedEndpointInfo != null && cachedEndpointInfo.equals(endpointInfo)) {
                        long elapsedTime = System.nanoTime() - start;
                        long sleepDuration = Math.max(0L, this.refreshRateNano - elapsedTime);
                        TimeUnit.NANOSECONDS.sleep(sleepDuration);
                        continue;
                    }
                    LOGGER.fine(Messages.get("CustomEndpointMonitorImpl.detectedChangeInCustomEndpointInfo", new Object[]{this.customEndpointHostSpec.getHost(), endpointInfo}));
                    AllowedAndBlockedHosts allowedAndBlockedHosts = MemberListType.STATIC_LIST.equals((Object)endpointInfo.getMemberListType()) ? new AllowedAndBlockedHosts(endpointInfo.getStaticMembers(), null) : new AllowedAndBlockedHosts(null, endpointInfo.getExcludedMembers());
                    this.pluginService.setAllowedAndBlockedHosts(allowedAndBlockedHosts);
                    customEndpointInfoCache.put(this.customEndpointHostSpec.getHost(), endpointInfo, CUSTOM_ENDPOINT_INFO_EXPIRATION_NANO);
                    this.infoChangedCounter.inc();
                    long elapsedTime = System.nanoTime() - start;
                    long sleepDuration = Math.max(0L, this.refreshRateNano - elapsedTime);
                    TimeUnit.NANOSECONDS.sleep(sleepDuration);
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, Messages.get("CustomEndpointMonitorImpl.exception", new Object[]{this.customEndpointHostSpec.getHost()}), e);
                }
            }
            customEndpointInfoCache.remove(this.customEndpointHostSpec.getHost());
        }
        catch (InterruptedException e) {
            try {
                LOGGER.fine(Messages.get("CustomEndpointMonitorImpl.interrupted", new Object[]{this.customEndpointHostSpec.getHost()}));
                Thread.currentThread().interrupt();
                customEndpointInfoCache.remove(this.customEndpointHostSpec.getHost());
            }
            catch (Throwable throwable) {
                customEndpointInfoCache.remove(this.customEndpointHostSpec.getHost());
                this.rdsClient.close();
                LOGGER.fine(Messages.get("CustomEndpointMonitorImpl.stoppedMonitor", new Object[]{this.customEndpointHostSpec.getHost()}));
                throw throwable;
            }
            this.rdsClient.close();
            LOGGER.fine(Messages.get("CustomEndpointMonitorImpl.stoppedMonitor", new Object[]{this.customEndpointHostSpec.getHost()}));
        }
        this.rdsClient.close();
        LOGGER.fine(Messages.get("CustomEndpointMonitorImpl.stoppedMonitor", new Object[]{this.customEndpointHostSpec.getHost()}));
    }

    @Override
    public boolean hasCustomEndpointInfo() {
        return customEndpointInfoCache.get(this.customEndpointHostSpec.getHost()) != null;
    }

    @Override
    public boolean shouldDispose() {
        return true;
    }

    @Override
    public void close() {
        LOGGER.fine(Messages.get("CustomEndpointMonitorImpl.stoppingMonitor", new Object[]{this.customEndpointHostSpec.getHost()}));
        this.stop.set(true);
        try {
            int terminationTimeoutSec = 5;
            if (!this.monitorExecutor.awaitTermination(terminationTimeoutSec, TimeUnit.SECONDS)) {
                LOGGER.info(Messages.get("CustomEndpointMonitorImpl.monitorTerminationTimeout", new Object[]{terminationTimeoutSec, this.customEndpointHostSpec.getHost()}));
                this.monitorExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            LOGGER.info(Messages.get("CustomEndpointMonitorImpl.interruptedWhileTerminating", new Object[]{this.customEndpointHostSpec.getHost()}));
            Thread.currentThread().interrupt();
            this.monitorExecutor.shutdownNow();
        }
        finally {
            customEndpointInfoCache.remove(this.customEndpointHostSpec.getHost());
            this.rdsClient.close();
        }
    }

    public static void clearCache() {
        LOGGER.info(Messages.get("CustomEndpointMonitorImpl.clearCache"));
        customEndpointInfoCache.clear();
    }
}

