/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.JdbcCallable;
import software.amazon.jdbc.NodeChangeOptions;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.cleanup.CanReleaseResources;
import software.amazon.jdbc.plugin.AbstractConnectionPlugin;
import software.amazon.jdbc.plugin.OpenedConnectionTracker;
import software.amazon.jdbc.plugin.failover.FailoverSQLException;
import software.amazon.jdbc.util.RdsUrlType;
import software.amazon.jdbc.util.RdsUtils;
import software.amazon.jdbc.util.SubscribedMethodHelper;

public class AuroraConnectionTrackerPlugin
extends AbstractConnectionPlugin
implements CanReleaseResources {
    private static final Logger LOGGER = Logger.getLogger(AuroraConnectionTrackerPlugin.class.getName());
    static final String METHOD_ABORT = "Connection.abort";
    static final String METHOD_CLOSE = "Connection.close";
    private static final Set<String> subscribedMethods = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.addAll(SubscribedMethodHelper.NETWORK_BOUND_METHODS);
            this.add("connect");
            this.add("forceConnect");
            this.add("notifyNodeListChanged");
        }
    });
    private final PluginService pluginService;
    private final RdsUtils rdsHelper;
    private final OpenedConnectionTracker tracker;
    private HostSpec currentWriter = null;
    private boolean needUpdateCurrentWriter = false;

    AuroraConnectionTrackerPlugin(PluginService pluginService, Properties props) {
        this(pluginService, props, new RdsUtils(), new OpenedConnectionTracker(pluginService));
    }

    AuroraConnectionTrackerPlugin(PluginService pluginService, Properties props, RdsUtils rdsUtils, OpenedConnectionTracker tracker) {
        this.pluginService = pluginService;
        this.rdsHelper = rdsUtils;
        this.tracker = tracker;
    }

    @Override
    public Set<String> getSubscribedMethods() {
        return subscribedMethods;
    }

    @Override
    public Connection connect(String driverProtocol, HostSpec hostSpec, Properties props, boolean isInitialConnection, JdbcCallable<Connection, SQLException> connectFunc) throws SQLException {
        return this.connectInternal(hostSpec, connectFunc);
    }

    public Connection connectInternal(HostSpec hostSpec, JdbcCallable<Connection, SQLException> connectFunc) throws SQLException {
        Connection conn = connectFunc.call();
        if (conn != null) {
            RdsUrlType type = this.rdsHelper.identifyRdsType(hostSpec.getHost());
            if (type.isRdsCluster()) {
                hostSpec.resetAliases();
                this.pluginService.fillAliases(conn, hostSpec);
            }
            this.tracker.populateOpenedConnectionQueue(hostSpec, conn);
        }
        return conn;
    }

    @Override
    public Connection forceConnect(String driverProtocol, HostSpec hostSpec, Properties props, boolean isInitialConnection, JdbcCallable<Connection, SQLException> forceConnectFunc) throws SQLException {
        return this.connectInternal(hostSpec, forceConnectFunc);
    }

    @Override
    public <T, E extends Exception> T execute(Class<T> resultClass, Class<E> exceptionClass, Object methodInvokeOn, String methodName, JdbcCallable<T, E> jdbcMethodFunc, Object[] jdbcMethodArgs) throws E {
        HostSpec currentHostSpec = this.pluginService.getCurrentHostSpec();
        this.rememberWriter();
        try {
            T result = jdbcMethodFunc.call();
            if (methodName.equals(METHOD_CLOSE) || methodName.equals(METHOD_ABORT)) {
                this.tracker.invalidateCurrentConnection(currentHostSpec, this.pluginService.getCurrentConnection());
            } else if (this.needUpdateCurrentWriter) {
                this.checkWriterChanged();
            }
            return result;
        }
        catch (Exception e) {
            if (e instanceof FailoverSQLException) {
                this.checkWriterChanged();
            }
            throw e;
        }
    }

    private void checkWriterChanged() {
        HostSpec hostSpecAfterFailover = this.getWriter(this.pluginService.getAllHosts());
        if (this.currentWriter == null) {
            this.currentWriter = hostSpecAfterFailover;
            this.needUpdateCurrentWriter = false;
        } else if (!this.currentWriter.equals(hostSpecAfterFailover)) {
            this.tracker.invalidateAllConnections(this.currentWriter);
            this.tracker.logOpenedConnections();
            this.currentWriter = hostSpecAfterFailover;
            this.needUpdateCurrentWriter = false;
        }
    }

    private void rememberWriter() {
        if (this.currentWriter == null || this.needUpdateCurrentWriter) {
            this.currentWriter = this.getWriter(this.pluginService.getAllHosts());
            this.needUpdateCurrentWriter = false;
        }
    }

    @Override
    public void notifyNodeListChanged(Map<String, EnumSet<NodeChangeOptions>> changes) {
        for (String node : changes.keySet()) {
            EnumSet<NodeChangeOptions> nodeChanges = changes.get(node);
            if (nodeChanges.contains((Object)NodeChangeOptions.PROMOTED_TO_READER)) {
                this.tracker.invalidateAllConnections(node);
            }
            if (!nodeChanges.contains((Object)NodeChangeOptions.PROMOTED_TO_WRITER)) continue;
            this.needUpdateCurrentWriter = true;
        }
    }

    @Override
    public void releaseResources() {
        this.tracker.pruneNullConnections();
    }

    private HostSpec getWriter(@NonNull List<HostSpec> hosts) {
        for (HostSpec hostSpec : hosts) {
            if (hostSpec.getRole() != HostRole.WRITER) continue;
            return hostSpec;
        }
        return null;
    }
}

