/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.util.telemetry;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.sdk.trace.ReadableSpan;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import software.amazon.jdbc.util.telemetry.TelemetryContext;
import software.amazon.jdbc.util.telemetry.TelemetryTraceLevel;

public class OpenTelemetryContext
implements TelemetryContext {
    private static final Logger LOGGER = Logger.getLogger(OpenTelemetryContext.class.getName());
    private Span span;
    private Scope scope;
    private final String name;
    private final Tracer tracer;

    public OpenTelemetryContext(Tracer tracer, String name, TelemetryTraceLevel traceLevel) {
        this(tracer, name, traceLevel, OpenTelemetryContext.getEpochNanos(Instant.now()));
    }

    private OpenTelemetryContext(Tracer tracer, String name, TelemetryTraceLevel traceLevel, long startTimeNanos) {
        this.name = name;
        this.tracer = tracer;
        boolean isRoot = Context.current() == Context.root();
        TelemetryTraceLevel effectiveTraceLevel = traceLevel;
        if (isRoot && traceLevel == TelemetryTraceLevel.NESTED) {
            effectiveTraceLevel = TelemetryTraceLevel.NO_TRACE;
        }
        switch (effectiveTraceLevel) {
            case FORCE_TOP_LEVEL: 
            case TOP_LEVEL: {
                this.span = this.tracer.spanBuilder(name).setNoParent().setStartTimestamp(startTimeNanos, TimeUnit.NANOSECONDS).startSpan();
                if (!isRoot) {
                    this.setAttribute("parentTraceId", this.span.getSpanContext().getTraceId());
                }
                this.setAttribute("traceName", name);
                this.scope = this.span.makeCurrent();
                LOGGER.finest(() -> String.format("[OTLP] Telemetry '%s' trace ID: %s", name, this.span.getSpanContext().getTraceId()));
                break;
            }
            case NESTED: {
                this.span = this.tracer.spanBuilder(name).setStartTimestamp(startTimeNanos, TimeUnit.NANOSECONDS).startSpan();
                this.setAttribute("traceName", name);
                this.scope = this.span.makeCurrent();
                break;
            }
            case NO_TRACE: {
                break;
            }
        }
    }

    @Override
    public void setSuccess(boolean success) {
        if (this.span != null) {
            if (success) {
                this.span.setStatus(StatusCode.OK);
            } else {
                this.span.setStatus(StatusCode.ERROR);
            }
        }
    }

    @Override
    public void setAttribute(String key, String value) {
        if (this.span != null) {
            this.span.setAttribute(key, value);
        }
    }

    @Override
    public void setException(Exception exception) {
        if (this.span != null && exception != null) {
            this.span.setAttribute("exceptionType", exception.getClass().getSimpleName());
            this.span.setAttribute("exceptionMessage", exception.getMessage());
            this.span.recordException((Throwable)exception);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return super.toString() + " " + (this.span == null ? "no span" : this.span.toString());
    }

    public static void postCopy(OpenTelemetryContext telemetryContext, TelemetryTraceLevel traceLevel) {
        if (traceLevel == TelemetryTraceLevel.NO_TRACE) {
            return;
        }
        if (traceLevel == TelemetryTraceLevel.FORCE_TOP_LEVEL || traceLevel == TelemetryTraceLevel.TOP_LEVEL) {
            CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
                OpenTelemetryContext copy = OpenTelemetryContext.clone(telemetryContext, traceLevel);
                copy.closeContext();
            });
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        } else {
            OpenTelemetryContext copy = OpenTelemetryContext.clone(telemetryContext, traceLevel);
            copy.closeContext();
        }
    }

    private static OpenTelemetryContext clone(OpenTelemetryContext telemetryContext, TelemetryTraceLevel traceLevel) {
        if (!(telemetryContext.span instanceof ReadableSpan)) {
            throw new RuntimeException("Can't use this telemetry context to make a copy.");
        }
        ReadableSpan readableSpan = (ReadableSpan)telemetryContext.span;
        long startTime = readableSpan.toSpanData().getStartEpochNanos();
        OpenTelemetryContext copy = new OpenTelemetryContext(telemetryContext.tracer, "copy: " + telemetryContext.getName(), traceLevel, startTime);
        Map attributes = readableSpan.toSpanData().getAttributes().asMap();
        for (Map.Entry entry : attributes.entrySet()) {
            if (entry.getValue() == null || "traceName".equals(((AttributeKey)entry.getKey()).getKey())) continue;
            copy.setAttribute(((AttributeKey)entry.getKey()).getKey(), entry.getValue().toString());
        }
        copy.span.setStatus(readableSpan.toSpanData().getStatus().getStatusCode());
        copy.setAttribute("sourceTraceId", telemetryContext.span.getSpanContext().getTraceId());
        return copy;
    }

    private static long getEpochNanos(Instant instant) {
        return TimeUnit.SECONDS.toNanos(instant.getEpochSecond()) + (long)instant.getNano();
    }

    @Override
    public void closeContext() {
        if (this.span != null) {
            this.span.end();
        }
        if (this.scope != null) {
            this.scope.close();
        }
    }
}

