/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.dialect;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.EnumSet;
import java.util.List;
import java.util.Properties;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.dialect.HostListProviderSupplier;
import software.amazon.jdbc.dialect.MysqlDialect;
import software.amazon.jdbc.hostlistprovider.RdsMultiAzDbClusterListProvider;
import software.amazon.jdbc.hostlistprovider.monitoring.MonitoringRdsMultiAzHostListProvider;
import software.amazon.jdbc.plugin.failover.FailoverRestriction;
import software.amazon.jdbc.plugin.failover2.FailoverConnectionPlugin;

public class RdsMultiAzDbClusterMysqlDialect
extends MysqlDialect {
    private static final String TOPOLOGY_QUERY = "SELECT id, endpoint, port FROM mysql.rds_topology";
    private static final String TOPOLOGY_TABLE_EXIST_QUERY = "SELECT 1 AS tmp FROM information_schema.tables WHERE table_schema = 'mysql' AND table_name = 'rds_topology'";
    private static final String FETCH_WRITER_NODE_QUERY = "SHOW REPLICA STATUS";
    private static final String FETCH_WRITER_NODE_QUERY_COLUMN_NAME = "Source_Server_Id";
    private static final String NODE_ID_QUERY = "SELECT @@server_id";
    private static final String IS_READER_QUERY = "SELECT @@read_only";
    private static final EnumSet<FailoverRestriction> RDS_MULTI_AZ_RESTRICTIONS = EnumSet.of(FailoverRestriction.DISABLE_TASK_A, FailoverRestriction.ENABLE_WRITER_IN_TASK_B);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDialect(Connection connection) {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = connection.createStatement();
            rs = stmt.executeQuery(TOPOLOGY_TABLE_EXIST_QUERY);
            if (rs.next()) {
                rs.close();
                stmt.close();
                stmt = connection.createStatement();
                rs = stmt.executeQuery(TOPOLOGY_QUERY);
                boolean bl = rs.next();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return false;
    }

    @Override
    public List<String> getDialectUpdateCandidates() {
        return null;
    }

    @Override
    public HostListProviderSupplier getHostListProvider() {
        return (properties, initialUrl, hostListProviderService, pluginService) -> {
            FailoverConnectionPlugin failover2Plugin = pluginService.getPlugin(FailoverConnectionPlugin.class);
            if (failover2Plugin != null) {
                return new MonitoringRdsMultiAzHostListProvider(properties, initialUrl, hostListProviderService, TOPOLOGY_QUERY, NODE_ID_QUERY, IS_READER_QUERY, pluginService, FETCH_WRITER_NODE_QUERY, FETCH_WRITER_NODE_QUERY_COLUMN_NAME);
            }
            return new RdsMultiAzDbClusterListProvider(properties, initialUrl, hostListProviderService, TOPOLOGY_QUERY, NODE_ID_QUERY, IS_READER_QUERY, FETCH_WRITER_NODE_QUERY, FETCH_WRITER_NODE_QUERY_COLUMN_NAME);
        };
    }

    @Override
    public void prepareConnectProperties(@NonNull Properties connectProperties, @NonNull String protocol, @NonNull HostSpec hostSpec) {
        String connectionAttributes = "_jdbc_wrapper_name:aws_jdbc_driver,_jdbc_wrapper_version:2.5.0";
        connectProperties.setProperty("connectionAttributes", connectProperties.getProperty("connectionAttributes") == null ? "_jdbc_wrapper_name:aws_jdbc_driver,_jdbc_wrapper_version:2.5.0" : connectProperties.getProperty("connectionAttributes") + "," + "_jdbc_wrapper_name:aws_jdbc_driver,_jdbc_wrapper_version:2.5.0");
    }

    @Override
    public EnumSet<FailoverRestriction> getFailoverRestrictions() {
        return RDS_MULTI_AZ_RESTRICTIONS;
    }
}

