/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.util;

import java.sql.SQLException;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Logger;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.plugin.iam.IamTokenUtility;
import software.amazon.jdbc.plugin.iam.LightRdsUtility;
import software.amazon.jdbc.plugin.iam.RegularRdsUtility;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.RdsUtils;
import software.amazon.jdbc.util.StringUtils;
import software.amazon.jdbc.util.telemetry.TelemetryContext;
import software.amazon.jdbc.util.telemetry.TelemetryFactory;
import software.amazon.jdbc.util.telemetry.TelemetryTraceLevel;

public class IamAuthUtils {
    private static final Logger LOGGER = Logger.getLogger(IamAuthUtils.class.getName());
    private static final String TELEMETRY_FETCH_TOKEN = "fetch authentication token";

    public static String getIamHost(String iamHost, HostSpec hostSpec) {
        if (!StringUtils.isNullOrEmpty(iamHost)) {
            return iamHost;
        }
        return hostSpec.getHost();
    }

    public static int getIamPort(int iamDefaultPort, HostSpec hostSpec, int dialectDefaultPort) {
        if (iamDefaultPort > 0) {
            return iamDefaultPort;
        }
        if (hostSpec.isPortSpecified()) {
            return hostSpec.getPort();
        }
        return dialectDefaultPort;
    }

    public static Region getRegion(RdsUtils rdsUtils, String iamRegion, String hostname, Properties props) throws SQLException {
        if (!StringUtils.isNullOrEmpty(iamRegion)) {
            return Region.of((String)iamRegion);
        }
        String rdsRegion = rdsUtils.getRdsRegion(hostname);
        if (StringUtils.isNullOrEmpty(rdsRegion)) {
            String exceptionMessage = Messages.get("Authentication.unsupportedHostname", new Object[]{hostname});
            LOGGER.fine(exceptionMessage);
            throw new SQLException(exceptionMessage);
        }
        Optional<Region> regionOptional = Region.regions().stream().filter(r -> r.id().equalsIgnoreCase(rdsRegion)).findFirst();
        if (!regionOptional.isPresent()) {
            String exceptionMessage = Messages.get("AwsSdk.unsupportedRegion", new Object[]{rdsRegion});
            LOGGER.fine(exceptionMessage);
            throw new SQLException(exceptionMessage);
        }
        return regionOptional.get();
    }

    public static String getCacheKey(String user, String hostname, int port, Region region) {
        return String.format("%s:%s:%d:%s", region, hostname, port, user);
    }

    public static IamTokenUtility getTokenUtility() {
        try {
            Class.forName("software.amazon.awssdk.services.rds.RdsUtilities");
            return new RegularRdsUtility();
        }
        catch (ClassNotFoundException e) {
            try {
                Class.forName("software.amazon.awssdk.http.SdkHttpFullRequest");
                Class.forName("software.amazon.awssdk.auth.signer.params.Aws4PresignerParams");
                return new LightRdsUtility();
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(Messages.get("AuthenticationToken.javaSdkNotInClasspath"), ex);
            }
        }
    }

    public static String generateAuthenticationToken(IamTokenUtility tokenUtils, PluginService pluginService, String user, String hostname, int port, Region region, AwsCredentialsProvider awsCredentialsProvider) {
        TelemetryFactory telemetryFactory = pluginService.getTelemetryFactory();
        TelemetryContext telemetryContext = telemetryFactory.openTelemetryContext(TELEMETRY_FETCH_TOKEN, TelemetryTraceLevel.NESTED);
        try {
            String string = tokenUtils.generateAuthenticationToken(awsCredentialsProvider, region, hostname, port, user);
            return string;
        }
        catch (Exception e) {
            telemetryContext.setSuccess(false);
            telemetryContext.setException(e);
            throw e;
        }
        finally {
            telemetryContext.closeContext();
        }
    }
}

