/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.dialect;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import software.amazon.jdbc.dialect.HostListProviderSupplier;
import software.amazon.jdbc.dialect.PgDialect;
import software.amazon.jdbc.exceptions.ExceptionHandler;
import software.amazon.jdbc.exceptions.MultiAzDbClusterPgExceptionHandler;
import software.amazon.jdbc.hostlistprovider.RdsMultiAzDbClusterListProvider;

public class RdsMultiAzDbClusterPgDialect
extends PgDialect {
    private static MultiAzDbClusterPgExceptionHandler exceptionHandler;
    private static final String TOPOLOGY_QUERY = "SELECT id, endpoint, port FROM rds_tools.show_topology('aws_jdbc_driver-2.3.6')";
    private static final String WRITER_NODE_FUNC_EXIST_QUERY = "SELECT 1 AS tmp FROM information_schema.routines WHERE routine_schema='rds_tools' AND routine_name='multi_az_db_cluster_source_dbi_resource_id'";
    private static final String FETCH_WRITER_NODE_QUERY = "SELECT multi_az_db_cluster_source_dbi_resource_id FROM rds_tools.multi_az_db_cluster_source_dbi_resource_id()";
    private static final String FETCH_WRITER_NODE_QUERY_COLUMN_NAME = "multi_az_db_cluster_source_dbi_resource_id";
    private static final String NODE_ID_QUERY = "SELECT dbi_resource_id FROM rds_tools.dbi_resource_id()";
    private static final String IS_READER_QUERY = "SELECT pg_is_in_recovery()";

    @Override
    public ExceptionHandler getExceptionHandler() {
        if (exceptionHandler == null) {
            exceptionHandler = new MultiAzDbClusterPgExceptionHandler();
        }
        return exceptionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDialect(Connection connection) {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = connection.createStatement();
            rs = stmt.executeQuery(WRITER_NODE_FUNC_EXIST_QUERY);
            if (rs.next()) {
                rs.close();
                stmt.close();
                stmt = connection.createStatement();
                rs = stmt.executeQuery(FETCH_WRITER_NODE_QUERY);
                boolean bl = rs.next();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return false;
    }

    @Override
    public List<String> getDialectUpdateCandidates() {
        return null;
    }

    @Override
    public HostListProviderSupplier getHostListProvider() {
        return (properties, initialUrl, hostListProviderService) -> new RdsMultiAzDbClusterListProvider(properties, initialUrl, hostListProviderService, TOPOLOGY_QUERY, NODE_ID_QUERY, IS_READER_QUERY, FETCH_WRITER_NODE_QUERY, FETCH_WRITER_NODE_QUERY_COLUMN_NAME);
    }
}

