/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.exceptions;

import java.sql.SQLException;
import java.util.List;
import software.amazon.jdbc.exceptions.ExceptionHandler;
import software.amazon.jdbc.exceptions.SQLLoginException;

public abstract class AbstractPgExceptionHandler
implements ExceptionHandler {
    public abstract List<String> getNetworkErrors();

    public abstract List<String> getAccessErrors();

    @Override
    public boolean isNetworkException(Throwable throwable) {
        for (Throwable exception = throwable; exception != null; exception = exception.getCause()) {
            if (!(exception instanceof SQLException)) continue;
            return this.isNetworkException(((SQLException)exception).getSQLState());
        }
        return false;
    }

    @Override
    public boolean isNetworkException(String sqlState) {
        if (sqlState == null) {
            return false;
        }
        for (String pgSqlState : this.getNetworkErrors()) {
            if (!sqlState.startsWith(pgSqlState)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isLoginException(Throwable throwable) {
        for (Throwable exception = throwable; exception != null; exception = exception.getCause()) {
            if (exception instanceof SQLLoginException) {
                return true;
            }
            if (!(exception instanceof SQLException)) continue;
            return this.isLoginException(((SQLException)exception).getSQLState());
        }
        return false;
    }

    @Override
    public boolean isLoginException(String sqlState) {
        if (sqlState == null) {
            return false;
        }
        return this.getAccessErrors().contains(sqlState);
    }
}

