/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.authentication;

import java.util.Properties;
import java.util.concurrent.locks.ReentrantLock;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.authentication.AwsCredentialsProviderHandler;
import software.amazon.jdbc.util.StringUtils;

public class AwsCredentialsManager {
    private static AwsCredentialsProviderHandler handler = null;
    private static final ReentrantLock lock = new ReentrantLock();

    public static void setCustomHandler(AwsCredentialsProviderHandler customHandler) {
        lock.lock();
        try {
            handler = customHandler;
        }
        finally {
            lock.unlock();
        }
    }

    public static void resetCustomHandler() {
        lock.lock();
        try {
            handler = null;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AwsCredentialsProvider getProvider(HostSpec hostSpec, Properties props) {
        lock.lock();
        try {
            AwsCredentialsProvider provider;
            AwsCredentialsProvider awsCredentialsProvider = provider = handler == null ? null : handler.getAwsCredentialsProvider(hostSpec, props);
            if (provider == null) {
                provider = AwsCredentialsManager.getDefaultProvider(PropertyDefinition.AWS_PROFILE.getString(props));
            }
            AwsCredentialsProvider awsCredentialsProvider2 = provider;
            return awsCredentialsProvider2;
        }
        finally {
            lock.unlock();
        }
    }

    private static AwsCredentialsProvider getDefaultProvider(@Nullable String awsProfileName) {
        DefaultCredentialsProvider.Builder builder = DefaultCredentialsProvider.builder();
        if (!StringUtils.isNullOrEmpty(awsProfileName)) {
            builder.profileName(awsProfileName);
        }
        return builder.build();
    }
}

