/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.authentication;

import java.util.Properties;
import java.util.concurrent.locks.ReentrantLock;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.authentication.AwsCredentialsProviderHandler;
import software.amazon.jdbc.util.Messages;

public class AwsCredentialsManager {
    private static AwsCredentialsProviderHandler handler = null;
    private static final ReentrantLock lock = new ReentrantLock();

    public static void setCustomHandler(AwsCredentialsProviderHandler customHandler) {
        lock.lock();
        try {
            handler = customHandler;
        }
        finally {
            lock.unlock();
        }
    }

    public static void resetCustomHandler() {
        lock.lock();
        try {
            handler = null;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AwsCredentialsProvider getProvider(HostSpec hostSpec, Properties props) {
        lock.lock();
        try {
            AwsCredentialsProvider provider;
            AwsCredentialsProvider awsCredentialsProvider = provider = handler != null ? handler.getAwsCredentialsProvider(hostSpec, props) : AwsCredentialsManager.getDefaultProvider();
            if (provider == null) {
                throw new IllegalArgumentException(Messages.get("AwsCredentialsManager.nullProvider"));
            }
            AwsCredentialsProvider awsCredentialsProvider2 = provider;
            return awsCredentialsProvider2;
        }
        finally {
            lock.unlock();
        }
    }

    private static AwsCredentialsProvider getDefaultProvider() {
        return DefaultCredentialsProvider.create();
    }
}

