/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.AwsWrapperProperty;
import software.amazon.jdbc.DriverConnectionProvider;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.targetdriverdialect.TargetDriverDialect;
import software.amazon.jdbc.targetdriverdialect.TargetDriverDialectManager;
import software.amazon.jdbc.util.ConnectionUrlParser;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.StringUtils;
import software.amazon.jdbc.util.telemetry.DefaultTelemetryFactory;
import software.amazon.jdbc.util.telemetry.TelemetryContext;
import software.amazon.jdbc.util.telemetry.TelemetryTraceLevel;
import software.amazon.jdbc.wrapper.ConnectionWrapper;

public class Driver
implements java.sql.Driver {
    private static final String PROTOCOL_PREFIX = "jdbc:aws-wrapper:";
    private static final Logger PARENT_LOGGER = Logger.getLogger("software.amazon.jdbc");
    private static final Logger LOGGER = Logger.getLogger("software.amazon.jdbc.Driver");
    private static @Nullable Driver registeredDriver;

    public static void register() throws SQLException {
        if (Driver.isRegistered()) {
            throw new IllegalStateException(Messages.get("Driver.alreadyRegistered"));
        }
        Driver driver = new Driver();
        DriverManager.registerDriver(driver);
        registeredDriver = driver;
    }

    public static void deregister() throws SQLException {
        if (registeredDriver == null) {
            throw new IllegalStateException(Messages.get("Driver.notRegistered"));
        }
        DriverManager.deregisterDriver(registeredDriver);
        registeredDriver = null;
    }

    public static boolean isRegistered() {
        if (registeredDriver != null) {
            ArrayList<java.sql.Driver> registeredDrivers = Collections.list(DriverManager.getDrivers());
            for (java.sql.Driver d : registeredDrivers) {
                if (d != registeredDriver) continue;
                return true;
            }
            registeredDriver = null;
        }
        return false;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        LOGGER.finest("Opening connection to " + url);
        String databaseName = ConnectionUrlParser.parseDatabaseFromUrl(url);
        if (!StringUtils.isNullOrEmpty(databaseName)) {
            PropertyDefinition.DATABASE.set(info, databaseName);
        }
        ConnectionUrlParser.parsePropertiesFromUrl(url, info);
        DefaultTelemetryFactory telemetryFactory = new DefaultTelemetryFactory(info);
        TelemetryContext context = telemetryFactory.openTelemetryContext("software.amazon.jdbc.Driver.connect", TelemetryTraceLevel.TOP_LEVEL);
        try {
            java.sql.Driver driver;
            String driverUrl = url.replaceFirst(PROTOCOL_PREFIX, "jdbc:");
            try {
                driver = DriverManager.getDriver(driverUrl);
            }
            catch (SQLException e) {
                List registeredDrivers2 = Collections.list(DriverManager.getDrivers()).stream().map(x -> x.getClass().getName()).collect(Collectors.toList());
                throw new SQLException(Messages.get("Driver.missingDriver", new Object[]{driverUrl, registeredDrivers2}), e);
            }
            if (driver == null) {
                List registeredDrivers = Collections.list(DriverManager.getDrivers()).stream().map(x -> x.getClass().getName()).collect(Collectors.toList());
                LOGGER.severe(() -> Messages.get("Driver.missingDriver", new Object[]{driverUrl, registeredDrivers}));
                Connection registeredDrivers2 = null;
                return registeredDrivers2;
            }
            String logLevelStr = PropertyDefinition.LOGGER_LEVEL.getString(info);
            if (!StringUtils.isNullOrEmpty(logLevelStr)) {
                Level logLevel = Level.parse(logLevelStr.toUpperCase());
                Logger rootLogger = Logger.getLogger("");
                for (Handler handler : rootLogger.getHandlers()) {
                    if (!(handler instanceof ConsoleHandler) || handler.getLevel().intValue() <= logLevel.intValue()) continue;
                    handler.setLevel(logLevel);
                }
                PARENT_LOGGER.setLevel(logLevel);
            }
            TargetDriverDialectManager targetDriverDialectManager = new TargetDriverDialectManager();
            TargetDriverDialect targetDriverDialect = targetDriverDialectManager.getDialect(driver, info);
            DriverConnectionProvider connectionProvider = new DriverConnectionProvider(driver, targetDriverDialect);
            ConnectionWrapper connectionWrapper = new ConnectionWrapper(info, driverUrl, connectionProvider, telemetryFactory);
            return connectionWrapper;
        }
        catch (Exception ex) {
            context.setException(ex);
            context.setSuccess(false);
            throw ex;
        }
        finally {
            context.closeContext();
        }
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            throw new SQLException(Messages.get("Driver.nullUrl"));
        }
        return url.startsWith(PROTOCOL_PREFIX);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        Properties copy = new Properties(info);
        String databaseName = ConnectionUrlParser.parseDatabaseFromUrl(url);
        if (!StringUtils.isNullOrEmpty(databaseName)) {
            PropertyDefinition.DATABASE.set(copy, databaseName);
        }
        ConnectionUrlParser.parsePropertiesFromUrl(url, copy);
        Collection<AwsWrapperProperty> knownProperties = PropertyDefinition.allProperties();
        DriverPropertyInfo[] props = new DriverPropertyInfo[knownProperties.size()];
        int i = 0;
        for (AwsWrapperProperty prop : knownProperties) {
            props[i++] = prop.toDriverPropertyInfo(copy);
        }
        return props;
    }

    @Override
    public int getMajorVersion() {
        return 2;
    }

    @Override
    public int getMinorVersion() {
        return 3;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return PARENT_LOGGER;
    }

    static {
        try {
            Driver.register();
        }
        catch (SQLException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

