/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.targetdriverdialect;

import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.mariadb.jdbc.MariaDbDataSource;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.util.ConnectionUrlBuilder;
import software.amazon.jdbc.util.Messages;

public class MariadbDataSourceHelper {
    private static final Logger LOGGER = Logger.getLogger(MariadbDataSourceHelper.class.getName());
    private static final String LOGIN_TIMEOUT = "loginTimeout";
    private static final String DS_CLASS_NAME = MariaDbDataSource.class.getName();

    public void prepareDataSource(@NonNull DataSource dataSource, @NonNull String protocol, @NonNull HostSpec hostSpec, @NonNull Properties props) throws SQLException {
        if (!(dataSource instanceof MariaDbDataSource)) {
            throw new SQLException(Messages.get("TargetDriverDialectManager.unexpectedClass", new Object[]{DS_CLASS_NAME, dataSource.getClass().getName()}));
        }
        MariaDbDataSource mariaDbDataSource = (MariaDbDataSource)dataSource;
        mariaDbDataSource.setUser(PropertyDefinition.USER.getString(props));
        mariaDbDataSource.setPassword(PropertyDefinition.PASSWORD.getString(props));
        String loginTimeoutValue = props.getProperty(LOGIN_TIMEOUT, null);
        if (loginTimeoutValue != null) {
            mariaDbDataSource.setLoginTimeout(Integer.parseInt(loginTimeoutValue));
            props.remove(LOGIN_TIMEOUT);
        }
        PropertyDefinition.removeAllExcept(props, PropertyDefinition.DATABASE.name);
        String finalUrl = ConnectionUrlBuilder.buildUrl(protocol, hostSpec, props);
        LOGGER.finest(() -> "Connecting to " + finalUrl);
        mariaDbDataSource.setUrl(finalUrl);
    }
}

