/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.dialect;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import software.amazon.jdbc.dialect.Dialect;
import software.amazon.jdbc.exceptions.ExceptionHandler;
import software.amazon.jdbc.exceptions.MariaDBExceptionHandler;

public class MariaDbDialect
implements Dialect {
    private static MariaDBExceptionHandler mariaDBExceptionHandler;

    @Override
    public int getDefaultPort() {
        return 3306;
    }

    @Override
    public ExceptionHandler getExceptionHandler() {
        if (mariaDBExceptionHandler == null) {
            mariaDBExceptionHandler = new MariaDBExceptionHandler();
        }
        return mariaDBExceptionHandler;
    }

    @Override
    public String getHostAliasQuery() {
        return "SELECT CONCAT(@@hostname, ':', @@port)";
    }

    @Override
    public String getServerVersionQuery() {
        return "SELECT VERSION()";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isDialect(Connection connection) {
        try (Statement stmt = connection.createStatement();
             ResultSet rs = stmt.executeQuery(this.getServerVersionQuery());){
            String columnValue;
            do {
                if (!rs.next()) return false;
            } while ((columnValue = rs.getString(1)) == null || !columnValue.toLowerCase().contains("mariadb"));
            boolean bl = true;
            return bl;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public List<String> getDialectUpdateCandidates() {
        return null;
    }
}

