/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.ConnectionProvider;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.HostSelector;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.RandomHostSelector;
import software.amazon.jdbc.dialect.Dialect;
import software.amazon.jdbc.exceptions.SQLLoginException;
import software.amazon.jdbc.targetdriverdialect.ConnectInfo;
import software.amazon.jdbc.targetdriverdialect.TargetDriverDialect;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.PropertyUtils;

public class DriverConnectionProvider
implements ConnectionProvider {
    private static final Logger LOGGER = Logger.getLogger(DriverConnectionProvider.class.getName());
    private static final Map<String, HostSelector> acceptedStrategies = Collections.unmodifiableMap(new HashMap<String, HostSelector>(){
        {
            this.put("random", new RandomHostSelector());
        }
    });
    private final Driver driver;
    private final @NonNull TargetDriverDialect targetDriverDialect;

    public DriverConnectionProvider(Driver driver, @NonNull TargetDriverDialect targetDriverDialect) {
        this.driver = driver;
        this.targetDriverDialect = targetDriverDialect;
    }

    @Override
    public boolean acceptsUrl(@NonNull String protocol, @NonNull HostSpec hostSpec, @NonNull Properties props) {
        return true;
    }

    @Override
    public boolean acceptsStrategy(@NonNull HostRole role, @NonNull String strategy) {
        return acceptedStrategies.containsKey(strategy);
    }

    @Override
    public HostSpec getHostSpecByStrategy(@NonNull List<HostSpec> hosts, @NonNull HostRole role, @NonNull String strategy) throws SQLException {
        if (!acceptedStrategies.containsKey(strategy)) {
            throw new UnsupportedOperationException(Messages.get("ConnectionProvider.unsupportedHostSpecSelectorStrategy", new Object[]{strategy, DriverConnectionProvider.class}));
        }
        return acceptedStrategies.get(strategy).getHost(hosts, role);
    }

    @Override
    public Connection connect(@NonNull String protocol, @NonNull Dialect dialect, @NonNull HostSpec hostSpec, @NonNull Properties props) throws SQLException {
        Properties copy = PropertyUtils.copyProperties(props);
        ConnectInfo connectInfo = this.targetDriverDialect.prepareConnectInfo(protocol, hostSpec, copy);
        LOGGER.finest(() -> "Connecting to " + connectInfo.url + PropertyUtils.logProperties(connectInfo.props, "\nwith properties: \n"));
        Connection conn = this.driver.connect(connectInfo.url, connectInfo.props);
        if (conn == null) {
            throw new SQLLoginException(Messages.get("ConnectionProvider.noConnection"));
        }
        return conn;
    }

    @Override
    @Deprecated
    public Connection connect(@NonNull String url, @NonNull Properties props) throws SQLException {
        LOGGER.finest(() -> "Connecting to " + url);
        return this.driver.connect(url, props);
    }
}

