/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.RdsUrlType;
import software.amazon.jdbc.util.RdsUtils;
import software.amazon.jdbc.util.StringUtils;

public class ConnectionUrlParser {
    private static final Logger LOGGER = Logger.getLogger(ConnectionUrlParser.class.getName());
    private static final String HOSTS_SEPARATOR = ",";
    static final String HOST_PORT_SEPARATOR = ":";
    static final Pattern CONNECTION_STRING_PATTERN = Pattern.compile("(?<protocol>[\\w(\\-)?+:%]+)\\s*(?://(?<hosts>[^/?#]*))?\\s*(?:[/?#].*)?");
    private static final RdsUtils rdsUtils = new RdsUtils();

    public List<HostSpec> getHostsFromConnectionUrl(String initialConnection, boolean singleWriterConnectionString) {
        String hosts;
        ArrayList<HostSpec> hostsList = new ArrayList<HostSpec>();
        Matcher matcher = CONNECTION_STRING_PATTERN.matcher(initialConnection);
        if (!matcher.matches()) {
            return hostsList;
        }
        String string = hosts = matcher.group("hosts") == null ? null : matcher.group("hosts").trim();
        if (hosts != null) {
            String[] hostArray = hosts.split(HOSTS_SEPARATOR);
            for (int i = 0; i < hostArray.length; ++i) {
                HostSpec host;
                if (singleWriterConnectionString) {
                    HostRole role = i > 0 ? HostRole.READER : HostRole.WRITER;
                    host = ConnectionUrlParser.parseHostPortPair(hostArray[i], role);
                } else {
                    host = ConnectionUrlParser.parseHostPortPair(hostArray[i]);
                }
                if (StringUtils.isNullOrEmpty(host.getHost())) continue;
                hostsList.add(host);
            }
        }
        return hostsList;
    }

    public static HostSpec parseHostPortPair(String url) {
        String[] hostPortPair = url.split(HOST_PORT_SEPARATOR, 2);
        RdsUrlType urlType = rdsUtils.identifyRdsType(hostPortPair[0]);
        HostRole hostRole = RdsUrlType.RDS_READER_CLUSTER.equals((Object)urlType) ? HostRole.READER : HostRole.WRITER;
        return ConnectionUrlParser.getHostSpec(hostPortPair, hostRole);
    }

    public static HostSpec parseHostPortPair(String url, HostRole role) {
        String[] hostPortPair = url.split(HOST_PORT_SEPARATOR, 2);
        return ConnectionUrlParser.getHostSpec(hostPortPair, role);
    }

    private static HostSpec getHostSpec(String[] hostPortPair, HostRole hostRole) {
        if (hostPortPair.length > 1) {
            String[] port = hostPortPair[1].split("/");
            int portValue = ConnectionUrlParser.parsePortAsInt(hostPortPair[1]);
            if (port.length > 1) {
                portValue = ConnectionUrlParser.parsePortAsInt(port[0]);
            }
            return new HostSpec(hostPortPair[0], portValue, hostRole);
        }
        return new HostSpec(hostPortPair[0], -1, hostRole);
    }

    private static int parsePortAsInt(String port) {
        try {
            return Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static String parseDatabaseFromUrl(String url) {
        String[] dbName = url.split("//")[1].split("\\?")[0].split("/");
        if (dbName.length == 1) {
            return null;
        }
        return dbName[1];
    }

    public static String parseUserFromUrl(String url) {
        Pattern userPattern = Pattern.compile("user=(?<username>[^&]*)");
        Matcher matcher = userPattern.matcher(url);
        if (matcher.find()) {
            return matcher.group("username");
        }
        return null;
    }

    public static String parsePasswordFromUrl(String url) {
        Pattern passwordPattern = Pattern.compile("password=(?<pass>[^&]*)");
        Matcher matcher = passwordPattern.matcher(url);
        if (matcher.find()) {
            return matcher.group("pass");
        }
        return null;
    }

    public static void parsePropertiesFromUrl(String url, Properties props) {
        String[] listOfParameters;
        String[] urlParameters = url.split("\\?");
        if (urlParameters.length == 1) {
            return;
        }
        for (String param : listOfParameters = urlParameters[1].split("&")) {
            String[] currentParameter = param.split("=");
            String currentParameterName = currentParameter[0];
            String currentParameterValue = "";
            if (currentParameter.length > 1) {
                currentParameterValue = ConnectionUrlParser.urlDecode(currentParameter[1]);
            }
            props.setProperty(currentParameterName, currentParameterValue);
        }
    }

    private static @Nullable String urlDecode(String url) {
        try {
            return StringUtils.decode(url);
        }
        catch (IllegalArgumentException e) {
            LOGGER.fine(() -> Messages.get("Driver.urlParsingFailed", new Object[]{url, e.getMessage()}));
            return null;
        }
    }
}

