/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.staledns;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.sql.Statement;
import java.util.EnumSet;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.JdbcCallable;
import software.amazon.jdbc.NodeChangeOptions;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.RdsUtils;
import software.amazon.jdbc.util.Utils;

public class AuroraStaleDnsHelper {
    private static final Logger LOGGER = Logger.getLogger(AuroraStaleDnsHelper.class.getName());
    private final PluginService pluginService;
    private final RdsUtils rdsUtils = new RdsUtils();
    private HostSpec writerHostSpec = null;
    private InetAddress writerHostAddress = null;
    private static final int RETRIES = 3;
    private static final String POSTGRESQL_READONLY_QUERY = "SELECT pg_is_in_recovery() AS is_reader";
    private static final String MYSQL_READONLY_QUERY = "SELECT @@innodb_read_only AS is_reader";
    private static final String IS_READER_COLUMN = "is_reader";

    public AuroraStaleDnsHelper(PluginService pluginService) {
        this.pluginService = pluginService;
    }

    public Connection getVerifiedConnection(String driverProtocol, HostSpec hostSpec, Properties props, JdbcCallable<Connection, SQLException> connectFunc) throws SQLException {
        String query;
        String string = query = driverProtocol.contains("postgresql") ? POSTGRESQL_READONLY_QUERY : MYSQL_READONLY_QUERY;
        if (!this.rdsUtils.isWriterClusterDns(hostSpec.getHost())) {
            return connectFunc.call();
        }
        Connection conn = connectFunc.call();
        InetAddress clusterInetAddress = null;
        try {
            clusterInetAddress = InetAddress.getByName(hostSpec.getHost());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        InetAddress hostInetAddress = clusterInetAddress;
        LOGGER.finest(() -> Messages.get("AuroraStaleDnsHelper.clusterEndpointDns", new Object[]{hostInetAddress}));
        if (clusterInetAddress == null) {
            return conn;
        }
        if (this.isReadOnly(conn, query)) {
            this.pluginService.forceRefreshHostList(conn);
        } else {
            this.pluginService.refreshHostList(conn);
        }
        LOGGER.finest(() -> Utils.logTopology(this.pluginService.getHosts()));
        if (this.writerHostSpec == null) {
            HostSpec writerCandidate = this.getWriter();
            if (writerCandidate != null && this.rdsUtils.isRdsClusterDns(writerCandidate.getHost())) {
                return null;
            }
            this.writerHostSpec = writerCandidate;
        }
        LOGGER.finest(() -> Messages.get("AuroraStaleDnsHelper.writerHostSpec", new Object[]{this.writerHostSpec}));
        if (this.writerHostSpec == null) {
            return conn;
        }
        if (this.writerHostAddress == null) {
            try {
                this.writerHostAddress = InetAddress.getByName(this.writerHostSpec.getHost());
            }
            catch (UnknownHostException writerCandidate) {
                // empty catch block
            }
        }
        LOGGER.finest(() -> Messages.get("AuroraStaleDnsHelper.writerInetAddress", new Object[]{this.writerHostAddress}));
        if (this.writerHostAddress == null) {
            return conn;
        }
        if (!this.writerHostAddress.equals(clusterInetAddress)) {
            LOGGER.fine(() -> Messages.get("AuroraStaleDnsHelper.staleDnsDetected", new Object[]{this.writerHostSpec}));
            Connection writerConn = this.pluginService.connect(this.writerHostSpec, props);
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                return writerConn;
            }
        }
        return conn;
    }

    public void notifyNodeListChanged(Map<String, EnumSet<NodeChangeOptions>> changes) {
        if (this.writerHostSpec == null) {
            return;
        }
        for (Map.Entry<String, EnumSet<NodeChangeOptions>> entry : changes.entrySet()) {
            LOGGER.finest(() -> String.format("[%s]: %s", entry.getKey(), entry.getValue()));
            if (!entry.getKey().equals(this.writerHostSpec.getUrl()) || !entry.getValue().contains((Object)NodeChangeOptions.PROMOTED_TO_READER)) continue;
            LOGGER.finest(() -> Messages.get("AuroraStaleDnsHelper.reset"));
            this.writerHostSpec = null;
            this.writerHostAddress = null;
        }
    }

    private HostSpec getWriter() {
        for (HostSpec host : this.pluginService.getHosts()) {
            if (host.getRole() != HostRole.WRITER) continue;
            return host;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isReadOnly(Connection connection, String query) throws SQLSyntaxErrorException {
        int i = 0;
        while (i < 3) {
            block34: {
                try (Statement statement = connection.createStatement();
                     ResultSet rs = statement.executeQuery(query);){
                    if (rs.next()) {
                        boolean bl = rs.getBoolean(IS_READER_COLUMN);
                        return bl;
                    }
                }
                catch (SQLSyntaxErrorException e) {
                    throw e;
                }
                catch (SQLException e) {
                    if (this.pluginService.isNetworkException(e)) break block34;
                    return false;
                }
            }
            ++i;
        }
        return false;
    }
}

