/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.efm;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import software.amazon.jdbc.util.Messages;

public class MonitorConnectionContext {
    private static final Logger LOGGER = Logger.getLogger(MonitorConnectionContext.class.getName());
    private final long failureDetectionIntervalMillis;
    private final long failureDetectionTimeMillis;
    private final long failureDetectionCount;
    private final Set<String> hostAliases;
    private final Connection connectionToAbort;
    private long startMonitorTime;
    private long invalidNodeStartTime;
    private long failureCount;
    private boolean nodeUnhealthy;
    private final AtomicBoolean activeContext = new AtomicBoolean(true);

    public MonitorConnectionContext(Connection connectionToAbort, Set<String> hostAliases, long failureDetectionTimeMillis, long failureDetectionIntervalMillis, long failureDetectionCount) {
        this.connectionToAbort = connectionToAbort;
        this.hostAliases = hostAliases;
        this.failureDetectionTimeMillis = failureDetectionTimeMillis;
        this.failureDetectionIntervalMillis = failureDetectionIntervalMillis;
        this.failureDetectionCount = failureDetectionCount;
    }

    void setStartMonitorTime(long startMonitorTimeNano) {
        this.startMonitorTime = startMonitorTimeNano;
    }

    Set<String> getHostAliases() {
        return this.hostAliases;
    }

    public long getFailureDetectionTimeMillis() {
        return this.failureDetectionTimeMillis;
    }

    public long getFailureDetectionIntervalMillis() {
        return this.failureDetectionIntervalMillis;
    }

    public long getFailureDetectionCount() {
        return this.failureDetectionCount;
    }

    public long getFailureCount() {
        return this.failureCount;
    }

    void setFailureCount(long failureCount) {
        this.failureCount = failureCount;
    }

    void setInvalidNodeStartTime(long invalidNodeStartTimeNano) {
        this.invalidNodeStartTime = invalidNodeStartTimeNano;
    }

    void resetInvalidNodeStartTime() {
        this.invalidNodeStartTime = 0L;
    }

    boolean isInvalidNodeStartTimeDefined() {
        return this.invalidNodeStartTime > 0L;
    }

    public long getInvalidNodeStartTime() {
        return this.invalidNodeStartTime;
    }

    public boolean isNodeUnhealthy() {
        return this.nodeUnhealthy;
    }

    void setNodeUnhealthy(boolean nodeUnhealthy) {
        this.nodeUnhealthy = nodeUnhealthy;
    }

    public boolean isActiveContext() {
        return this.activeContext.get();
    }

    public void invalidate() {
        this.activeContext.set(false);
    }

    synchronized void abortConnection() {
        if (this.connectionToAbort == null || !this.activeContext.get()) {
            return;
        }
        try {
            this.connectionToAbort.close();
        }
        catch (SQLException sqlEx) {
            LOGGER.finest(() -> Messages.get("MonitorConnectionContext.exceptionAbortingConnection", new Object[]{sqlEx.getMessage()}));
        }
    }

    public void updateConnectionStatus(long statusCheckStartTime, long currentTime, boolean isValid) {
        if (!this.activeContext.get()) {
            return;
        }
        long totalElapsedTimeNano = currentTime - this.startMonitorTime;
        if (totalElapsedTimeNano > TimeUnit.MILLISECONDS.toNanos(this.failureDetectionTimeMillis)) {
            this.setConnectionValid(isValid, statusCheckStartTime, currentTime);
        }
    }

    void setConnectionValid(boolean connectionValid, long statusCheckStartTime, long currentTime) {
        if (!connectionValid) {
            long maxInvalidNodeDurationMillis;
            long invalidNodeDurationNano;
            ++this.failureCount;
            if (!this.isInvalidNodeStartTimeDefined()) {
                this.setInvalidNodeStartTime(statusCheckStartTime);
            }
            if ((invalidNodeDurationNano = currentTime - this.getInvalidNodeStartTime()) >= TimeUnit.MILLISECONDS.toNanos(maxInvalidNodeDurationMillis = this.getFailureDetectionIntervalMillis() * Math.max(0L, this.getFailureDetectionCount()))) {
                LOGGER.fine(() -> Messages.get("MonitorConnectionContext.hostDead", new Object[]{this.hostAliases}));
                this.setNodeUnhealthy(true);
                this.abortConnection();
                return;
            }
            LOGGER.finest(() -> Messages.get("MonitorConnectionContext.hostNotResponding", new Object[]{this.hostAliases, this.getFailureCount()}));
            return;
        }
        this.setFailureCount(0L);
        this.resetInvalidNodeStartTime();
        this.setNodeUnhealthy(false);
        LOGGER.finest(() -> Messages.get("MonitorConnectionContext.hostAlive", new Object[]{this.hostAliases}));
    }
}

