/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.efm;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.AwsWrapperProperty;
import software.amazon.jdbc.HostAvailability;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.JdbcCallable;
import software.amazon.jdbc.NodeChangeOptions;
import software.amazon.jdbc.OldConnectionSuggestedAction;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.cleanup.CanReleaseResources;
import software.amazon.jdbc.plugin.AbstractConnectionPlugin;
import software.amazon.jdbc.plugin.efm.MonitorConnectionContext;
import software.amazon.jdbc.plugin.efm.MonitorService;
import software.amazon.jdbc.plugin.efm.MonitorServiceImpl;
import software.amazon.jdbc.util.Messages;

public class HostMonitoringConnectionPlugin
extends AbstractConnectionPlugin
implements CanReleaseResources {
    private static final Logger LOGGER = Logger.getLogger(HostMonitoringConnectionPlugin.class.getName());
    public static final AwsWrapperProperty FAILURE_DETECTION_ENABLED = new AwsWrapperProperty("failureDetectionEnabled", "true", "Enable failure detection logic (aka node monitoring thread).");
    public static final AwsWrapperProperty FAILURE_DETECTION_TIME = new AwsWrapperProperty("failureDetectionTime", "30000", "Interval in millis between sending SQL to the server and the first probe to database node.");
    public static final AwsWrapperProperty FAILURE_DETECTION_INTERVAL = new AwsWrapperProperty("failureDetectionInterval", "5000", "Interval in millis between probes to database node.");
    public static final AwsWrapperProperty FAILURE_DETECTION_COUNT = new AwsWrapperProperty("failureDetectionCount", "3", "Number of failed connection checks before considering database node unhealthy.");
    private static final Set<String> subscribedMethods = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("*")));
    private static final String MYSQL_RETRIEVE_HOST_PORT_SQL = "SELECT CONCAT(@@hostname, ':', @@port)";
    private static final String PG_RETRIEVE_HOST_PORT_SQL = "SELECT CONCAT(inet_server_addr(), ':', inet_server_port())";
    private static final List<String> METHODS_TO_SKIP_MONITORING = Arrays.asList(".get", ".abort", ".close", ".next", ".create");
    protected @NonNull Properties properties;
    private MonitorService monitorService;
    private final @NonNull Supplier<MonitorService> monitorServiceSupplier;
    private final Set<String> nodeKeys = new HashSet<String>();
    private final @NonNull PluginService pluginService;

    public HostMonitoringConnectionPlugin(@NonNull PluginService pluginService, @NonNull Properties properties) {
        this(pluginService, properties, () -> new MonitorServiceImpl(pluginService));
    }

    HostMonitoringConnectionPlugin(@NonNull PluginService pluginService, @NonNull Properties properties, @NonNull Supplier<MonitorService> monitorServiceSupplier) {
        if (pluginService == null) {
            throw new IllegalArgumentException("pluginService");
        }
        if (properties == null) {
            throw new IllegalArgumentException("properties");
        }
        this.pluginService = pluginService;
        this.properties = properties;
        this.monitorServiceSupplier = monitorServiceSupplier;
    }

    @Override
    public Set<String> getSubscribedMethods() {
        return subscribedMethods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, E extends Exception> T execute(Class<T> resultClass, Class<E> exceptionClass, Object methodInvokeOn, String methodName, JdbcCallable<T, E> jdbcMethodFunc, Object[] jdbcMethodArgs) throws E {
        T result;
        block12: {
            boolean isConnectionClosed;
            boolean isEnabled = FAILURE_DETECTION_ENABLED.getBoolean(this.properties);
            if (!isEnabled || !this.doesNeedMonitoring(methodName)) {
                return jdbcMethodFunc.call();
            }
            int failureDetectionTimeMillis = FAILURE_DETECTION_TIME.getInteger(this.properties);
            int failureDetectionIntervalMillis = FAILURE_DETECTION_INTERVAL.getInteger(this.properties);
            int failureDetectionCount = FAILURE_DETECTION_COUNT.getInteger(this.properties);
            this.initMonitorService();
            MonitorConnectionContext monitorContext = null;
            try {
                LOGGER.finest(() -> Messages.get("HostMonitoringConnectionPlugin.activatedMonitoring", new Object[]{methodName}));
                this.nodeKeys.clear();
                this.nodeKeys.addAll(this.pluginService.getCurrentHostSpec().asAliases());
                monitorContext = this.monitorService.startMonitoring(this.pluginService.getCurrentConnection(), this.nodeKeys, this.pluginService.getCurrentHostSpec(), this.properties, failureDetectionTimeMillis, failureDetectionIntervalMillis, failureDetectionCount);
                result = jdbcMethodFunc.call();
                if (monitorContext == null) break block12;
                this.monitorService.stopMonitoring(monitorContext);
            }
            catch (Throwable throwable) {
                if (monitorContext != null) {
                    boolean isConnectionClosed2;
                    this.monitorService.stopMonitoring(monitorContext);
                    try {
                        isConnectionClosed2 = this.pluginService.getCurrentConnection().isClosed();
                    }
                    catch (SQLException e) {
                        throw this.castException(exceptionClass, e);
                    }
                    if (monitorContext.isNodeUnhealthy()) {
                        this.pluginService.setAvailability(this.nodeKeys, HostAvailability.NOT_AVAILABLE);
                        if (!isConnectionClosed2) {
                            this.abortConnection();
                            throw this.castException(exceptionClass, new SQLException(Messages.get("HostMonitoringConnectionPlugin.unavailableNode", new Object[]{this.pluginService.getCurrentHostSpec().asAlias()})));
                        }
                    }
                }
                LOGGER.finest(() -> Messages.get("HostMonitoringConnectionPlugin.activatedMonitoring", new Object[]{methodName}));
                throw throwable;
            }
            try {
                isConnectionClosed = this.pluginService.getCurrentConnection().isClosed();
            }
            catch (SQLException e) {
                throw this.castException(exceptionClass, e);
            }
            if (monitorContext.isNodeUnhealthy()) {
                this.pluginService.setAvailability(this.nodeKeys, HostAvailability.NOT_AVAILABLE);
                if (!isConnectionClosed) {
                    this.abortConnection();
                    throw this.castException(exceptionClass, new SQLException(Messages.get("HostMonitoringConnectionPlugin.unavailableNode", new Object[]{this.pluginService.getCurrentHostSpec().asAlias()})));
                }
            }
        }
        LOGGER.finest(() -> Messages.get("HostMonitoringConnectionPlugin.activatedMonitoring", new Object[]{methodName}));
        return result;
    }

    private <E extends Exception> E castException(Class<E> exceptionClass, SQLException exceptionToCast) {
        if (exceptionClass.isAssignableFrom(SQLException.class)) {
            return (E)((Exception)exceptionClass.cast(exceptionToCast));
        }
        return (E)((Exception)exceptionClass.cast(new RuntimeException(exceptionToCast)));
    }

    void abortConnection() {
        try {
            this.pluginService.getCurrentConnection().close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected boolean doesNeedMonitoring(String methodName) {
        for (String method : METHODS_TO_SKIP_MONITORING) {
            if (!methodName.contains(method)) continue;
            return false;
        }
        return true;
    }

    private void initMonitorService() {
        if (this.monitorService == null) {
            this.monitorService = this.monitorServiceSupplier.get();
        }
    }

    @Override
    public void releaseResources() {
        if (this.monitorService != null) {
            this.monitorService.releaseResources();
        }
        this.monitorService = null;
    }

    private void generateHostAliases(@NonNull String driverProtocol, @NonNull Connection connection, @NonNull HostSpec hostSpec) {
        hostSpec.addAlias(hostSpec.asAlias());
        try (Statement stmt = connection.createStatement();
             ResultSet rs = stmt.executeQuery(this.getHostPortSql(driverProtocol));){
            while (rs.next()) {
                hostSpec.addAlias(rs.getString(1));
            }
        }
        catch (SQLException sqlException) {
            LOGGER.finest(() -> Messages.get("HostMonitoringConnectionPlugin.failedToRetrieveHostPort"));
        }
    }

    private String getHostPortSql(@NonNull String driverProtocol) {
        if (driverProtocol.startsWith("jdbc:postgresql:")) {
            return PG_RETRIEVE_HOST_PORT_SQL;
        }
        if (driverProtocol.startsWith("jdbc:mysql:")) {
            return MYSQL_RETRIEVE_HOST_PORT_SQL;
        }
        throw new UnsupportedOperationException(Messages.get("HostMonitoringConnectionPlugin.unsupportedDriverProtocol", new Object[]{driverProtocol}));
    }

    @Override
    public OldConnectionSuggestedAction notifyConnectionChanged(EnumSet<NodeChangeOptions> changes) {
        if (changes.contains((Object)NodeChangeOptions.WENT_DOWN) || changes.contains((Object)NodeChangeOptions.NODE_DELETED)) {
            if (!this.nodeKeys.isEmpty()) {
                this.monitorService.stopMonitoringForAllConnections(this.nodeKeys);
            }
            this.nodeKeys.clear();
            this.nodeKeys.addAll(this.pluginService.getCurrentHostSpec().getAliases());
        }
        return OldConnectionSuggestedAction.NO_OPINION;
    }

    @Override
    public Connection connect(@NonNull String driverProtocol, @NonNull HostSpec hostSpec, @NonNull Properties props, boolean isInitialConnection, @NonNull JdbcCallable<Connection, SQLException> connectFunc) throws SQLException {
        Connection conn = connectFunc.call();
        if (conn != null) {
            this.generateHostAliases(driverProtocol, conn, hostSpec);
        }
        return conn;
    }
}

