/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.AwsWrapperProperty;

public class PropertyDefinition {
    public static final AwsWrapperProperty LOG_UNCLOSED_CONNECTIONS = new AwsWrapperProperty("wrapperLogUnclosedConnections", "false", "Allows the driver to track a point in the code where connection has been opened and never closed after");
    public static final AwsWrapperProperty LOGGER_LEVEL = new AwsWrapperProperty("wrapperLoggerLevel", null, "Logger level of the driver", false, new String[]{"OFF", "SEVERE", "WARNING", "INFO", "CONFIG", "FINE", "FINER", "FINEST", "ALL"});
    public static final AwsWrapperProperty PLUGINS = new AwsWrapperProperty("wrapperPlugins", null, "Comma separated list of connection plugin codes");
    public static final AwsWrapperProperty PROFILE_NAME = new AwsWrapperProperty("wrapperProfileName", null, "Driver configuration profile name");
    public static final AwsWrapperProperty USER = new AwsWrapperProperty("user", null, "Driver user name");
    public static final AwsWrapperProperty PASSWORD = new AwsWrapperProperty("password", null, "Driver password");
    public static final AwsWrapperProperty DATABASE = new AwsWrapperProperty("database", null, "Driver database name");
    private static final Map<String, AwsWrapperProperty> PROPS_BY_NAME = new HashMap<String, AwsWrapperProperty>();

    public static @Nullable AwsWrapperProperty byName(String name) {
        return PROPS_BY_NAME.get(name);
    }

    public static Collection<AwsWrapperProperty> allProperties() {
        return PROPS_BY_NAME.values();
    }

    public static void removeAll(Properties props) {
        PROPS_BY_NAME.keySet().forEach(props::remove);
    }

    static {
        PROPS_BY_NAME.clear();
        Arrays.stream(PropertyDefinition.class.getDeclaredFields()).filter(f -> f.getType() == AwsWrapperProperty.class && Modifier.isPublic(f.getModifiers()) && Modifier.isStatic(f.getModifiers())).forEach(f -> {
            AwsWrapperProperty prop = null;
            try {
                prop = (AwsWrapperProperty)f.get(AwsWrapperProperty.class);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
            if (prop != null) {
                PROPS_BY_NAME.put(prop.name, prop);
            }
        });
    }
}

