/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.eventstream;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import software.amazon.eventstream.Message;
import software.amazon.eventstream.Prelude;

public final class MessageDecoder {
    private static final int INITIAL_BUFFER_SIZE = 0x200000;
    private final Consumer<Message> messageConsumer;
    private ByteBuffer buf;
    private Prelude currentPrelude;

    public MessageDecoder(Consumer<Message> messageConsumer) {
        this(messageConsumer, 0x200000);
    }

    MessageDecoder(Consumer<Message> messageConsumer, int initialBufferSize) {
        this.messageConsumer = messageConsumer;
        this.buf = ByteBuffer.allocate(initialBufferSize);
    }

    public void feed(byte[] bytes) {
        this.feed(bytes, 0, bytes.length);
    }

    public void feed(byte[] bytes, int offset, int length) {
        int bytesToRead = Math.min(bytes.length, length + offset);
        int bytesConsumed = offset;
        while (bytesConsumed < bytesToRead) {
            int numBytesToWrite;
            ByteBuffer readView = this.updateReadView();
            if (this.currentPrelude == null) {
                numBytesToWrite = Math.min(15 - readView.remaining(), bytesToRead - bytesConsumed);
                this.buf.put(bytes, bytesConsumed, numBytesToWrite);
                bytesConsumed += numBytesToWrite;
                readView = this.updateReadView();
                if (readView.remaining() >= 15) {
                    this.currentPrelude = Prelude.decode(readView.duplicate());
                    if (this.buf.capacity() < this.currentPrelude.getTotalLength()) {
                        this.buf = ByteBuffer.allocate(this.currentPrelude.getTotalLength());
                        this.buf.put(readView);
                        readView = this.updateReadView();
                    }
                }
            }
            if (this.currentPrelude == null) continue;
            numBytesToWrite = Math.min(this.currentPrelude.getTotalLength() - readView.remaining(), bytesToRead - bytesConsumed);
            this.buf.put(bytes, bytesConsumed, numBytesToWrite);
            bytesConsumed += numBytesToWrite;
            readView = this.updateReadView();
            if (readView.remaining() < this.currentPrelude.getTotalLength()) continue;
            this.messageConsumer.accept(Message.decode(this.currentPrelude, readView));
            this.buf.clear();
            this.currentPrelude = null;
        }
    }

    private ByteBuffer updateReadView() {
        return (ByteBuffer)this.buf.duplicate().flip();
    }

    int currentBufferSize() {
        return this.buf.capacity();
    }
}

