/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.materials;

import java.util.Map;
import org.apache.commons.logging.LogFactory;
import software.amazon.encryption.s3.S3EncryptionClient;
import software.amazon.encryption.s3.materials.DecryptionMaterials;
import software.amazon.encryption.s3.materials.EncryptionMaterials;
import software.amazon.encryption.s3.materials.MaterialsDescription;
import software.amazon.encryption.s3.materials.RawKeyMaterial;
import software.amazon.encryption.s3.materials.S3Keyring;

public abstract class RawKeyring<T>
extends S3Keyring {
    protected final MaterialsDescription _materialsDescription;
    protected final Map<MaterialsDescription, RawKeyMaterial<T>> _additionalDecryptionKeyMaterial;

    protected RawKeyring(Builder<?, ?, T> builder) {
        super(builder);
        this._materialsDescription = builder._materialsDescription;
        this._additionalDecryptionKeyMaterial = builder._additionalDecryptionKeyMaterial;
    }

    protected T findKeyMaterialForDecryption(DecryptionMaterials materials, T defaultKeyMaterial) {
        MaterialsDescription materialsDescription;
        RawKeyMaterial<T> matchingKeyMaterial;
        if (this._additionalDecryptionKeyMaterial != null && !this._additionalDecryptionKeyMaterial.isEmpty() && (matchingKeyMaterial = this._additionalDecryptionKeyMaterial.get(materialsDescription = materials.materialsDescription())) != null) {
            return matchingKeyMaterial.getKeyMaterial();
        }
        return defaultKeyMaterial;
    }

    public EncryptionMaterials modifyMaterialsForRawKeyring(EncryptionMaterials materials) {
        this.warnIfEncryptionContextIsPresent(materials);
        if (this._materialsDescription != null && !this._materialsDescription.isEmpty()) {
            materials = materials.toBuilder().materialsDescription(this._materialsDescription).build();
        }
        return materials;
    }

    public void warnIfEncryptionContextIsPresent(EncryptionMaterials materials) {
        materials.s3Request().overrideConfiguration().flatMap(overrideConfiguration -> overrideConfiguration.executionAttributes().getOptionalAttribute(S3EncryptionClient.ENCRYPTION_CONTEXT)).ifPresent(ctx -> LogFactory.getLog(this.getClass()).warn((Object)("Usage of Encryption Context provides no security benefit in " + this.getClass().getSimpleName() + ".Additionally, this Encryption Context WILL NOT be stored in the material description. Provide a MaterialDescription in the Keyring's builder instead.")));
    }

    public static abstract class Builder<KeyringT extends RawKeyring<T>, BuilderT extends Builder<KeyringT, BuilderT, T>, T>
    extends S3Keyring.Builder<KeyringT, BuilderT> {
        protected MaterialsDescription _materialsDescription;
        protected Map<MaterialsDescription, RawKeyMaterial<T>> _additionalDecryptionKeyMaterial;

        protected Builder() {
        }

        public BuilderT materialsDescription(MaterialsDescription materialsDescription) {
            this._materialsDescription = materialsDescription;
            return (BuilderT)((Builder)this.builder());
        }

        public BuilderT additionalDecryptionKeyMaterial(Map<MaterialsDescription, RawKeyMaterial<T>> additionalDecryptionKeyMaterial) {
            this._additionalDecryptionKeyMaterial = additionalDecryptionKeyMaterial;
            return (BuilderT)((Builder)this.builder());
        }
    }
}

