/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.internal;

import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.crypto.Cipher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.utils.BinaryUtils;
import software.amazon.encryption.s3.S3EncryptionClientSecurityException;
import software.amazon.encryption.s3.materials.CryptographicMaterials;

public class CipherSubscriber
implements Subscriber<ByteBuffer> {
    private final AtomicLong contentRead = new AtomicLong(0L);
    private final Subscriber<? super ByteBuffer> wrappedSubscriber;
    private final Cipher cipher;
    private final Long contentLength;
    private final boolean isLastPart;
    private final int tagLength;
    private final AtomicBoolean finalBytesCalled = new AtomicBoolean(false);
    private byte[] outputBuffer;

    CipherSubscriber(Subscriber<? super ByteBuffer> wrappedSubscriber, Long contentLength, CryptographicMaterials materials, byte[] iv, boolean isLastPart) {
        this.wrappedSubscriber = wrappedSubscriber;
        this.contentLength = contentLength;
        this.cipher = materials.getCipher(iv);
        this.isLastPart = isLastPart;
        this.tagLength = materials.algorithmSuite().cipherTagLengthBytes();
    }

    CipherSubscriber(Subscriber<? super ByteBuffer> wrappedSubscriber, Long contentLength, CryptographicMaterials materials, byte[] iv) {
        this(wrappedSubscriber, contentLength, materials, iv, true);
    }

    public void onSubscribe(Subscription s) {
        this.wrappedSubscriber.onSubscribe(s);
    }

    public void onNext(ByteBuffer byteBuffer) {
        int amountToReadFromByteBuffer = this.getAmountToReadFromByteBuffer(byteBuffer);
        if (amountToReadFromByteBuffer > 0) {
            byte[] buf = BinaryUtils.copyBytesFrom((ByteBuffer)byteBuffer, (int)amountToReadFromByteBuffer);
            this.outputBuffer = this.cipher.update(buf, 0, amountToReadFromByteBuffer);
            if (this.outputBuffer == null || this.outputBuffer.length == 0) {
                if (this.contentRead.get() + (long)this.tagLength >= this.contentLength) {
                    this.finalBytes();
                    return;
                }
                this.wrappedSubscriber.onNext((Object)ByteBuffer.allocate(0));
            } else if (this.contentRead.get() + (long)this.tagLength >= this.contentLength) {
                this.finalBytes();
            } else {
                this.wrappedSubscriber.onNext((Object)ByteBuffer.wrap(this.outputBuffer));
            }
        } else {
            this.wrappedSubscriber.onNext((Object)byteBuffer);
        }
    }

    private int getAmountToReadFromByteBuffer(ByteBuffer byteBuffer) {
        if (this.contentLength == null) {
            return byteBuffer.remaining();
        }
        long amountReadSoFar = this.contentRead.getAndAdd(byteBuffer.remaining());
        long amountRemaining = Math.max(0L, this.contentLength - amountReadSoFar);
        if (amountRemaining > (long)byteBuffer.remaining()) {
            return byteBuffer.remaining();
        }
        return Math.toIntExact(amountRemaining);
    }

    public void onError(Throwable t) {
        this.wrappedSubscriber.onError(t);
    }

    public void onComplete() {
        if (this.contentRead.get() + (long)this.tagLength <= this.contentLength) {
            this.finalBytes();
        }
        this.wrappedSubscriber.onComplete();
    }

    private void finalBytes() {
        byte[] combinedBytes;
        byte[] finalBytes;
        if (!this.finalBytesCalled.compareAndSet(false, true)) {
            return;
        }
        if (!this.isLastPart) {
            this.wrappedSubscriber.onNext((Object)ByteBuffer.wrap(this.outputBuffer));
            return;
        }
        try {
            finalBytes = this.cipher.doFinal();
        }
        catch (GeneralSecurityException exception) {
            this.wrappedSubscriber.onNext((Object)ByteBuffer.wrap(this.outputBuffer));
            this.wrappedSubscriber.onError((Throwable)exception);
            throw new S3EncryptionClientSecurityException(exception.getMessage(), exception);
        }
        if (this.outputBuffer != null && this.outputBuffer.length > 0 && finalBytes != null && finalBytes.length > 0) {
            combinedBytes = new byte[this.outputBuffer.length + finalBytes.length];
            System.arraycopy(this.outputBuffer, 0, combinedBytes, 0, this.outputBuffer.length);
            System.arraycopy(finalBytes, 0, combinedBytes, this.outputBuffer.length, finalBytes.length);
        } else {
            combinedBytes = this.outputBuffer != null && this.outputBuffer.length > 0 ? this.outputBuffer : (finalBytes != null && finalBytes.length > 0 ? finalBytes : new byte[]{});
        }
        this.wrappedSubscriber.onNext((Object)ByteBuffer.wrap(combinedBytes));
    }
}

