/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.internal;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.protocols.jsoncore.JsonNode;
import software.amazon.awssdk.protocols.jsoncore.JsonNodeParser;
import software.amazon.awssdk.protocols.jsoncore.JsonWriter;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.encryption.s3.S3EncryptionClientException;
import software.amazon.encryption.s3.algorithms.AlgorithmSuite;
import software.amazon.encryption.s3.internal.ContentMetadata;
import software.amazon.encryption.s3.internal.ContentMetadataDecodingStrategy;
import software.amazon.encryption.s3.internal.ContentMetadataEncodingStrategy;
import software.amazon.encryption.s3.materials.EncryptedDataKey;
import software.amazon.encryption.s3.materials.EncryptionMaterials;

public abstract class ContentMetadataStrategy
implements ContentMetadataEncodingStrategy,
ContentMetadataDecodingStrategy {
    private static final Base64.Encoder ENCODER = Base64.getEncoder();
    private static final Base64.Decoder DECODER = Base64.getDecoder();
    public static final ContentMetadataDecodingStrategy INSTRUCTION_FILE = new ContentMetadataDecodingStrategy(){

        @Override
        public ContentMetadata decodeMetadata(GetObjectRequest getObjectRequest, GetObjectResponse response) {
            ResponseInputStream instruction;
            GetObjectRequest instructionGetObjectRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(getObjectRequest.bucket()).key(getObjectRequest.key() + ".instruction").build();
            S3Client s3Client = S3Client.create();
            try {
                instruction = s3Client.getObject(instructionGetObjectRequest);
            }
            catch (NoSuchKeyException exception) {
                throw new S3EncryptionClientException("Instruction file not found! Please ensure the object you are attempting to decrypt has been encrypted using the S3 Encryption Client.", exception);
            }
            HashMap<String, String> metadata = new HashMap<String, String>();
            JsonNodeParser parser = JsonNodeParser.create();
            JsonNode objectNode = parser.parse((InputStream)instruction);
            for (Map.Entry entry : objectNode.asObject().entrySet()) {
                metadata.put((String)entry.getKey(), ((JsonNode)entry.getValue()).asString());
            }
            return ContentMetadataStrategy.readFromMap(metadata, response);
        }
    };
    public static final ContentMetadataStrategy OBJECT_METADATA = new ContentMetadataStrategy(){

        @Override
        public Map<String, String> encodeMetadata(EncryptionMaterials materials, byte[] iv, Map<String, String> metadata) {
            EncryptedDataKey edk = materials.encryptedDataKeys().get(0);
            metadata.put("x-amz-key-v2", ENCODER.encodeToString(edk.encryptedDatakey()));
            metadata.put("x-amz-iv", ENCODER.encodeToString(iv));
            metadata.put("x-amz-cek-alg", materials.algorithmSuite().cipherName());
            metadata.put("x-amz-tag-len", Integer.toString(materials.algorithmSuite().cipherTagLengthBits()));
            metadata.put("x-amz-wrap-alg", new String(edk.keyProviderInfo(), StandardCharsets.UTF_8));
            try (JsonWriter jsonWriter = JsonWriter.create();){
                jsonWriter.writeStartObject();
                for (Map.Entry<String, String> entry : materials.encryptionContext().entrySet()) {
                    jsonWriter.writeFieldName(entry.getKey()).writeValue(entry.getValue());
                }
                jsonWriter.writeEndObject();
                String jsonEncryptionContext = new String(jsonWriter.getBytes(), StandardCharsets.UTF_8);
                metadata.put("x-amz-matdesc", jsonEncryptionContext);
            }
            catch (JsonWriter.JsonGenerationException e) {
                throw new S3EncryptionClientException("Cannot serialize encryption context to JSON.", e);
            }
            return metadata;
        }

        @Override
        public ContentMetadata decodeMetadata(GetObjectRequest request, GetObjectResponse response) {
            return ContentMetadataStrategy.readFromMap(response.metadata(), response);
        }
    };

    private static ContentMetadata readFromMap(Map<String, String> metadata, GetObjectResponse response) {
        String keyProviderInfo;
        byte[] edkCiphertext;
        AlgorithmSuite algorithmSuite;
        String contentEncryptionAlgorithm = metadata.get("x-amz-cek-alg");
        String contentRange = response.contentRange();
        if (contentEncryptionAlgorithm == null || contentEncryptionAlgorithm.equals(AlgorithmSuite.ALG_AES_256_CBC_IV16_NO_KDF.cipherName())) {
            algorithmSuite = AlgorithmSuite.ALG_AES_256_CBC_IV16_NO_KDF;
        } else if (contentEncryptionAlgorithm.equals(AlgorithmSuite.ALG_AES_256_GCM_IV12_TAG16_NO_KDF.cipherName())) {
            algorithmSuite = contentRange == null ? AlgorithmSuite.ALG_AES_256_GCM_IV12_TAG16_NO_KDF : AlgorithmSuite.ALG_AES_256_CTR_IV16_TAG16_NO_KDF;
        } else {
            throw new S3EncryptionClientException("Unknown content encryption algorithm: " + contentEncryptionAlgorithm);
        }
        String keyProviderId = "S3Keyring";
        switch (algorithmSuite) {
            case ALG_AES_256_CBC_IV16_NO_KDF: {
                if (metadata.containsKey("x-amz-key")) {
                    edkCiphertext = DECODER.decode(metadata.get("x-amz-key"));
                } else if (metadata.containsKey("x-amz-key-v2")) {
                    edkCiphertext = DECODER.decode(metadata.get("x-amz-key-v2"));
                } else {
                    throw new S3EncryptionClientException("Malformed object metadata! Could not find the encrypted data key.");
                }
                if (!metadata.containsKey("x-amz-wrap-alg")) {
                    if (edkCiphertext.length > 48) {
                        keyProviderInfo = "RSA";
                        break;
                    }
                    keyProviderInfo = "AES";
                    break;
                }
                keyProviderInfo = metadata.get("x-amz-wrap-alg");
                break;
            }
            case ALG_AES_256_GCM_IV12_TAG16_NO_KDF: 
            case ALG_AES_256_CTR_IV16_TAG16_NO_KDF: {
                int tagLength = Integer.parseInt(metadata.get("x-amz-tag-len"));
                if (tagLength != algorithmSuite.cipherTagLengthBits()) {
                    throw new S3EncryptionClientException("Expected tag length (bits) of: " + algorithmSuite.cipherTagLengthBits() + ", got: " + tagLength);
                }
                edkCiphertext = DECODER.decode(metadata.get("x-amz-key-v2"));
                keyProviderInfo = metadata.get("x-amz-wrap-alg");
                break;
            }
            default: {
                throw new S3EncryptionClientException("Unknown content encryption algorithm: " + algorithmSuite.id());
            }
        }
        EncryptedDataKey edk = EncryptedDataKey.builder().encryptedDataKey(edkCiphertext).keyProviderId("S3Keyring").keyProviderInfo(keyProviderInfo.getBytes(StandardCharsets.UTF_8)).build();
        HashMap<String, String> encryptionContext = new HashMap<String, String>();
        String jsonEncryptionContext = metadata.get("x-amz-matdesc");
        try {
            JsonNodeParser parser = JsonNodeParser.create();
            JsonNode objectNode = parser.parse(jsonEncryptionContext);
            for (Map.Entry entry : objectNode.asObject().entrySet()) {
                encryptionContext.put((String)entry.getKey(), ((JsonNode)entry.getValue()).asString());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        byte[] iv = DECODER.decode(metadata.get("x-amz-iv"));
        return ContentMetadata.builder().algorithmSuite(algorithmSuite).encryptedDataKey(edk).encryptedDataKeyContext(encryptionContext).contentIv(iv).contentRange(contentRange).build();
    }

    public static ContentMetadata decode(GetObjectRequest request, GetObjectResponse response) {
        Map metadata = response.metadata();
        ContentMetadataDecodingStrategy strategy = metadata != null && metadata.containsKey("x-amz-iv") && (metadata.containsKey("x-amz-key") || metadata.containsKey("x-amz-key-v2")) ? OBJECT_METADATA : INSTRUCTION_FILE;
        return strategy.decodeMetadata(request, response);
    }
}

