/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.internal;

import java.nio.ByteBuffer;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.encryption.s3.internal.BufferedCipherSubscriber;
import software.amazon.encryption.s3.legacy.internal.RangedGetUtils;
import software.amazon.encryption.s3.materials.CryptographicMaterials;

public class BufferedCipherPublisher
implements SdkPublisher<ByteBuffer> {
    private final SdkPublisher<ByteBuffer> wrappedPublisher;
    private final Long contentLength;
    private final long[] range;
    private final String contentRange;
    private final int cipherTagLengthBits;
    private final CryptographicMaterials materials;
    private final byte[] iv;

    public BufferedCipherPublisher(SdkPublisher<ByteBuffer> wrappedPublisher, Long contentLength, long[] range, String contentRange, int cipherTagLengthBits, CryptographicMaterials materials, byte[] iv) {
        this.wrappedPublisher = wrappedPublisher;
        this.contentLength = contentLength;
        this.range = range;
        this.contentRange = contentRange;
        this.cipherTagLengthBits = cipherTagLengthBits;
        this.materials = materials;
        this.iv = iv;
    }

    public void subscribe(Subscriber<? super ByteBuffer> subscriber) {
        Subscriber<? super ByteBuffer> wrappedSubscriber = RangedGetUtils.adjustToDesiredRange(subscriber, this.range, this.contentRange, this.cipherTagLengthBits);
        this.wrappedPublisher.subscribe((Subscriber)new BufferedCipherSubscriber(wrappedSubscriber, this.contentLength, this.materials, this.iv));
    }
}

